/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers;

import ch.dvbern.tax.common.engine.DMK;
import ch.dvbern.tax.common.engine.LMK;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.modelitems.Table;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.PdfForm;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.PdfValue;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.RunContext;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.TableRow;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers.AbstractResolver;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers.PdfKey;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.Float2Converter;
import ch.dvbern.tax.common.transfer.dto.convert.FloatConverter;
import ch.dvbern.tax.common.transfer.dto.convert.IntConverter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataModelResolver
extends AbstractResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DataModelResolver.class);
    private final @NonNull Localization localization;

    public DataModelResolver(@NonNull Localization localization) {
        super("model");
        this.localization = Objects.requireNonNull(localization);
    }

    static @NonNull Pair<DMK, ModelItemDTO> getDmkModelItemDTOPair(@NonNull PdfKey pdfKey, @Nullable TableRow tableRow, @NonNull PdfForm page, @NonNull RunContext ctx, LMK lmk) {
        Pair result;
        if (pdfKey.isTableKey()) {
            if (tableRow == null) {
                throw new IllegalStateException("pdfKey hat Tabellensyntax, wurde aber nicht als Table erkannt: " + String.valueOf(pdfKey) + ", page: " + String.valueOf(page));
            }
            DMK dmk = null;
            LMK mappedColumn = tableRow.getMappingFor(lmk);
            dmk = mappedColumn != null ? tableRow.getTableRowDMK().merge(mappedColumn) : tableRow.getTableRowDMK().merge(lmk);
            ModelItemDTO valueMiDTO = ctx.getInput().getDataModelMap().get(dmk.toExternalForm());
            result = Pair.of((Object)dmk, (Object)valueMiDTO);
        } else {
            DMK dmk = lmk.toRootlevelDMK();
            ModelItemDTO valueMiDTO = ctx.getInput().getDataModelMap().get(dmk.toExternalForm());
            result = Pair.of((Object)dmk, (Object)valueMiDTO);
        }
        return result;
    }

    @Override
    public boolean validate(@NonNull PdfKey pdfKey, @Nullable TableRow tableRow, @NonNull RunContext ctx) {
        try {
            LMK lmk = new LMK(pdfKey.getPath());
            return ctx.getInput().getLogicModelItems().containsKey(lmk.toExternalForm());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("not a valid PDFKey: " + String.valueOf(pdfKey), e);
        }
    }

    @Override
    public @Nullable LMK tableLMK(@NonNull PdfKey pdfKey, @NonNull RunContext ctx) {
        if (!pdfKey.isTableKey()) {
            return null;
        }
        LMK lmk = new LMK(pdfKey.getPath());
        LogicModelItem lmi = ctx.getInput().getLogicModelItems().get(lmk.toExternalForm());
        if (lmi == null) {
            LOG.error("Could not find LMK: {}, {}", (Object)lmk, (Object)pdfKey);
            return null;
        }
        Table outermostTableLmi = lmi.findOutermostTableLmi();
        if (outermostTableLmi == null) {
            return null;
        }
        LMK tableLMK = LMK.parse(outermostTableLmi.getName());
        return tableLMK;
    }

    @Override
    public @Nullable Object resolve(@NonNull PdfKey pdfKey, @Nullable TableRow tableRow, @NonNull PdfForm page, @NonNull RunContext ctx) {
        LMK lmk = new LMK(pdfKey.getPath());
        Pair<DMK, ModelItemDTO> result = DataModelResolver.getDmkModelItemDTOPair(pdfKey, tableRow, page, ctx, lmk);
        if (result.getValue() != null && ((ModelItemDTO)result.getValue()).getState() <= 11) {
            Object valueFromModel = this.getValueFromDataModel(ctx, (DMK)result.getKey(), (ModelItemDTO)result.getValue());
            return valueFromModel;
        }
        return null;
    }

    @Override
    public @NonNull String formatValue(@NonNull PdfKey pdfKey, @Nullable TableRow tableRow, @NonNull PdfValue resolvedValue, @NonNull RunContext ctx) {
        String textValue = null;
        switch (resolvedValue.getFieldType()) {
            case TEXT: {
                textValue = resolvedValue.getValue() == null ? "" : String.valueOf(resolvedValue.getValue());
                break;
            }
            case BOOLEAN: {
                textValue = Boolean.TRUE.equals(resolvedValue.getValue()) ? ctx.getInput().getBooleanTrueText() : ctx.getInput().getBooleanFalseText();
                return textValue;
            }
            case DATE: {
                SimpleDateFormat sdf = new SimpleDateFormat(ctx.getInput().getDateFormat(), ctx.getInput().getLocalizationHelper().getCurrentLocale());
                try {
                    textValue = this.formatAnyDateCalendar(sdf, resolvedValue.getValue());
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Cannot format: " + String.valueOf(resolvedValue), e);
                }
            }
            case YEAR: {
                Calendar yearValue = (Calendar)resolvedValue.getValue();
                assert (yearValue != null);
                textValue = String.valueOf(yearValue.get(1));
                break;
            }
            case INTEGER: 
            case INTEGER_PRINT_ZERO: 
            case DECIMAL: 
            case DECIMAL_PRINT_ZERO: {
                textValue = this.getStringNumberValue(resolvedValue);
                break;
            }
            case UNKNOWN: {
                if (resolvedValue.getValue() != null) {
                    LOG.warn("Unknown fieldType for: {}", (Object)resolvedValue);
                }
                textValue = resolvedValue.getValue() == null ? "" : String.valueOf(resolvedValue.getValue());
            }
        }
        return textValue;
    }

    private String formatAnyDateCalendar(@NonNull SimpleDateFormat sdf, @Nullable Object value) {
        if (value == null) {
            return "";
        }
        Date dateValue = null;
        if (value instanceof Date) {
            dateValue = (Date)value;
        } else if (value instanceof Calendar) {
            dateValue = ((Calendar)value).getTime();
        } else {
            throw new IllegalArgumentException("Date object not supported: " + String.valueOf(value));
        }
        String formatted = sdf.format(dateValue);
        return formatted;
    }

    private @NonNull String getStringNumberValue(@NonNull PdfValue formPrinterItem) {
        Number value = (Number)formPrinterItem.getValue();
        if (PdfValue.FieldType.INTEGER == formPrinterItem.getFieldType() || PdfValue.FieldType.INTEGER_PRINT_ZERO == formPrinterItem.getFieldType()) {
            return IntConverter.getRenderValue(value, false, PdfValue.FieldType.INTEGER_PRINT_ZERO == formPrinterItem.getFieldType());
        }
        if (PdfValue.FieldType.DECIMAL == formPrinterItem.getFieldType() || PdfValue.FieldType.DECIMAL_PRINT_ZERO == formPrinterItem.getFieldType()) {
            return FloatConverter.getRenderedValue(value, false, Float2Converter.df_float_2);
        }
        return "";
    }

    private @Nullable Object getValueFromDataModel(@NonNull RunContext ctx, @NonNull DMK dmk, @Nullable ModelItemDTO miDTO) {
        if (miDTO == null) {
            return null;
        }
        if (miDTO.getState() >= 12) {
            return null;
        }
        Object value = miDTO.getValue();
        LMK lmk = dmk.toLMK();
        LogicModelItem lmi = ctx.getInput().getLogicModelItems().get(lmk.toExternalForm());
        if (!(lmi instanceof LogicModelItem.SelectItem)) {
            return value;
        }
        Object selectItemValue = this.getSelectItemValue((LogicModelItem.SelectItem)((Object)lmi), dmk, value, ctx);
        return selectItemValue;
    }

    private @Nullable Object getSelectItemValue(@NonNull LogicModelItem.SelectItem selectItem, @NonNull DMK dmk, @Nullable Object value, @NonNull RunContext ctx) {
        String optionKey;
        if (this.localization == Localization.RAW_VALUE) {
            return value;
        }
        OptionItemsDTO optionItems = selectItem.getOptionItems(new LogicModelItem.ProtectedMap(ctx.getInput().getDataModelMap(), false), dmk.toExternalForm());
        OptionItemDTO optionItemDTO = optionItems.get(optionKey = String.valueOf(value), ctx.getInput().getLocalizationHelper().getCurrentLocale());
        if (optionItemDTO != null) {
            Object text = null;
            switch (this.localization.ordinal()) {
                case 1: {
                    text = optionItemDTO.getText();
                    break;
                }
                case 2: {
                    text = optionItemDTO.getShortText();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("localization failed: " + String.valueOf((Object)this.localization) + "@" + String.valueOf(dmk));
                }
            }
            if (optionItemDTO.isResourceKey()) {
                String translated = ctx.getInput().getLocalizationHelper().translate(String.valueOf(text), new Object[0]);
                return translated;
            }
            return text;
        }
        return null;
    }

    public static enum Localization {
        RAW_VALUE,
        LOCALIZED_TEXT,
        LOCALIZED_SHORT_TEXT;

    }
}

