/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers;

import ch.dvbern.tax.common.engine.DMK;
import ch.dvbern.tax.common.engine.LMK;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.PdfForm;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.RunContext;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.TableRow;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers.DataModelDelegateResolver;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers.DataModelResolver;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers.PdfKey;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.Float2Converter;
import ch.dvbern.tax.common.transfer.dto.convert.IntConverter;
import org.apache.commons.lang3.tuple.Pair;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NestedTableResolver
extends DataModelDelegateResolver {
    public static final String NESTED = "nested";
    private static final Logger LOG = LoggerFactory.getLogger(NestedTableResolver.class);

    public NestedTableResolver() {
        this(NESTED);
    }

    public NestedTableResolver(@NonNull String scheme) {
        super(scheme, new DataModelResolver(DataModelResolver.Localization.LOCALIZED_TEXT));
    }

    @Override
    public boolean validate(@NonNull PdfKey pdfKey, @Nullable TableRow tableRow, @NonNull RunContext ctx) {
        if (!pdfKey.getPath().contains("@")) {
            return false;
        }
        LMK lmk = this.getLmk(pdfKey);
        return ctx.getInput().getLogicModelItems().containsKey(lmk.toExternalForm());
    }

    @Override
    public @Nullable LMK tableLMK(@NonNull PdfKey pdfKey, @NonNull RunContext ctx) {
        if (!pdfKey.getUri().toString().contains("@") && !pdfKey.isTableKey()) {
            LOG.error("ERROR in PDF missing @ in : {}", (Object)pdfKey);
        }
        LMK lmk = this.getLmk(pdfKey);
        LogicModelItem lmi = ctx.getInput().getLogicModelItems().get(lmk.toExternalForm());
        if (lmi == null) {
            LOG.error("Could not find LMK: {}, {}", (Object)lmk, (Object)pdfKey);
            return null;
        }
        int atinedx = pdfKey.getPath().indexOf("@");
        String atTablep = pdfKey.getPath().substring(0, pdfKey.getPath().indexOf(".", atinedx));
        LMK tableLMK = LMK.parse(atTablep.replaceAll("@", ""));
        return tableLMK;
    }

    private @NonNull LMK getLmk(@NonNull PdfKey pdfKey) {
        return new LMK(pdfKey.getPath().replaceAll("@", ""));
    }

    @Override
    public @Nullable Object resolve(@NonNull PdfKey pdfKey, @Nullable TableRow tableRow, @NonNull PdfForm page, @NonNull RunContext ctx) {
        Pair<DMK, ModelItemDTO> result = null;
        LMK lmk = this.getLmk(pdfKey);
        result = DataModelResolver.getDmkModelItemDTOPair(pdfKey, tableRow, page, ctx, lmk);
        if (result.getValue() != null && ((ModelItemDTO)result.getValue()).getState() <= 11) {
            Object valueFromModel = this.getValueFromDataModel(ctx, (DMK)result.getKey(), (ModelItemDTO)result.getValue());
            if (valueFromModel instanceof Number) {
                if (valueFromModel instanceof Integer || valueFromModel instanceof Long) {
                    return IntConverter.getRenderValue(valueFromModel, false, false);
                }
                return Float2Converter.getRenderedValue(valueFromModel, false, Float2Converter.df_float_2);
            }
            return valueFromModel;
        }
        return null;
    }

    private @Nullable Object getValueFromDataModel(@NonNull RunContext ctx, @NonNull DMK dmkX, @Nullable ModelItemDTO miDTO) {
        String optionKey;
        if (miDTO == null) {
            return null;
        }
        if (miDTO.getState() >= 12) {
            return null;
        }
        Object value = miDTO.getValue();
        String dmk = dmkX.toExternalForm();
        String lmk = EngineUtil.removeTableIndices(dmk);
        LogicModelItem lmi = ctx.getInput().getLogicModelItems().get(lmk);
        if (!(lmi instanceof LogicModelItem.SelectItem)) {
            return value;
        }
        LogicModelItem.SelectItem selectItem = (LogicModelItem.SelectItem)((Object)lmi);
        OptionItemsDTO optionItems = selectItem.getOptionItems(new LogicModelItem.ProtectedMap(ctx.getInput().getDataModelMap(), false), dmk);
        OptionItemDTO optionItemDTO = optionItems.get(optionKey = String.valueOf(value), ctx.getInput().getLocalizationHelper().getCurrentLocale());
        if (optionItemDTO != null) {
            Object text = optionItemDTO.getText();
            if (optionItemDTO.isResourceKey()) {
                String translated = ctx.getInput().getLocalizationHelper().translate(String.valueOf(text), new Object[0]);
                return translated;
            }
            return text;
        }
        return null;
    }
}

