/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers;

import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.PdfForm;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.RunContext;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.TableRow;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers.DataModelDelegateResolver;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers.DataModelResolver;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers.PdfKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SelectListCheckboxResolver
extends DataModelDelegateResolver {
    private final @NonNull String matchValue;
    private final @NonNull String mismatchValue;
    private final @NonNull Map<Object, Object> valueMapping;

    public SelectListCheckboxResolver(@NonNull String scheme, @NonNull String matchValue, @NonNull String mismatchValue) {
        this(scheme, matchValue, mismatchValue, new HashMap<Object, Object>());
    }

    public SelectListCheckboxResolver() {
        this("select-bool", "X", "", new HashMap<Object, Object>());
    }

    public SelectListCheckboxResolver(@NonNull String scheme, @NonNull String matchValue, @NonNull String mismatchValue, @NonNull Map<Object, Object> valueMapping) {
        super(scheme, new DataModelResolver(DataModelResolver.Localization.RAW_VALUE));
        this.matchValue = Objects.requireNonNull(matchValue);
        this.mismatchValue = Objects.requireNonNull(mismatchValue);
        this.valueMapping = new HashMap<Object, Object>(valueMapping);
    }

    public SelectListCheckboxResolver withEntryMapping(@NonNull Object fromValue, @NonNull Object toValue) {
        HashMap<Object, Object> newMap = new HashMap<Object, Object>(this.valueMapping);
        newMap.put(fromValue, toValue);
        return new SelectListCheckboxResolver(this.getScheme(), this.matchValue, this.mismatchValue, newMap);
    }

    @Override
    public @Nullable Object resolve(@NonNull PdfKey pdfKey, @Nullable TableRow tableRow, @NonNull PdfForm page, @NonNull RunContext ctx) {
        Object mapping;
        String entry = pdfKey.getResolverArgs();
        if (StringUtils.isBlank((CharSequence)entry)) {
            throw new IllegalArgumentException("query part may not be blank for: " + String.valueOf(pdfKey));
        }
        Object value = this.dataModelResolve(pdfKey, tableRow, page, ctx);
        if (value != null && (mapping = this.valueMapping.get(value)) != null) {
            value = mapping;
        }
        if (entry.equals(String.valueOf(value))) {
            return this.matchValue;
        }
        return this.mismatchValue;
    }
}

