/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.util;

import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.common.util.Render;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RenderBuilder
implements Serializable,
Comparable<RenderBuilder>,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(RenderBuilder.class);
    private static final Pattern RENDER_SPLITTER = Pattern.compile("\\s*,\\s*");
    private static final String DEFAULT_RENDER_STRING = ApplicationConfig.getInstance().getDefaultRenderString();
    private static final RenderBuilder TEMPLATE_DEFAULT = RenderBuilder.create(DEFAULT_RENDER_STRING);
    public static final Render DEFAULT_RENDER = RenderBuilder.create(DEFAULT_RENDER_STRING).build();
    private final LinkedHashSet<String> renderElements = new LinkedHashSet();

    public static RenderBuilder createDefault() {
        return new RenderBuilder(RenderBuilder.TEMPLATE_DEFAULT.renderElements);
    }

    public static RenderBuilder createAll() {
        return RenderBuilder.create(Render.ALL);
    }

    public static RenderBuilder createSelf() {
        return RenderBuilder.create(new String[0]);
    }

    public static RenderBuilder create(@Nullable Collection<String> render) {
        return new RenderBuilder(render);
    }

    public static RenderBuilder create(String ... elements) {
        RenderBuilder builder = new RenderBuilder();
        if (elements != null) {
            for (String entry : elements) {
                RenderBuilder b = RenderBuilder.parse(entry);
                builder.append(b);
            }
        }
        return builder;
    }

    public static RenderBuilder create(@Nullable Render render) {
        if (render == null) {
            return new RenderBuilder();
        }
        return new RenderBuilder(render.asUnmodifiableSet());
    }

    private RenderBuilder(@Nullable Collection<String> normalizedEntries) {
        if (normalizedEntries != null) {
            this.renderElements.addAll(normalizedEntries);
        }
    }

    private RenderBuilder() {
    }

    private static RenderBuilder parse(@Nullable String renderString) {
        String[] tokens;
        RenderBuilder render = new RenderBuilder();
        if (renderString == null || renderString.isEmpty()) {
            return render;
        }
        for (String token : tokens = RENDER_SPLITTER.split(renderString)) {
            render.appendInternal(token);
        }
        return render;
    }

    public @NonNull String toString() {
        String render = StringUtils.join(this.renderElements, (String)",");
        if (!LOG.isDebugEnabled()) {
            LOG.error("RenderBuilder.toString should never be called explicitly except in a debugging environment. Please use the render from build() instead! {}", (Object)render);
        }
        return render;
    }

    public Render build() {
        return new Render(this.renderElements);
    }

    public String asString() {
        return new Render(this.renderElements).toString();
    }

    private static @Nullable String cleanupElement(@Nullable String element) {
        if (element == null) {
            return null;
        }
        String cleanEntry = element.trim();
        return cleanEntry.isEmpty() ? null : cleanEntry;
    }

    private @NonNull RenderBuilder appendInternal(@Nullable String render) {
        String entry = RenderBuilder.cleanupElement(render);
        if (entry != null) {
            this.renderElements.add(entry);
        }
        return this;
    }

    public @NonNull RenderBuilder append(String ... render) {
        if (render != null) {
            for (String renderString : render) {
                this.appendAll(RenderBuilder.parse(renderString).asUnmodifiableSet());
            }
        }
        return this;
    }

    public @NonNull RenderBuilder append(@Nullable RenderBuilder render) {
        if (render != null) {
            this.renderElements.addAll(render.renderElements);
        }
        return this;
    }

    public @NonNull RenderBuilder append(@Nullable Render render) {
        if (render != null) {
            this.renderElements.addAll(render.asUnmodifiableSet());
        }
        return this;
    }

    public @NonNull RenderBuilder appendAll(@Nullable Collection<String> c) {
        if (c != null) {
            for (String elem : c) {
                this.appendInternal(elem);
            }
        }
        return this;
    }

    public @NonNull Set<String> asUnmodifiableSet() {
        return Collections.unmodifiableSet(this.renderElements);
    }

    @Override
    public int compareTo(@NonNull RenderBuilder other) {
        return this.toString().compareTo(other.toString());
    }

    public int hashCode() {
        return this.renderElements.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof RenderBuilder)) {
            return false;
        }
        return this.renderElements.equals(((RenderBuilder)other).renderElements);
    }

    public int size() {
        return this.renderElements.size();
    }

    protected @NonNull RenderBuilder clone() throws CloneNotSupportedException {
        super.clone();
        return new RenderBuilder(this.renderElements);
    }

    public boolean isEmpty() {
        return this.renderElements.isEmpty();
    }

    public boolean contains(@Nullable String oneEntry) {
        if (oneEntry == null) {
            return false;
        }
        return this.renderElements.contains(RenderBuilder.cleanupElement(oneEntry));
    }

    public void clear() {
        this.renderElements.clear();
    }
}

