/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.util;

import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.failure.ApplicationException;
import ch.dvbern.tax.common.transfer.failure.InvalidAuthenticationException;
import ch.dvbern.tax.common.transfer.failure.TaxFileCorruptedException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TaxFileUtil {
    public static final String MODEL_ZIP_ENTRY = "dvb-tax-model-12345678909876543210";
    private static final Logger LOG = LoggerFactory.getLogger(TaxFileUtil.class);
    private static String DVB_PKG = "ch.dvbern.tax";
    private static Set<String> THIRD_PARTY_CLASSES_WITHELIST = new HashSet<String>(Arrays.asList("java.util.HashMap", "java.util.Collections$SingletonMap", "java.util.Collections$UnmodifiableMap", "java.util.HashSet", "java.util.ArrayList", "java.util.Date", "java.sql.Timestamp", "java.lang.String", "java.lang.Character", "java.lang.Enum", "java.lang.Boolean", "java.lang.Number", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.math.BigInteger", "java.math.BigDecimal", "java.time.Ser", "[B", "[C", "[I", "[L", "[F", "[D", "org.threeten.bp.Ser"));
    private static final byte[] HEADER = new byte[]{100, 118, 98, 101, 114, 110, 45, 116, 97, 120, 0, 0, 0};
    private static final byte VERSION_NO_COMPRESSION = 1;
    private static final byte VERSION_GZIP = 2;
    private static final byte VERSION_ZURICH_TZ = 3;
    private static byte[] salt = new byte[]{-102, -71, -116, 98, 86, 83, -93, -109};
    private static final int ITERATION_COUNT = 31;
    private static final String ALGORITHM = "PBEWithMD5AndDES";

    private TaxFileUtil() {
    }

    static Cipher createCipher() {
        try {
            return Cipher.getInstance(ALGORITHM);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new ApplicationException("can't initialize cipher", e);
        }
    }

    static SecretKey createSecretKey(String pw) {
        try {
            SecretKeyFactory skf = SecretKeyFactory.getInstance(ALGORITHM);
            PBEKeySpec spec = new PBEKeySpec(pw.toCharArray(), salt, 31);
            return skf.generateSecret(spec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new ApplicationException("can't initialize secret key", e);
        }
    }

    static AlgorithmParameterSpec createAlgorithmParamSpec(String pw) {
        PBEKeySpec spec = new PBEKeySpec(pw.toCharArray(), salt, 31);
        return new PBEParameterSpec(spec.getSalt(), spec.getIterationCount());
    }

    public static Map<String, ModelItemDTO> read(InputStream is, String password) throws InvalidAuthenticationException {
        try {
            is = new BufferedInputStream(is);
            is.mark(500);
            return TaxFileUtil.read(is, TaxFileUtil.createCipher(), TaxFileUtil.createAlgorithmParamSpec(password), TaxFileUtil.createSecretKey(password));
        }
        catch (ApplicationException ae) {
            try {
                is.reset();
                ZipInputStream zis = new ZipInputStream(is);
                ZipEntry ze = zis.getNextEntry();
                while (ze != null) {
                    if (MODEL_ZIP_ENTRY.equals(ze.getName())) {
                        return TaxFileUtil.read(zis, TaxFileUtil.createCipher(), TaxFileUtil.createAlgorithmParamSpec(password), TaxFileUtil.createSecretKey(password));
                    }
                    ze = zis.getNextEntry();
                }
            }
            catch (IOException e) {
                LOG.debug("stream is not zipped", (Throwable)e);
            }
            throw ae;
        }
    }

    static Map<String, ModelItemDTO> read(InputStream is, Cipher cipher, AlgorithmParameterSpec paramSpec, SecretKey secretKey) {
        HashMap<String, ModelItemDTO> hashMap;
        ObjectInputStream ois = null;
        try {
            cipher.init(2, (Key)secretKey, paramSpec);
            for (byte element : HEADER) {
                if (element == is.read()) continue;
                throw new ApplicationException("invalid header");
            }
            int version = is.read();
            LOG.debug("Opening tax file version {}", (Object)version);
            is = new CipherInputStream(is, cipher);
            switch (version) {
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    is = new GZIPInputStream(is);
                    break;
                }
                default: {
                    throw new ApplicationException("invalid version");
                }
            }
            ois = new ObjectInputStream(is){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    String name = desc.getName();
                    if (name.startsWith(DVB_PKG)) {
                        return super.resolveClass(desc);
                    }
                    if (THIRD_PARTY_CLASSES_WITHELIST.contains(desc.getName())) {
                        return super.resolveClass(desc);
                    }
                    throw new ClassNotFoundException("Rejecting non-whitelisted java class: " + desc.getName());
                }
            };
            Map<String, ModelItemDTO> theDataModel = new HashMap<String, ModelItemDTO>((Map)ois.readObject());
            if (version < 3) {
                LOG.info("Version older than v{}, performing TimeZone conversion", (Object)3);
                theDataModel = TaxFileUtil.convertToApplicationTZ(theDataModel);
            }
            LOG.debug("Successfuly loaded {} model item(s) into memory", (Object)theDataModel.size());
            hashMap = theDataModel;
        }
        catch (Exception e) {
            try {
                if (e instanceof StreamCorruptedException) {
                    throw new TaxFileCorruptedException(e);
                }
                throw new ApplicationException("read failed", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(ois);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)ois);
        return hashMap;
    }

    private static Map<String, ModelItemDTO> convertToApplicationTZ(Map<String, ModelItemDTO> theDataModel) {
        assert (theDataModel != null);
        Calendar cetCal = Calendar.getInstance(TimeZone.getTimeZone("CET"));
        Calendar appTZCal = Calendar.getInstance(ApplicationConfig.TIMEZONE);
        HashMap<String, ModelItemDTO> newModel = new HashMap<String, ModelItemDTO>(theDataModel.size());
        for (Map.Entry<String, ModelItemDTO> entry : theDataModel.entrySet()) {
            ModelItemDTO item = entry.getValue();
            Object value = item.getValue();
            if (value instanceof Date) {
                cetCal.setTime((Date)value);
                appTZCal.set(cetCal.get(1), cetCal.get(2), cetCal.get(5), cetCal.get(11), cetCal.get(12), cetCal.get(13));
                appTZCal.set(14, cetCal.get(14));
                item = item.clone(appTZCal.getTime());
                LOG.trace("Converted item [{}] timestamp from {} to {}", new Object[]{entry.getKey(), cetCal.getTimeInMillis(), appTZCal.getTimeInMillis()});
            } else if (value instanceof Calendar) {
                ((Calendar)value).setTimeZone(ApplicationConfig.TIMEZONE);
            }
            newModel.put(entry.getKey(), item);
        }
        assert (newModel.size() == theDataModel.size());
        return newModel;
    }

    public static void write(OutputStream os, Map<String, ModelItemDTO> dataModel, String password) {
        TaxFileUtil.write(os, dataModel, TaxFileUtil.createCipher(), TaxFileUtil.createAlgorithmParamSpec(password), TaxFileUtil.createSecretKey(password));
    }

    @SuppressFBWarnings(justification="das datamodel ist immer serializable (siehe DataModelMap)", value={"DMI_NONSERIALIZABLE_OBJECT_WRITTEN"})
    static void write(OutputStream os, Map<String, ModelItemDTO> dataModel, Cipher cipher, AlgorithmParameterSpec paramSpec, SecretKey secretKey) {
        try {
            os.write(HEADER);
            os.write(3);
            cipher.init(1, (Key)secretKey, paramSpec);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(new GZIPOutputStream(new CipherOutputStream(baos, cipher)));
            oos.writeObject(dataModel);
            oos.close();
            os.write(baos.toByteArray());
        }
        catch (IOException e) {
            throw new ApplicationException("save failed", e);
        }
        catch (InvalidKeyException e) {
            throw new ApplicationException("save failed", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new ApplicationException("save failed", e);
        }
    }
}

