/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractConverter<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final @NonNull Class<? extends T> targetType;

    protected AbstractConverter(@NonNull Class<? extends T> targetType) {
        if (targetType == null) {
            throw new NullPointerException("Target type cannot be null");
        }
        this.targetType = targetType;
    }

    public @NonNull Class<? extends T> getTargetType() {
        return this.targetType;
    }

    public abstract @Nullable T getObject(@Nullable String var1, @Nullable OptionItemsDTO var2, @NonNull ConverterContext var3) throws ConvertException;

    public abstract @Nullable String getRenderedValue(@Nullable Object var1, boolean var2, @Nullable OptionItemsDTO var3, @NonNull ConverterContext var4);

    public @Nullable String getRenderedValueToPrint(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, @NonNull ConverterContext ctx) {
        return this.getRenderedValue(o, readonly, optionItems, ctx);
    }

    public @NonNull String getUserInputRegExpPattern() {
        return ".*";
    }

    public int getMaxLength() {
        return 1000;
    }

    public @NonNull String getStyleClass() {
        return "";
    }

    public int calcLength(@Nullable String input) {
        if (input == null) {
            return 0;
        }
        return input.length();
    }

    public static class ConverterContext {
        private final @NonNull LocalizationHelper localizationHelper;
        private final @NonNull Map<String, ModelItemDTO> model;
        private final @Nullable String dmk;

        public ConverterContext(@NonNull LocalizationHelper localizationHelper, @NonNull Map<String, ModelItemDTO> model, @Nullable String dmk) {
            this.localizationHelper = Objects.requireNonNull(localizationHelper);
            this.model = Collections.unmodifiableMap(Objects.requireNonNull(model));
            this.dmk = dmk;
        }

        public @NonNull LocalizationHelper getLocalizationHelper() {
            return this.localizationHelper;
        }

        public @NonNull Map<String, ModelItemDTO> getModel() {
            return this.model;
        }

        public @Nullable String getDmk() {
            return this.dmk;
        }

        public @NonNull ConverterContext withDmk(@Nullable String dmk) {
            return new ConverterContext(this.localizationHelper, this.model, dmk);
        }
    }

    public static class ConvertException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final int maxLength;

        public ConvertException(@NonNull String message) {
            this(message, 0);
        }

        public ConvertException(@NonNull String message, @Nullable Throwable throwable) {
            this(message, throwable, 0);
        }

        public ConvertException(@NonNull String message, int maxLength) {
            super(Objects.requireNonNull(message));
            this.maxLength = maxLength;
        }

        public ConvertException(@NonNull String message, @Nullable Throwable throwable, int maxLength) {
            super(Objects.requireNonNull(message), throwable);
            this.maxLength = maxLength;
        }

        public int getMaxLength() {
            return this.maxLength;
        }
    }
}

