/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FirstLetterConverter
extends AbstractConverter<String> {
    private static final long serialVersionUID = 3257569524822914358L;
    private final int chars;

    public FirstLetterConverter(int chars) {
        super(String.class);
        this.chars = chars;
    }

    @Override
    public @Nullable String getObject(@Nullable String s, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        return s;
    }

    @Override
    public @Nullable String getRenderedValue(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) {
        try {
            String key = o.toString();
            OptionItemDTO option = optionItems.get(key, ctx.getLocalizationHelper().getCurrentLocale());
            if (option != null) {
                if (option.isResourceKey()) {
                    return ctx.getLocalizationHelper().translate(option.getText().toString(), new Object[0]).substring(0, this.chars);
                }
                return option.getText().toString().substring(0, this.chars);
            }
        }
        catch (Exception e) {
            return "";
        }
        return "";
    }
}

