/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.util;

import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public final class FormatHelper {
    private static final DateFormat DATE_FORMATTER = new SimpleDateFormat("d.M.yyyy");
    private static final DateFormat[] DATE_PARSERS = new DateFormat[]{new SimpleDateFormat("d.M.y"), new SimpleDateFormat("ddMMy")};

    private FormatHelper() {
    }

    public static Date parseDate(String date) {
        if (date == null || date.isEmpty()) {
            return null;
        }
        Calendar aCalendar = FormatHelper.getCalendar(date);
        return aCalendar.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDate(Date value) {
        if (value == null) {
            return "";
        }
        DateFormat dateFormat = DATE_FORMATTER;
        synchronized (dateFormat) {
            return DATE_FORMATTER.format(value);
        }
    }

    public static String formatLanguage(Locale language) {
        if (language == null) {
            return null;
        }
        return language.getLanguage();
    }

    public static Locale parseLanguage(String language) {
        return new Locale(language);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date getDate(String sString) {
        if (sString == null) {
            throw new NullPointerException("input string cannot be null");
        }
        for (DateFormat parser : DATE_PARSERS) {
            Date theDate;
            ParsePosition pp = new ParsePosition(0);
            DateFormat dateFormat = parser;
            synchronized (dateFormat) {
                theDate = parser.parse(sString, pp);
            }
            if (pp.getErrorIndex() != -1 || pp.getIndex() != sString.length()) continue;
            return theDate;
        }
        return null;
    }

    public static Calendar getCalendar(String sString) {
        Calendar cal = Calendar.getInstance(ApplicationConfig.TIMEZONE);
        Date d = FormatHelper.getDate(sString);
        if (d == null) {
            return null;
        }
        cal.setTime(FormatHelper.getDate(sString));
        int year = cal.get(1);
        if (year < 1000 || year > 9999) {
            return null;
        }
        return cal;
    }

    static {
        DATE_FORMATTER.setTimeZone(ApplicationConfig.TIMEZONE);
        for (DateFormat parser : DATE_PARSERS) {
            parser.setTimeZone(ApplicationConfig.TIMEZONE);
            parser.setLenient(false);
        }
    }
}

