/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.util;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Result<@NonNull E, @NonNull T> {
    private final @NonNull Optional<T> value;
    private final @NonNull Optional<E> error;

    private Result(@Nullable T value, @Nullable E error) {
        this.value = Optional.ofNullable(value);
        this.error = Optional.ofNullable(error);
    }

    public static <T, E> Result<E, T> ok(@NonNull T value) {
        return new Result<Object, T>(Objects.requireNonNull(value), null);
    }

    public static <T, E> Result<E, T> error(@NonNull E error) {
        return new Result<E, Object>(null, Objects.requireNonNull(error));
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !Objects.equals(this.getClass(), o.getClass())) {
            return false;
        }
        Result result = (Result)o;
        return this.value.equals(result.value) && this.error.equals(result.error);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.error);
    }

    public @NonNull Result<E, T> ifOk(@NonNull Consumer<T> consumer) {
        if (this.isOk()) {
            consumer.accept(this.get());
        }
        return this;
    }

    public @NonNull Result<E, T> ifError(@NonNull Consumer<E> consumer) {
        if (this.isError()) {
            consumer.accept(this.getError());
        }
        return this;
    }

    public @NonNull Result<E, T> recover(@NonNull Function<E, T> recovery) {
        Objects.requireNonNull(recovery);
        if (this.isOk()) {
            return this;
        }
        return Result.ok(recovery.apply(this.getError()));
    }

    public @NonNull Result<E, T> recover(T recovery) {
        if (this.isOk()) {
            return this;
        }
        return Result.ok(recovery);
    }

    public @Nullable T orElse(@Nullable T fallback) {
        if (this.isOk()) {
            return this.get();
        }
        return fallback;
    }

    public T orElseGet(@NonNull Function<E, T> supplier) {
        Objects.requireNonNull(supplier);
        if (this.isOk()) {
            return this.get();
        }
        return supplier.apply(this.getError());
    }

    public <R> @NonNull Result<E, R> map(@NonNull Function<T, R> mapper) {
        if (this.isOk()) {
            return Result.ok(mapper.apply(this.get()));
        }
        return Result.error(this.getError());
    }

    public <TT, Ex extends Exception> @NonNull Result<E, TT> mapTry(@NonNull TryFunction<T, TT, Ex> mapper, @NonNull Function<Ex, Result<E, TT>> exceptionHandler) {
        if (this.isOk()) {
            try {
                return Result.ok(mapper.apply(this.get()));
            }
            catch (Exception e) {
                return exceptionHandler.apply(e);
            }
        }
        return Result.error(this.getError());
    }

    public <Ex extends Exception> @NonNull Result<E, T> ifOkTry(@NonNull TryConsumer<T, Ex> consumer, @NonNull Function<Ex, Result<E, T>> exceptionHandler) {
        if (this.isOk()) {
            try {
                consumer.accept(this.get());
                return this;
            }
            catch (Exception e) {
                return exceptionHandler.apply(e);
            }
        }
        return this;
    }

    public <EE> @NonNull Result<EE, T> mapError(@NonNull Function<E, EE> errorMapper) {
        if (this.isOk()) {
            return Result.ok(this.get());
        }
        return Result.error(errorMapper.apply(this.getError()));
    }

    public <R> @NonNull Result<E, R> flatMap(@NonNull Function<T, Result<E, R>> mapper) {
        if (this.isOk()) {
            return mapper.apply(this.get());
        }
        return new Result<E, Object>(null, this.getError());
    }

    public boolean isOk() {
        return this.value.isPresent();
    }

    public boolean isError() {
        return this.error.isPresent();
    }

    public @NonNull T get() {
        return this.value.get();
    }

    public @NonNull E getError() {
        return this.error.get();
    }

    public @NonNull Optional<T> toJavaOptional() {
        if (this.isOk()) {
            return this.value;
        }
        return Optional.empty();
    }

    public @NonNull String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)(this.isOk() ? "ok" : "error")).append((Object)String.valueOf(this.isOk() ? this.get() : this.getError())).build();
    }

    @FunctionalInterface
    public static interface TryFunction<T, R, E extends Exception> {
        public R apply(T var1) throws E;
    }

    @FunctionalInterface
    public static interface TryConsumer<T, E extends Exception> {
        public void accept(T var1) throws E;
    }
}

