/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.presentation.cd;

import ch.dvbern.lib.cryptutil.fileformats.X509PEM;
import ch.dvbern.lib.cryptutil.readers.PKCS8PEMCertReader;
import ch.dvbern.lib.update.signatures.MultiMethodSignatureVerifier;
import ch.dvbern.lib.update.signatures.SignMethod;
import ch.dvbern.lib.update.signatures.SignatureVerifier;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeLauncher;
import ch.dvbern.tax.common.presentation.cd.action.ActionRegistry;
import ch.dvbern.tax.common.presentation.cd.action.BrowserExecuter;
import ch.dvbern.tax.common.presentation.cd.action.PrintAllAction;
import ch.dvbern.tax.common.presentation.cd.util.ButtonCommands;
import ch.dvbern.tax.common.presentation.cd.util.ConnectionUtil;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.util.TaxFileConfig;
import ch.dvbern.tax.common.presentation.cd.wizard.FormNavigationPart;
import ch.dvbern.tax.common.presentation.cd.wizard.OkCancelButtonsComposite;
import ch.dvbern.tax.ju.Environment;
import ch.dvbern.tax.ju.presentation.cd.FileSystemDataResource;
import ch.dvbern.tax.ju.presentation.cd.action.JuPrintAction;
import ch.dvbern.tax.ju.presentation.cd.action.JuPrintJustificatifsAction;
import ch.dvbern.tax.ju.presentation.cd.action.JuUploadAction;
import ch.dvbern.tax.ju.presentation.cd.action.JuUploadShowHistoryAction;
import ch.dvbern.tax.ju.presentation.cd.dialog.ValorDatabaseDialog;
import ch.dvbern.tax.ju.presentation.cd.util.JuCdApplicationConfig;
import ch.dvbern.tax.ju.presentation.cd.util.TaxmeJuFilename;
import jakarta.annotation.Nonnull;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TaxmeJuLauncher {
    private static final Logger LOG = LoggerFactory.getLogger(TaxmeJuLauncher.class);
    private static final String UPLOAD_CUSTOM_MENU_ID = "menu.upload";
    public static final String SIGNED_KEY_NAME = "ju-signing_PROD.pub";

    private TaxmeJuLauncher() {
    }

    public static void main(String[] args) {
        TaxmeConfig.load(JuCdApplicationConfig.CD_APP_CONFIG);
        TaxmeConfig.setDataResource((DataResource)((Object)FileSystemDataResource.getInstance()));
        TaxmeConfig.setExpertModeEnabled(false);
        TaxmeConfig.setWizardModeEnabled(true);
        MultiMethodSignatureVerifier updateVerifier = TaxmeJuLauncher.readUpdateSignatureKey();
        TaxmeConfig.setUpdateSignatureVerifier((SignatureVerifier)updateVerifier);
        ButtonCommands.register("/shares.database.cmd", new ValorDatabaseDialog.ValorDatabaseButtonCommand(1));
        ButtonCommands.register("/bonds.database.cmd", new ValorDatabaseDialog.ValorDatabaseButtonCommand(2));
        JuPrintAction printAct = new JuPrintAction(false);
        JuPrintAction printCopyAct = new JuPrintAction(true);
        JuPrintJustificatifsAction printJustificatifsAct = new JuPrintJustificatifsAction();
        ButtonCommands.register("/print.cmd", printAct);
        ButtonCommands.register("/printCopy.cmd", printCopyAct);
        ButtonCommands.register("/printJustificatifs.cmd", printJustificatifsAct);
        ButtonCommands.register("/open.url.cmd", new BrowserExecuter());
        FormNavigationPart.setOkCancelPostion(2);
        ActionRegistry reg = ActionRegistry.getInstance();
        reg.registerAction("print", printCopyAct);
        JuUploadAction uploadAct = new JuUploadAction();
        JuUploadShowHistoryAction uploadShowHistoryAct = new JuUploadShowHistoryAction();
        reg.createCustomMenu(UPLOAD_CUSTOM_MENU_ID);
        reg.addCustomMenuAction(UPLOAD_CUSTOM_MENU_ID, uploadAct);
        reg.addCustomMenuAction(UPLOAD_CUSTOM_MENU_ID, uploadShowHistoryAct);
        ButtonCommands.register("/upload.cmd", uploadAct);
        ButtonCommands.register("/showUploadHistory.cmd", uploadShowHistoryAct);
        PrintAllAction.setAskForSave(true);
        TaxFileConfig.setInstance(new TaxmeJuFilename());
        OkCancelButtonsComposite.setOkOnlyEnabledIfAllSubNavItemsTouched(true);
        ConnectionUtil.configure();
        LOG.info("Starting JuraTax {} - Environment {}", (Object)ApplicationConfig.getInstance().getApplicationVersion(), (Object)Environment.getCurrentEnvironment());
        TaxmeJuLauncher.setSpecificResources();
        TaxmeLauncher.launchTaxme();
    }

    private static void setSpecificResources() {
        ImageRegistry imageRegistry = GuiUtil.getImageRegistry();
        imageRegistry.put("icon.state.error", TaxmeJuLauncher.createIconDesc("icon_red.gif"));
        imageRegistry.put("icon.state.error.transparent", TaxmeJuLauncher.createIconDesc("icon_red_disabled.gif"));
        imageRegistry.put("icon.state.ok", TaxmeJuLauncher.createIconDesc("icon_green.gif"));
        imageRegistry.put("icon.state.ok.transparent", TaxmeJuLauncher.createIconDesc("icon_green_disabled.gif"));
        imageRegistry.put("icon.state.missingvalue", TaxmeJuLauncher.createIconDesc("icon_white.gif"));
        imageRegistry.put("icon.state.missingvalue.transparent", TaxmeJuLauncher.createIconDesc("icon_white_disabled.gif"));
        imageRegistry.put("icon.state.warning", TaxmeJuLauncher.createIconDesc("icon_yellow.gif"));
        imageRegistry.put("icon.state.warning.transparent", TaxmeJuLauncher.createIconDesc("icon_yellow_disabled.gif"));
    }

    private static ImageDescriptor createIconDesc(String name) {
        try {
            URL url = new URL("file:" + TaxmeConfig.getIconFilePath(name));
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("malformed url", e);
        }
    }

    private static List<X509Certificate> readUpdateSitePinnedCertificates() {
        Set paths;
        try {
            paths = Files.walk(Paths.get(TaxmeJuLauncher.getPinningCertificateResourcePath(), new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toSet());
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not load pinned certificate from " + TaxmeJuLauncher.getPinningCertificateResourcePath(), e);
        }
        ArrayList<X509Certificate> pinningCertificates = new ArrayList<X509Certificate>();
        for (Path resourcePath : paths) {
            BufferedInputStream certStream = null;
            try {
                certStream = new BufferedInputStream(new FileInputStream(String.valueOf(resourcePath)));
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("Could not find valid file for " + String.valueOf(resourcePath), e);
            }
            X509Certificate cert = new X509PEM().read((InputStream)certStream);
            pinningCertificates.add(cert);
        }
        return pinningCertificates;
    }

    private static MultiMethodSignatureVerifier readUpdateSignatureKey() {
        MultiMethodSignatureVerifier multiMethodSignatureVerifier;
        block8: {
            String resourcePath = TaxmeJuLauncher.getSigningCertificateResourcePath(SIGNED_KEY_NAME);
            InputStream cert = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath);
            try {
                MultiMethodSignatureVerifier updateVerifier;
                RSAPublicKey pk = new PKCS8PEMCertReader(cert).readPublicKey();
                multiMethodSignatureVerifier = updateVerifier = new MultiMethodSignatureVerifier((PublicKey)pk, Arrays.asList(SignMethod.SHA256withRSA, SignMethod.SHA512withRSA), "");
                if (cert == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cert != null) {
                        try {
                            cert.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Could not read certificate for update verification @" + resourcePath, e);
                }
            }
            cert.close();
        }
        return multiMethodSignatureVerifier;
    }

    private static String getPinningCertificateResourcePath() {
        URL resorceDirUrl;
        String resourceDir = TaxmeConfig.getString("update-site.certpath");
        if (StringUtils.isBlank((CharSequence)resourceDir)) {
            resourceDir = "certs/prod/pinning";
        }
        if ((resorceDirUrl = Thread.currentThread().getContextClassLoader().getResource(resourceDir)) == null) {
            return "";
        }
        return resorceDirUrl.getPath();
    }

    private static String getSigningCertificateResourcePath(@Nonnull String filename) {
        String resourceDir = TaxmeConfig.getString("update-sign.certpath");
        if (StringUtils.isBlank((CharSequence)resourceDir)) {
            resourceDir = "certs/prod/signing";
        }
        return resourceDir + "/" + filename;
    }
}

