/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.presentation.cd.action;

import ch.dvbern.tax.common.engine.expertdisplay.Barcode2DDataDTO;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.bd.DvbTaxSession;
import ch.dvbern.tax.common.presentation.bd.cd.DvbTaxCdSession;
import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.PrintableAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.FilePrintAction;
import ch.dvbern.tax.common.presentation.cd.util.PrintUtilCD;
import ch.dvbern.tax.common.presentation.common.print.FormKey;
import ch.dvbern.tax.common.presentation.common.print.PrintRequest;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.util.ZipHelper;
import ch.dvbern.tax.ju.JuUtil;
import ch.dvbern.tax.ju.SystemInfo;
import ch.dvbern.tax.ju.presentation.cd.util.JuCdApplicationConfig;
import ch.dvbern.tax.ju.transfer.dto.NoContribuable;
import ch.dvbern.tax.ju.upload.UploadConfiguration;
import ch.dvbern.tax.ju.upload.UploadServiceClient;
import ch.dvbern.tax.ju.upload.UploadServiceClientFactory;
import ch.dvbern.tax.ju.upload.cd.UploadException;
import ch.dvbern.tax.ju.upload.cd.UploadServiceClientGUIAdapter;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JuPrintAction
extends FilePrintAction {
    private static final Logger LOG = LoggerFactory.getLogger(JuPrintAction.class);
    private final boolean copy;

    public JuPrintAction(boolean copy) {
        this.copy = copy;
    }

    @Override
    public void run() {
        TaxmeController ctrl = TaxmeController.getInstance();
        ModelItemDTO uploadTypeItem = ctrl.getTmoCdSession().getModelItem("Televersement.Type");
        String uploadTypeStr = uploadTypeItem != null ? (String)uploadTypeItem.getValue() : null;
        UploadConfiguration.UploadType uploadType = uploadTypeStr != null ? UploadConfiguration.UploadType.valueOf((String)uploadTypeStr) : null;
        String addressKey = uploadType == UploadConfiguration.UploadType.PRINT ? "label.justificatifs.impression.info" : "label.justificatifs.impression.adresse";
        String address = Messages.translate(addressKey, new Object[0]);
        HashMap<String, ModelItemDTO> modelValue = new HashMap<String, ModelItemDTO>();
        ModelItemDTO item = new ModelItemDTO(address);
        item.setTouched();
        modelValue.put("Impression.AdresseJustificatifs", item);
        ctrl.getTmoCdSession().update(modelValue, true);
        boolean doPrint = ctrl.askForSave();
        if (doPrint) {
            if (this.copy) {
                List<FormKey> keys;
                PrintableAction printAction = this.getPrintAction();
                if (printAction != null && (keys = printAction.getFormKeys()) != null && !keys.isEmpty()) {
                    PrintRequest printRequest = PrintUtilCD.newPrintRequest().withFormKeys(keys).withConfiguration(JuUtil.newPrintConfiguration().withCopyWatermark(true));
                    PrintUtilCD.printForms(printRequest);
                    if (TaxmeConfig.isDebugEnabled()) {
                        this.generateXMLBarcode(ctrl);
                    }
                }
            } else {
                this.printDeclaration();
            }
        }
    }

    private void generateXMLBarcode(TaxmeController ctrl) {
        PrintRequest request = JuUtil.initializeFinalPrintRequest((PrintRequest)PrintUtilCD.newPrintRequest(), (DvbTaxSession)ctrl.getTmoCdSession(), (boolean)true, (SystemInfo)JuCdApplicationConfig.getSystemInfo());
        DvbTaxCdSession session = ctrl.getTmoCdSession();
        try {
            File barcodeFile = new File(String.valueOf(session.getModelItem("Stammdaten.Declaration.NoContribuable").getValue()) + ".xml");
            byte[] barcode = ((Barcode2DDataDTO)request.getConfiguration().getProperties().get("barcode")).getData();
            FileUtils.writeByteArrayToFile((File)barcodeFile, (byte[])ZipHelper.unzip(barcode));
            LOG.info("Barcode file written in " + barcodeFile.getAbsolutePath());
        }
        catch (IOException e) {
            LOG.error("Failed to dump barcode file.", (Throwable)e);
        }
    }

    private void printDeclaration() {
        boolean validationPerformed;
        Object numeroContribuableItemObj;
        TaxmeController ctrl = TaxmeController.getInstance();
        DvbTaxCdSession session = ctrl.getTmoCdSession();
        int state = ctrl.getWizardDisplayInfoDTO().getNavigationDTO().getState();
        if (state != 1 && state != 2) {
            MessageDialog.openWarning((Shell)ctrl.getShell(), (String)Messages.translate("label.print.warnung.nicht.gruen.title", new Object[0]), (String)Messages.translate("label.print.warnung.nicht.gruen", new Object[0]));
            return;
        }
        NoContribuable numeroContribuable = null;
        ModelItemDTO numeroContribuableItem = session.getModelItem("Stammdaten.Declaration.NoContribuable");
        if (numeroContribuableItem != null && (numeroContribuableItemObj = numeroContribuableItem.getValue()) != null) {
            try {
                numeroContribuable = NoContribuable.parse((String)numeroContribuableItemObj.toString());
            }
            catch (IllegalArgumentException e) {
                LOG.error("Tax payer number misformated in model: " + String.valueOf(numeroContribuableItemObj), (Throwable)e);
            }
        }
        if (numeroContribuable == null) {
            throw new IllegalStateException("Failed to fetch tax payer number from data model");
        }
        LOG.info("Started printing declaration for tax payer number {}", numeroContribuable);
        UploadServiceClient client = UploadServiceClientFactory.login((NoContribuable)numeroContribuable, (int)ApplicationConfig.getInstance().getJahr());
        LOG.debug("Upload service instance retrieved: {}", (Object)client.getDescription());
        UploadServiceClientGUIAdapter clientGUIAdapter = new UploadServiceClientGUIAdapter(ctrl.getShell(), client);
        try {
            validationPerformed = clientGUIAdapter.isValidationPerformed();
            LOG.debug("Upload service query successful. Validation performed = {}", (Object)validationPerformed);
        }
        catch (UploadException e) {
            LOG.info("Failed to query validation status, assume not validated", (Throwable)e);
            validationPerformed = false;
        }
        catch (InterruptedException e) {
            LOG.info("Validation status query interrupted, assume not validated", (Throwable)e);
            validationPerformed = false;
        }
        PrintRequest request = JuUtil.initializeFinalPrintRequest((PrintRequest)PrintUtilCD.newPrintRequest(), (DvbTaxSession)session, (boolean)validationPerformed, (SystemInfo)JuCdApplicationConfig.getSystemInfo());
        PrintUtilCD.printForms(request);
        if (TaxmeConfig.isDebugEnabled()) {
            this.generateXMLBarcode(ctrl);
        }
    }
}

