/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.presentation.cd.action;

import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.bd.DvbTaxSession;
import ch.dvbern.tax.common.presentation.bd.cd.DvbTaxCdSession;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.ActionBase;
import ch.dvbern.tax.common.presentation.cd.dialog.TaxmeProgressMonitorDialog;
import ch.dvbern.tax.common.presentation.cd.items.IButtonItem;
import ch.dvbern.tax.common.presentation.cd.util.ButtonCommand;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.ju.JuUtil;
import ch.dvbern.tax.ju.presentation.cd.action.JuUploadShowHistoryAction;
import ch.dvbern.tax.ju.presentation.cd.dialog.InputCodeDIDialog;
import ch.dvbern.tax.ju.presentation.cd.dialog.SendUploadErrorReportDialog;
import ch.dvbern.tax.ju.presentation.cd.dialog.ValidationAlreadyPerformedDialog;
import ch.dvbern.tax.ju.presentation.cd.util.JFaceTaskAdapter;
import ch.dvbern.tax.ju.presentation.cd.util.JuCdApplicationConfig;
import ch.dvbern.tax.ju.presentation.cd.util.JuDialogUtil;
import ch.dvbern.tax.ju.transfer.dto.NoContribuable;
import ch.dvbern.tax.ju.upload.ArchiveGenerationTask;
import ch.dvbern.tax.ju.upload.UploadConfiguration;
import ch.dvbern.tax.ju.upload.UploadInfo;
import ch.dvbern.tax.ju.upload.UploadServiceClient;
import ch.dvbern.tax.ju.upload.UploadServiceClientFactory;
import ch.dvbern.tax.ju.upload.cd.ErrorReportGenerationTask;
import ch.dvbern.tax.ju.upload.cd.FatalUploadException;
import ch.dvbern.tax.ju.upload.cd.UploadCdConfiguration;
import ch.dvbern.tax.ju.upload.cd.UploadException;
import ch.dvbern.tax.ju.upload.cd.UploadHistory;
import ch.dvbern.tax.ju.upload.cd.UploadHistoryEntry;
import ch.dvbern.tax.ju.upload.cd.UploadServiceClientGUIAdapter;
import ch.dvbern.tax.ju.utils.Task;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.read.CyclicBufferAppender;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JuUploadAction
extends ActionBase
implements ButtonCommand {
    private static final Logger LOG = LoggerFactory.getLogger(JuUploadAction.class);
    private static final CyclicBufferAppender<ILoggingEvent> BUFFER_APPENDER = new CyclicBufferAppender();

    public JuUploadAction() {
        super("label.menu.upload", null, "icon.upload");
    }

    public void run() {
        LOG.info("Upload action triggered");
        Shell parentShell = TaxmeController.getInstance().getShell();
        List<ILoggingEvent> logEvents = Collections.emptyList();
        try {
            UploadRequest request = this.buildUploadRequest(parentShell);
            try {
                this.startBufferLogging();
                try {
                    this.runInternal(parentShell, request);
                }
                catch (RuntimeException e) {
                    throw new UploadException("Unexpected failure", e);
                }
                finally {
                    logEvents = this.stopBufferLogging();
                }
            }
            catch (FatalUploadException fatalException) {
                try {
                    this.handleFatalException(fatalException, logEvents, request);
                }
                catch (Exception e) {
                    LOG.error("Failed to generate error report, fall-back to default error dialog", (Throwable)e);
                    JuDialogUtil.showDialog(TaxmeController.getInstance().getShell(), fatalException);
                }
            }
        }
        catch (InterruptedException e) {
            LOG.info("Upload interrupted");
            LOG.debug("Upload interrupted", (Throwable)e);
        }
        catch (UploadException e) {
            LOG.error("Upload failed.", (Throwable)e);
            JuDialogUtil.showDialog(parentShell, e);
        }
    }

    private @NonNull UploadRequest buildUploadRequest(Shell parentShell) throws InterruptedException, UploadException {
        UploadConfiguration.UploadType uploadType;
        NoContribuable numeroContribuable;
        TaxmeController ctrl = TaxmeController.getInstance();
        int year = ApplicationConfig.getInstance().getJahr();
        if (!ctrl.isDeclarationOpen()) {
            JuDialogUtil.showDialog(parentShell, "title.dialog.upload.notOpen", "label.dialog.upload.notOpen", 2, new String[]{"label.button.retour"}, 0);
            throw new InterruptedException("Declaration not open.");
        }
        if (!ctrl.askForSave()) {
            throw new InterruptedException("User aborted electronic sumbission process.");
        }
        int state = ctrl.getWizardDisplayInfoDTO().getNavigationDTO().getState();
        if (state != 1 && state != 2) {
            JuDialogUtil.showDialog(parentShell, "title.dialog.upload.notComplete", "label.dialog.upload.notComplete", 2, new String[]{"label.button.retour"}, 0);
            throw new InterruptedException("Declaration not ready, cannot process further.");
        }
        DvbTaxCdSession session = ctrl.getTmoCdSession();
        String numeroContribuableStr = this.getRequiredStringValueFromModel(session, "Stammdaten.Declaration.NoContribuable");
        String uploadTypeStr = this.getRequiredStringValueFromModel(session, "Televersement.Type");
        try {
            numeroContribuable = NoContribuable.parse((String)numeroContribuableStr);
        }
        catch (IllegalArgumentException e) {
            assert (false) : "Unexpected value in model for tax payer number: " + numeroContribuableStr;
            throw new UploadException("Cannot tax payer number from model", e);
        }
        try {
            uploadType = UploadConfiguration.UploadType.valueOf((String)uploadTypeStr);
        }
        catch (IllegalArgumentException e) {
            assert (false) : "Unexpected value in model for upload type: " + uploadTypeStr;
            throw new UploadException("Cannot parse upload type from model", e);
        }
        if (uploadType != UploadConfiguration.UploadType.WITH_CODE_DI) {
            JuDialogUtil.showDialog(parentShell, "title.dialog.upload.notUpload", "label.dialog.upload.notUpload", 2, new String[]{"label.button.retour"}, 0);
            throw new InterruptedException("Will not perform upload with upload type: " + uploadTypeStr);
        }
        return new UploadRequest(numeroContribuable, year, uploadType);
    }

    private void runInternal(Shell parentShell, UploadRequest request) throws InterruptedException, UploadException {
        assert (request != null);
        TaxmeController ctrl = TaxmeController.getInstance();
        LOG.info("Starting upload procedure: {}", (Object)request);
        UploadServiceClient client = UploadServiceClientFactory.login((NoContribuable)request.numeroContribuable, (int)request.year);
        LOG.debug("Loaded upload service client: " + client.getDescription());
        UploadServiceClientGUIAdapter clientGUIAdapter = new UploadServiceClientGUIAdapter(parentShell, client);
        boolean validationPerformed = clientGUIAdapter.isValidationPerformed();
        if (validationPerformed) {
            ValidationAlreadyPerformedDialog dlg = new ValidationAlreadyPerformedDialog(parentShell);
            dlg.open();
            throw new InterruptedException("Validation already performed.");
        }
        LOG.debug("No previous validation detected");
        String codeDI = null;
        if (request.uploadType == UploadConfiguration.UploadType.WITH_CODE_DI) {
            InputCodeDIDialog dlg;
            do {
                if ((dlg = new InputCodeDIDialog(parentShell, codeDI)).open() == 0) continue;
                throw new InterruptedException("Code-DI input cancelled");
            } while (!clientGUIAdapter.isCodeDIValid(codeDI = dlg.getCodeDI()));
        }
        LOG.debug("Code DI is valid, proceeding with archive generation");
        ByteArrayOutputStream archiveStream = new ByteArrayOutputStream(512000);
        ArchiveGenerationTask archiveTask = this.generateArchive(ctrl, archiveStream, request.numeroContribuable, codeDI);
        String digest = archiveTask.getDigest();
        Instant timestamp = archiveTask.getTimestamp();
        byte[] archive = archiveStream.toByteArray();
        LOG.debug("Archive generation: {} bytes successfully generated (digest: {}).", (Object)archive.length, (Object)digest);
        UUID guid = null;
        LOG.debug("Starting upload now");
        if (request.uploadType == UploadConfiguration.UploadType.WITH_CODE_DI) {
            guid = clientGUIAdapter.uploadWithCodeDI(archive, digest, codeDI);
        }
        LOG.info("Upload completed with guid {} generating summary page", guid);
        ExpertDisplayInfoDTO[] summaryExpertDisplayDTOs = new ExpertDisplayInfoDTO[]{ctrl.getExpertDisplayInfoDTO("Synthese", 2), ctrl.getExpertDisplayInfoDTO("impot_page1", 2)};
        LOG.debug("Summary page prepared: persist transaction to history.");
        this.saveToHistory(guid, request.numeroContribuable, timestamp, request.uploadType, summaryExpertDisplayDTOs);
        LOG.info("Upload finished normally, transaction guid: {}", (Object)guid);
        new JuUploadShowHistoryAction().run();
    }

    private @Nullable String getRequiredStringValueFromModel(DvbTaxSession session, String dmk) throws UploadException {
        Object obj;
        String value = null;
        ModelItemDTO item = session.getModelItem(dmk);
        if (item != null && (obj = item.getValue()) != null) {
            value = obj.toString();
        }
        if (value == null || value.length() == 0) {
            assert (false) : "Illegal state: performing upload with incomplete model.";
            throw new UploadException("Failed to value from model: " + dmk);
        }
        return value;
    }

    private @NonNull ArchiveGenerationTask generateArchive(TaxmeController ctrl, OutputStream archiveStream, NoContribuable numeroContribuable, String codeDI) throws InterruptedException, UploadException {
        assert (archiveStream != null);
        assert (numeroContribuable != null);
        DvbTaxCdSession session = ctrl.getTmoCdSession();
        session.update(JuUtil.createSummaryPrintValues((Instant)Instant.now(), (String)codeDI), true, true, null);
        AbstractConverter.ConverterContext ctx = new AbstractConverter.ConverterContext(ctrl.getLocalizationHelper(), session.getDataModel(), null);
        UploadInfo uploadInfo = UploadInfo.newBuilder(session.getDataModel(), null).withCodeDI(codeDI).withSystemInfo(JuCdApplicationConfig.getSystemInfo()).build();
        ArchiveGenerationTask archiveGenTask = new ArchiveGenerationTask((DvbTaxSession)session, ctx, ctrl.getImageSource(), archiveStream, uploadInfo, null, null, Collections.emptyList(), null);
        this.runArchiveGenerationTaskWithDialog(archiveStream, archiveGenTask);
        return archiveGenTask;
    }

    private void runArchiveGenerationTaskWithDialog(OutputStream archiveStream, ArchiveGenerationTask archiveGenTask) throws InterruptedException, UploadException {
        TaxmeProgressMonitorDialog dlg = new TaxmeProgressMonitorDialog(TaxmeController.getInstance().getShell());
        try {
            dlg.run(true, true, new JFaceTaskAdapter((Task)archiveGenTask));
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof IOException) {
                throw new UploadException("Generation of the archive file failed.", cause, "label.dialog.upload.archivegeneration.ioexception", "title.dialog.upload.archivegeneration.ioexception");
            }
            if (cause instanceof NoSuchAlgorithmException) {
                throw new UploadException("Message digest not supported by this java implementation.", cause, "label.dialog.upload.archivegeneration.error", "title.dialog.upload.archivegeneration.error");
            }
            throw new UploadException("Archive generation: unexpected failure", (Throwable)e, "label.dialog.upload.archivegeneration.error", "title.dialog.upload.archivegeneration.error");
        }
        finally {
            IOUtils.closeQuietly((OutputStream)archiveStream);
        }
    }

    private void saveToHistory(UUID guid, NoContribuable numeroContribuable, Instant pdfTimestamp, UploadConfiguration.UploadType uploadType, ExpertDisplayInfoDTO[] summaryExpertDisplayDTO) throws UploadException {
        assert (guid != null && numeroContribuable != null && pdfTimestamp != null && uploadType != null);
        File historyFile = UploadCdConfiguration.getUploadHistoryFile();
        UploadHistory uh = null;
        try {
            uh = UploadHistory.loadHistory(historyFile);
        }
        catch (IOException e) {
            LOG.error("Cannot load history. Maybe a corrupted file? Attempt to perform a backup and proceed with empty history");
            File parent = historyFile.getParentFile();
            if (parent != null) {
                try {
                    File backup = File.createTempFile("history_", "_backup.dat", parent);
                    FileUtils.copyFile((File)historyFile, (File)backup);
                    LOG.info("Backup created from history file {} to {}", (Object)historyFile, (Object)backup);
                }
                catch (IOException e2) {
                    LOG.error("Failed to created history backup", (Throwable)e2);
                }
            } else {
                LOG.error("Cannot create history backup (no parent directory for history file {})", (Object)historyFile);
            }
            boolean deleted = historyFile.delete();
            LOG.debug("Removing previous history file successful: {}", (Object)deleted);
        }
        if (uh == null) {
            try {
                uh = UploadHistory.loadHistory(UploadCdConfiguration.getUploadHistoryFile());
            }
            catch (IOException e) {
                throw new UploadException("Cannot load history.", e);
            }
        }
        try {
            uh.addEntry(new UploadHistoryEntry(guid, numeroContribuable, pdfTimestamp, uploadType, summaryExpertDisplayDTO));
            uh.persist();
        }
        catch (IOException e) {
            throw new UploadException("Cannot save to history.", e);
        }
    }

    private void startBufferLogging() {
        try {
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            lc.getLogger("root").addAppender(BUFFER_APPENDER);
            BUFFER_APPENDER.start();
            LOG.debug("Buffered logger started");
        }
        catch (Exception e) {
            LOG.warn("Failed to start buffered logging", (Throwable)e);
        }
    }

    private @NonNull List<ILoggingEvent> stopBufferLogging() {
        try {
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            lc.getLogger("root").detachAppender(BUFFER_APPENDER);
            ArrayList<ILoggingEvent> logEvents = new ArrayList<ILoggingEvent>(BUFFER_APPENDER.getLength());
            for (int i = 0; i < BUFFER_APPENDER.getLength(); ++i) {
                logEvents.add((ILoggingEvent)BUFFER_APPENDER.get(i));
            }
            BUFFER_APPENDER.stop();
            LOG.debug("Buffered logger stopped");
            return logEvents;
        }
        catch (Exception e) {
            LOG.warn("Failed to stop buffered logging", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private void handleFatalException(FatalUploadException fatalException, List<ILoggingEvent> logEvents, UploadRequest request) throws InvocationTargetException, InterruptedException {
        assert (fatalException != null && logEvents != null);
        LOG.error("Fatal exception encountered during upload", (Throwable)fatalException);
        Shell parentShell = TaxmeController.getInstance().getShell();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Instant timestamp = Instant.now();
        UUID correlationId = UUID.randomUUID();
        ErrorReportGenerationTask task = new ErrorReportGenerationTask(fatalException, timestamp, correlationId, logEvents, baos);
        TaxmeProgressMonitorDialog reportDlg = new TaxmeProgressMonitorDialog(parentShell);
        reportDlg.run(true, true, task);
        SendUploadErrorReportDialog errorDlg = new SendUploadErrorReportDialog(parentShell, request.numeroContribuable, request.year, correlationId, TaxmeConfig.getApplicationVersion(), baos.toByteArray());
        errorDlg.open();
    }

    @Override
    public void init(IButtonItem buttonDTO) {
    }

    @Override
    public void execute(IButtonItem buttonDTO) {
        this.run();
    }

    static {
        BUFFER_APPENDER.setMaxSize(1000);
    }

    private static class UploadRequest {
        final NoContribuable numeroContribuable;
        final int year;
        final UploadConfiguration.UploadType uploadType;

        UploadRequest(NoContribuable numeroContribuable, int year, UploadConfiguration.UploadType uploadType) {
            assert (numeroContribuable != null && year > 0 && uploadType != null);
            this.numeroContribuable = numeroContribuable;
            this.year = year;
            this.uploadType = uploadType;
        }
    }
}

