/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.presentation.cd.action;

import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.ActionBase;
import ch.dvbern.tax.common.presentation.cd.items.IButtonItem;
import ch.dvbern.tax.common.presentation.cd.util.ButtonCommand;
import ch.dvbern.tax.common.presentation.cd.util.LaunchUtil;
import ch.dvbern.tax.common.presentation.common.print.FormRenderer;
import ch.dvbern.tax.common.presentation.common.print.FormRendererConfiguration;
import ch.dvbern.tax.common.presentation.common.print.FormRendererFactory;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import ch.dvbern.tax.ju.JuUtil;
import ch.dvbern.tax.ju.presentation.cd.dialog.OpenBrowserFailedDialog;
import ch.dvbern.tax.ju.presentation.cd.dialog.UploadHistoryDialog;
import ch.dvbern.tax.ju.presentation.cd.util.JuDialogUtil;
import ch.dvbern.tax.ju.transfer.dto.NoContribuable;
import ch.dvbern.tax.ju.transfer.dto.convert.NoContribuableConverter;
import ch.dvbern.tax.ju.upload.UploadConfiguration;
import ch.dvbern.tax.ju.upload.UploadServiceClient;
import ch.dvbern.tax.ju.upload.UploadServiceClientFactory;
import ch.dvbern.tax.ju.upload.UploadStatusDTO;
import ch.dvbern.tax.ju.upload.UploadValidationStatus;
import ch.dvbern.tax.ju.upload.cd.UploadCdConfiguration;
import ch.dvbern.tax.ju.upload.cd.UploadException;
import ch.dvbern.tax.ju.upload.cd.UploadHistory;
import ch.dvbern.tax.ju.upload.cd.UploadHistoryEntry;
import ch.dvbern.tax.ju.upload.cd.UploadServiceClientGUIAdapter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JuUploadShowHistoryAction
extends ActionBase
implements ButtonCommand {
    private static final DateTimeFormatter DATE_TIME_FORMATTER_PDF = DateTimeFormatter.ofPattern("dd/MM/yyyy \u00e0 HH:mm:ss").withZone(UploadConfiguration.TIMEZONE);
    private static final DateTimeFormatter DATE_TIME_FORMATTER_FNAME = DateTimeFormatter.ofPattern("dd-MM-yyyy_HH-mm-ss").withZone(UploadConfiguration.TIMEZONE);
    private static final Logger LOG = LoggerFactory.getLogger(JuUploadShowHistoryAction.class);
    private final UploadServiceClient providedClient;
    private static final @NonNull Comparator<UploadStatusDTO> UPLOAD_DATE_COMPARATOR = (o1, o2) -> o1.getTimestamp().compareTo(o2.getTimestamp());

    public JuUploadShowHistoryAction() {
        this((UploadServiceClient)null);
    }

    public JuUploadShowHistoryAction(UploadServiceClient providedClient) {
        super("label.menu.upload.showHistory", null, null);
        this.providedClient = providedClient;
    }

    public void run() {
        LOG.info("Show upload history action trigerred");
        try {
            this.runInternal();
        }
        catch (InterruptedException e) {
            LOG.debug("Show history action cancelled.", (Throwable)e);
        }
        catch (UploadException e) {
            LOG.error("Upload failed.", (Throwable)e);
            JuDialogUtil.showDialog(TaxmeController.getInstance().getShell(), e);
        }
    }

    private void runInternal() throws UploadException, InterruptedException {
        List<Object> statuses;
        UploadServiceClient client;
        Object numeroContribuableValue;
        TaxmeController ctrl = TaxmeController.getInstance();
        Shell parentShell = ctrl.getShell();
        int year = ApplicationConfig.getInstance().getJahr();
        NoContribuable numeroContribuable = null;
        ModelItemDTO numeroContribuableItem = ctrl.getTmoCdSession().getModelItem("Stammdaten.Declaration.NoContribuable");
        if (numeroContribuableItem != null && (numeroContribuableValue = numeroContribuableItem.getValue()) != null) {
            numeroContribuable = NoContribuable.parse((String)numeroContribuableValue.toString());
            LOG.debug("Show history for current user case ({})", (Object)numeroContribuable);
        }
        if (this.providedClient == null) {
            if (numeroContribuable == null) {
                AskNumeroContribuableDialog dlg = new AskNumeroContribuableDialog(parentShell);
                dlg.open();
                numeroContribuable = dlg.getNumeroContribuable();
                if (numeroContribuable == null) {
                    throw new InterruptedException("No tax payer number given");
                }
                LOG.debug("Show history for selected user case ({})", (Object)numeroContribuable);
            }
            client = UploadServiceClientFactory.login(numeroContribuable, (int)year);
            LOG.debug("Loaded upload client ({})", (Object)client.getDescription());
        } else {
            LOG.debug("Using provided upload client ({})", (Object)this.providedClient.getDescription());
            client = this.providedClient;
        }
        UploadServiceClientGUIAdapter clientGUIAdapter = new UploadServiceClientGUIAdapter(parentShell, client);
        boolean validationPerformed = clientGUIAdapter.isValidationPerformed();
        Collection<UploadHistoryEntry> history = this.loadUploadHistory(numeroContribuable);
        HashMap<UUID, UploadHistoryEntry> historyMap = new HashMap<UUID, UploadHistoryEntry>();
        for (UploadHistoryEntry entry : history) {
            UploadHistoryEntry previousEntry = historyMap.put(entry.getGuid(), entry);
            if (previousEntry == null) continue;
            LOG.warn("Ignoring duplicated guid returned by history: " + String.valueOf(previousEntry) + " (duplicate " + String.valueOf(entry) + ")");
        }
        if (!historyMap.isEmpty()) {
            statuses = clientGUIAdapter.getUploadStatus(historyMap.keySet());
            if (LOG.isDebugEnabled() && !statuses.isEmpty()) {
                StringBuilder sb = new StringBuilder("Received status info from server:\n");
                for (UploadStatusDTO uploadStatusDTO : statuses) {
                    sb.append("    - ").append(uploadStatusDTO);
                }
                LOG.debug(sb.toString());
            }
        } else {
            statuses = Collections.emptyList();
            LOG.debug("No entry available in history, skip status querying");
        }
        UploadStatusDTO status = null;
        UploadHistoryEntry historyEntry = null;
        if (!statuses.isEmpty()) {
            status = Collections.max(statuses, UPLOAD_DATE_COMPARATOR);
            historyEntry = (UploadHistoryEntry)historyMap.get(status.getGuid());
            if (historyEntry != null) {
                UploadValidationStatus uploadValidationStatus = status.getValidationStatus();
                if (validationPerformed) {
                    if (uploadValidationStatus == UploadValidationStatus.NOT_VALIDATED) {
                        LOG.warn("Status info returned by server is non-validated despite validation being performed, discard it: {}", (Object)status);
                        status = null;
                    } else if (uploadValidationStatus == UploadValidationStatus.VALIDATED_WITH_CODE_DI && status.getDeclarationCode() == null) {
                        LOG.warn("Missing declaration code in status info returned by server, discard it: {}", (Object)status);
                        status = null;
                    }
                } else if (uploadValidationStatus != UploadValidationStatus.NOT_VALIDATED) {
                    LOG.warn("Found a entry with validated status {} but the upload service said previously there was none: assume there is one.", (Object)uploadValidationStatus);
                    validationPerformed = true;
                }
            } else {
                LOG.warn("Status info returned by server has unknown GUID: {}, discard it.", (Object)status);
                status = null;
            }
            if (status == null) {
                historyEntry = null;
            }
        }
        if (validationPerformed && status == null) {
            LOG.warn("Validation already performed but not validated entry found, history may be incomplete.");
        }
        UploadHistoryDialog uploadHistoryDialog = UploadHistoryDialog.newInstance(parentShell, numeroContribuable, validationPerformed, status, historyEntry, new HistoryCallbackHandler(client));
        uploadHistoryDialog.open();
    }

    private @NonNull Collection<UploadHistoryEntry> loadUploadHistory(NoContribuable numeroContribuable) {
        Collection<UploadHistoryEntry> history;
        try {
            UploadHistory h = UploadHistory.loadHistory(UploadCdConfiguration.getUploadHistoryFile());
            history = h.getHistory(numeroContribuable);
        }
        catch (IOException e) {
            LOG.error("Cannot access upload history (no access right or possible data corruption), assume empty history.", (Throwable)e);
            history = Collections.emptyList();
        }
        return history;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void openSummary(UploadHistoryEntry historyEntry, UploadStatusDTO status) throws UploadException, InterruptedException {
        assert (historyEntry != null && status != null);
        UUID guid = historyEntry.getGuid();
        NoContribuable numeroContribuable = historyEntry.getNumeroContribuable();
        Instant pdfTimestamp = historyEntry.getPdfTimestamp();
        ExpertDisplayInfoDTO[] summaryExpertDisplayDTOs = historyEntry.getSummaryExpertDisplayDTOs();
        assert (guid != null && numeroContribuable != null && pdfTimestamp != null && summaryExpertDisplayDTOs != null) : "invalid null member: " + String.valueOf(historyEntry);
        String declarationCode = status.getDeclarationCode();
        Instant uploadDate = status.getTimestamp();
        UploadValidationStatus validationStatus = status.getValidationStatus();
        assert (declarationCode != null && declarationCode.length() > 0 && uploadDate != null) : "invalid null member: " + String.valueOf(status);
        assert (guid.equals(status.getGuid())) : "guid mismatch: " + String.valueOf(historyEntry) + " vs. " + String.valueOf(status);
        assert (validationStatus == UploadValidationStatus.VALIDATED_WITH_CODE_DI);
        Instant summaryTimestamp = Instant.now();
        FormRendererConfiguration config = JuUtil.newPrintConfiguration();
        JuUtil.prepareSummaryPagePrint((FormRendererConfiguration)config, (String)declarationCode, (Instant)pdfTimestamp);
        String fileName = String.valueOf(numeroContribuable) + "_" + Long.toHexString(guid.getMostSignificantBits()).toUpperCase() + "_" + DATE_TIME_FORMATTER_FNAME.format(summaryTimestamp) + ".pdf";
        File uploadDir = UploadCdConfiguration.getUploadDirectory();
        uploadDir.mkdirs();
        File dest = new File(uploadDir, fileName);
        TaxmeController ctrl = TaxmeController.getInstance();
        BufferedOutputStream summaryFileStream = null;
        try {
            summaryFileStream = new BufferedOutputStream(new FileOutputStream(dest));
            AbstractConverter.ConverterContext ctx = new AbstractConverter.ConverterContext(ctrl.getLocalizationHelper(), ctrl.getTmoCdSession().getDataModel(), null);
            FormRenderer r = FormRendererFactory.createRenderEngine(config, 0, ctx, ctrl.getImageSource());
            r.render(Arrays.asList(summaryExpertDisplayDTOs), (OutputStream)summaryFileStream);
        }
        catch (IOException e) {
            try {
                throw new UploadException("Failed to write to summary file", (Throwable)e, "label.dialog.summary.ioexception", "title.dialog.summary.ioexception");
                catch (FormRendererException e2) {
                    throw new UploadException("Form rendering for summary page failed", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(summaryFileStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)summaryFileStream);
        LaunchUtil.launchPdfReader(dest.getAbsolutePath());
    }

    private static void injectValuesInSummary(Map<String, String> injectedValues, ExpertDisplayInfoDTO[] summaryExpertDisplayDTOs) {
        block0: for (ExpertDisplayInfoDTO summaryExpertDisplayDTO : summaryExpertDisplayDTOs) {
            for (ExpertDisplayInfoDTO.ItemDTO item : summaryExpertDisplayDTO.getItems()) {
                ExpertDisplayInfoDTO.ValueItemDTO value;
                String dmk;
                String injectedValue;
                if (!(item instanceof ExpertDisplayInfoDTO.ValueItemDTO) || (injectedValue = injectedValues.get(dmk = (value = (ExpertDisplayInfoDTO.ValueItemDTO)item).getDataModelKey())) == null) continue;
                ModelItemDTO injectedValueItem = new ModelItemDTO(injectedValue, 1);
                injectedValueItem.setTouched();
                value.setModelItem(injectedValueItem);
                injectedValues.remove(dmk);
                if (!injectedValues.isEmpty()) continue;
                continue block0;
            }
        }
        if (!injectedValues.isEmpty()) {
            LOG.warn("Failed to inject values in summary pages for DMK(s): " + String.valueOf(injectedValues.keySet()));
        }
    }

    @Override
    public void init(IButtonItem buttonDTO) {
    }

    @Override
    public void execute(IButtonItem buttonDTO) {
        this.run();
    }

    private static class AskNumeroContribuableDialog
    extends Dialog {
        private final NoContribuableConverter converter = new NoContribuableConverter();
        private Text txt;
        private volatile NoContribuable numeroContribuable = null;

        public AskNumeroContribuableDialog(Shell parentShell) {
            super(parentShell);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.translate("title.dialog.uploadHistory.askNumeroContribuable", new Object[0]));
        }

        protected @NonNull Control createDialogArea(Composite parent) {
            Composite panel = new Composite(parent, 0);
            RowLayout layout = new RowLayout(256);
            layout.marginWidth = 20;
            layout.marginTop = 20;
            panel.setLayout((Layout)layout);
            Label lbl = new Label(panel, 0);
            lbl.setText(Messages.translate("label.dialog.uploadHistory.askTaxPayerNumber", new Object[0]));
            this.txt = new Text(panel, 0);
            RowData data = new RowData();
            data.width = 200;
            this.txt.setLayoutData((Object)data);
            this.txt.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                    this.okPressed();
                }
            });
            return panel;
        }

        protected void okPressed() {
            if (this.txt == null) {
                super.okPressed();
                return;
            }
            String numeroContribuable = this.txt.getText().trim();
            try {
                if (numeroContribuable.length() == 0) {
                    throw new AbstractConverter.ConvertException("error.format.noContribuable");
                }
                TaxmeController ctrl = TaxmeController.getInstance();
                AbstractConverter.ConverterContext ctx = new AbstractConverter.ConverterContext(ctrl.getLocalizationHelper(), ctrl.getTmoCdSession().getDataModel(), null);
                this.converter.getObject(numeroContribuable, null, ctx);
            }
            catch (AbstractConverter.ConvertException e) {
                JuDialogUtil.showDialog(this.getShell(), "title.dialog.uploadHistory.askNumeroContribuable.error", e.getMessage(), 1, new String[]{"label.button.retour"}, 0);
                return;
            }
            this.numeroContribuable = NoContribuable.parse((String)numeroContribuable);
            super.okPressed();
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, Messages.translate("label.button.ok", new Object[0]), true);
            this.createButton(parent, 1, Messages.translate("label.button.cancel", new Object[0]), false);
        }

        public NoContribuable getNumeroContribuable() {
            return this.numeroContribuable;
        }
    }

    private static class HistoryCallbackHandler
    implements UploadHistoryDialog.UploadHistoryCallbackHandler {
        private final UploadServiceClient client;

        public HistoryCallbackHandler(UploadServiceClient client) {
            assert (client != null);
            this.client = client;
        }

        @Override
        public boolean openSummary(Shell parentShell, UploadHistoryEntry historyEntry, UploadStatusDTO status) {
            try {
                JuUploadShowHistoryAction.openSummary(historyEntry, status);
            }
            catch (UploadException e) {
                LOG.error("Failed to open summary page.", (Throwable)e);
                JuDialogUtil.showDialog(parentShell, e);
                return false;
            }
            catch (InterruptedException e) {
                LOG.error("Current thread interrupted.", (Throwable)e);
                return false;
            }
            return true;
        }

        @Override
        public boolean validateUpload(Shell parentShell, NoContribuable numeroContribuable, UUID guid, UploadConfiguration.UploadType uploadType) {
            URL url;
            try {
                url = this.client.getValidationURL(numeroContribuable, guid, uploadType);
            }
            catch (IllegalArgumentException e) {
                LOG.error("Failed to construct validation url", (Throwable)e);
                return false;
            }
            boolean success = LaunchUtil.launchBrowser(url.toExternalForm());
            if (!success) {
                new OpenBrowserFailedDialog(parentShell, url).open();
                return false;
            }
            return true;
        }
    }
}

