/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.presentation.cd.dialog;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InputCodeDIDialog
extends MessageDialog {
    private final String previousAttempt;
    private volatile String codeDI;
    private static final Pattern INPUT_PTN = Pattern.compile("[\\p{Alnum}-]*");
    private static final Pattern SPLIT_PTN = Pattern.compile("(?<=\\G\\p{Alnum}{3}+)");
    private static final String DELIM_STR = "-";
    private static final Pattern DELIM_PTN = Pattern.compile(Pattern.quote("-"));
    private static final int CODE_DI_EXPECTED_LENGTH = 9;
    private static final int INPUT_MAX_LENGTH = 11;

    public InputCodeDIDialog(Shell parentShell, String previousAttempt) {
        super(parentShell, Messages.translate("title.dialog.upload.saisieCodeDI", new Object[0]), null, Messages.translate("label.dialog.upload.saisieCodeDI", new Object[0]), 3, new String[]{Messages.translate("label.dialog.upload.saisieCodeDI.valider", new Object[0]), Messages.translate("label.button.abbrechen", new Object[0])}, 0);
        this.previousAttempt = previousAttempt;
    }

    protected Control createCustomArea(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).align(0x1000000, 128).create());
        RowLayout rl = new RowLayout(512);
        rl.center = true;
        panel.setLayout((Layout)rl);
        Text codeDiInput = new Text(panel, 0x1000800);
        codeDiInput.setTextLimit(11);
        codeDiInput.setLayoutData((Object)new RowData(100, -1));
        if (this.previousAttempt != null) {
            String previousAttemptFmt = InputCodeDIDialog.formatCodeDI(this.previousAttempt);
            codeDiInput.setText(previousAttemptFmt);
            Label errorLbl = new Label(panel, 0);
            Color red = GuiUtil.getColorRegistry().get(GuiUtil.COLOR_RED);
            errorLbl.setForeground(red);
            errorLbl.setText(Messages.translate("label.dialog.upload.saisieCodeDI.erreur1", previousAttemptFmt));
            errorLbl = new Label(panel, 0);
            errorLbl.setForeground(red);
            errorLbl.setText(Messages.translate("label.dialog.upload.saisieCodeDI.erreur2", new Object[0]));
        }
        codeDiInput.addVerifyListener(e -> {
            String text = e.text.trim().toUpperCase();
            Matcher m = INPUT_PTN.matcher(text);
            if (!m.matches()) {
                e.doit = false;
            }
        });
        codeDiInput.addModifyListener(e -> {
            boolean codeValid;
            String text;
            int carretPos = codeDiInput.getCaretPosition();
            String currentText = codeDiInput.getText();
            this.codeDI = text = DELIM_PTN.matcher(currentText.trim().toUpperCase()).replaceAll("");
            int comp = Integer.valueOf(text.length()).compareTo(9);
            if (comp > 0) {
                text = text.substring(0, 9);
                codeValid = true;
            } else {
                codeValid = comp == 0;
            }
            this.codeDI = codeValid ? text : null;
            this.getButton(0).setEnabled(codeValid);
            text = InputCodeDIDialog.formatCodeDI(text);
            int diff = text.length() - currentText.length();
            carretPos = Math.min(text.length() + 1, Math.max(0, carretPos + diff));
            if (!currentText.equals(text)) {
                codeDiInput.setText(text);
                codeDiInput.setSelection(carretPos);
            }
        });
        Label exempleLbl = new Label(panel, 0);
        exempleLbl.setText(Messages.translate("label.dialog.upload.saisieCodeDI.exemple", new Object[0]));
        exempleLbl.setFont(GuiUtil.getFontRegistry().getItalic(""));
        int x = exempleLbl.computeSize((int)-1, (int)-1).x;
        exempleLbl.setLayoutData((Object)new RowData(x + 2, -1));
        return panel;
    }

    private static String formatCodeDI(String text) {
        assert (text != null);
        String[] tokens = SPLIT_PTN.split(text);
        StringBuilder sb = new StringBuilder();
        for (String token : tokens) {
            if (sb.length() > 0) {
                sb.append('-');
            }
            sb.append(token);
        }
        return sb.toString();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    public String getCodeDI() {
        return this.codeDI;
    }
}

