/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.presentation.cd.dialog;

import ch.dvbern.tax.common.presentation.cd.Messages;
import java.net.URL;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenBrowserFailedDialog
extends Dialog {
    private static final Logger LOG = LoggerFactory.getLogger(OpenBrowserFailedDialog.class);
    private final URL targetURL;

    public OpenBrowserFailedDialog(Shell parent, URL targetUrl) {
        super(parent);
        this.targetURL = targetUrl;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.translate("title.dialog.openbrowserfailed", new Object[0]));
    }

    protected Control createDialogArea(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout(1, false));
        Label msg = new Label(panel, 64);
        GridData gridData = new GridData();
        gridData.widthHint = this.getShell().getMonitor().getClientArea().width / 4;
        msg.setLayoutData((Object)gridData);
        msg.setText(Messages.translate("label.dialog.openbrowserfailed", new Object[0]));
        return panel;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button copyBtn = this.createButton(parent, 1024, Messages.translate("label.button.copy", new Object[0]), false);
        copyBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent evt) {
                try {
                    Clipboard clipboard = new Clipboard(Display.getDefault());
                    clipboard.setContents(new Object[]{OpenBrowserFailedDialog.this.targetURL.toExternalForm()}, new Transfer[]{TextTransfer.getInstance()});
                }
                catch (SWTError | SWTException e) {
                    LOG.error("Failed to copy url to clipboard.", e);
                }
            }

            public void widgetDefaultSelected(SelectionEvent evt) {
            }
        });
        this.createButton(parent, 0, Messages.translate("label.button.ok", new Object[0]), false);
    }
}

