/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.presentation.cd.dialog;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.util.LaunchUtil;
import ch.dvbern.tax.ju.presentation.cd.dialog.ErrorReportSentDialog;
import ch.dvbern.tax.ju.presentation.cd.util.JuDialogUtil;
import ch.dvbern.tax.ju.transfer.dto.NoContribuable;
import ch.dvbern.tax.ju.upload.UploadServiceClient;
import ch.dvbern.tax.ju.upload.UploadServiceClientFactory;
import ch.dvbern.tax.ju.upload.cd.FatalUploadException;
import ch.dvbern.tax.ju.upload.cd.UploadException;
import ch.dvbern.tax.ju.upload.cd.UploadServiceClientGUIAdapter;
import java.util.UUID;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendUploadErrorReportDialog
extends MessageDialog {
    private static final Logger LOG = LoggerFactory.getLogger(FatalUploadException.class);
    private final NoContribuable numeroContribuable;
    private final int year;
    private final UUID correlationId;
    private final String source;
    private final byte[] logArchive;
    private static final int INFO_SUP_BUTTON_INDEX = 0;
    private static final int SEND_BUTTON_INDEX = 1;
    private static final int DO_NOT_SEND_BUTTON_INDEX = 2;

    public SendUploadErrorReportDialog(Shell parentShell, NoContribuable numeroContribuable, int year, UUID correlationId, String source, byte[] logArchive) {
        super(parentShell, Messages.translate("label.dialog.upload.fatal.title", new Object[0]), null, Messages.translate("label.dialog.upload.fatal.msg", new Object[0]), 1, new String[]{Messages.translate("label.dialog.upload.fatal.buttons.infoSup", new Object[0]), Messages.translate("label.dialog.upload.fatal.buttons.send", new Object[0]), Messages.translate("label.dialog.upload.fatal.buttons.doNotSend", new Object[0])}, 2);
        if (numeroContribuable == null) {
            throw new NullPointerException("Tax payer number cannot be null");
        }
        if (logArchive == null) {
            throw new NullPointerException("Debug informations cannot be null");
        }
        if (correlationId == null) {
            throw new NullPointerException("Correlation id cannot be null");
        }
        if (source == null) {
            throw new NullPointerException("Error source cannot be null cannot be null");
        }
        this.numeroContribuable = numeroContribuable;
        this.year = year;
        this.correlationId = correlationId;
        this.source = source;
        this.logArchive = logArchive;
    }

    protected Control createCustomArea(Composite parent) {
        Composite customPanel = new Composite(parent, 0);
        customPanel.setLayout((Layout)new GridLayout(1, false));
        Label lbl = new Label(customPanel, 0);
        lbl.setText(Messages.translate("label.dialog.upload.fatal.body.faq", new Object[0]));
        Button faqBtn = new Button(customPanel, 8);
        faqBtn.setText(Messages.translate("label.dialog.upload.fatal.body.faq.button", new Object[0]));
        faqBtn.addSelectionListener(new SelectionListener(this){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LaunchUtil.launchBrowser("http://www.juratax.ch/fr/FAQ.html");
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
        lbl = new Label(customPanel, 0);
        lbl.setText(Messages.translate("label.dialog.upload.fatal.body.notify.1", new Object[0]));
        lbl.setFont(JuDialogUtil.getFont("JuHeaderBold"));
        GridDataFactory gdf = GridDataFactory.swtDefaults().indent(-1, 20);
        gdf.applyTo((Control)lbl);
        gdf.grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)faqBtn);
        lbl = new Label(customPanel, 0);
        lbl.setText(Messages.translate("label.dialog.upload.fatal.body.notify.2", new Object[0]));
        lbl = new Label(customPanel, 0);
        lbl.setText(Messages.translate("label.dialog.upload.fatal.body.notify.3", new Object[0]));
        return customPanel;
    }

    protected Control createMessageArea(Composite composite) {
        Control msgArea = super.createMessageArea(composite);
        this.messageLabel.setFont(JuDialogUtil.getFont("JuDefBold"));
        return msgArea;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 0: {
                LaunchUtil.launchBrowser("http://www.juratax.ch");
                return;
            }
            case 1: {
                Shell parentShell = this.getShell();
                UploadServiceClient client = UploadServiceClientFactory.login((NoContribuable)this.numeroContribuable, (int)this.year);
                UploadServiceClientGUIAdapter clientGUIAdapter = new UploadServiceClientGUIAdapter(parentShell, client);
                try {
                    clientGUIAdapter.sendUploadLog(this.logArchive, this.source, this.correlationId);
                }
                catch (UploadException e) {
                    LOG.error("Failed to send upload log", (Throwable)e);
                    JuDialogUtil.showDialog(parentShell, e);
                }
                catch (InterruptedException e) {
                    LOG.info("Sending upload log interrupted", (Throwable)e);
                }
                new ErrorReportSentDialog(parentShell).open();
                super.buttonPressed(buttonId);
                return;
            }
            case 2: {
                super.buttonPressed(buttonId);
                return;
            }
        }
        throw new AssertionError((Object)("Unknown button id: " + buttonId));
    }
}

