/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.presentation.cd.dialog;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.ju.presentation.cd.util.JuDialogUtil;
import ch.dvbern.tax.ju.transfer.dto.NoContribuable;
import ch.dvbern.tax.ju.upload.UploadConfiguration;
import ch.dvbern.tax.ju.upload.UploadStatusDTO;
import ch.dvbern.tax.ju.upload.UploadValidationStatus;
import ch.dvbern.tax.ju.upload.cd.UploadHistoryEntry;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public final class UploadHistoryDialog
extends MessageDialog {
    private static final int PRINT_SUMMARY_BTN_ID = 1024;
    private static final int VALIDATE_SWISSID_BTN_ID = 1025;
    private static final DateTimeFormatter DATE_FORMATTER_LONG = DateTimeFormatter.ofPattern("EEEE d MMMM \u00e0 HH:mm").withZone(UploadConfiguration.TIMEZONE).withLocale(UploadConfiguration.LOCALE);
    private final UploadStatusDTO uploadStatus;
    private final UploadHistoryEntry historyEntry;
    private final UploadHistoryCallbackHandler callbackHandler;
    private final Action action;

    private UploadHistoryDialog(Shell parentShell, String title, String msg, int imageType, UploadStatusDTO uploadStatus, UploadHistoryEntry historyEntry, Action action, UploadHistoryCallbackHandler callbackHandler) {
        super(parentShell, title, null, msg, imageType, new String[0], 0);
        assert (title != null && msg != null && !(uploadStatus == null ^ historyEntry == null) && callbackHandler != null);
        this.uploadStatus = uploadStatus;
        this.historyEntry = historyEntry;
        this.action = action;
        this.callbackHandler = callbackHandler;
    }

    public static UploadHistoryDialog newInstance(Shell parentShell, NoContribuable numeroContribuable, boolean validationPerformed, UploadStatusDTO uploadStatus, UploadHistoryEntry historyEntry, UploadHistoryCallbackHandler callbackHandler) {
        Action action;
        String msgKey;
        String titleKey;
        int imageType;
        if (numeroContribuable == null) {
            throw new NullPointerException("Tax payer number cannot be null.");
        }
        if (callbackHandler == null) {
            throw new NullPointerException("Summary handler cannot be null.");
        }
        if (uploadStatus == null ^ historyEntry == null) {
            throw new NullPointerException("Both or neither status and history must be non-null.");
        }
        if (validationPerformed) {
            if (uploadStatus != null && uploadStatus.getValidationStatus() == UploadValidationStatus.VALIDATED_WITH_CODE_DI) {
                imageType = 4;
                titleKey = "label.dialog.uploadHistory.title.codedi";
                msgKey = "label.dialog.uploadHistory.msg.justificatifs";
                action = Action.PRINT_SUMMARY_PAGE;
            } else {
                imageType = 2;
                titleKey = "label.dialog.uploadHistory.title";
                msgKey = "label.dialog.uploadHistory.msg.validationPerformed";
                action = Action.NO_ACTION;
            }
        } else {
            imageType = 4;
            if (uploadStatus != null) {
                if (uploadStatus.getValidationStatus() != UploadValidationStatus.NOT_VALIDATED) {
                    throw new IllegalArgumentException("Validation performed but status not validated: " + String.valueOf(uploadStatus));
                }
                titleKey = "label.dialog.uploadHistory.title.swissid";
                msgKey = "label.dialog.uploadHistory.msg.justificatifs";
                action = Action.VALIDATE_SWISSID;
            } else {
                titleKey = "label.dialog.uploadHistory.title";
                msgKey = "label.dialog.uploadHistory.msg.validationNotPerformed";
                action = Action.NO_ACTION;
            }
        }
        return new UploadHistoryDialog(parentShell, Messages.translate(titleKey, numeroContribuable), Messages.translate(msgKey, new Object[0]), imageType, uploadStatus, historyEntry, action, callbackHandler);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        String actionKey = null;
        int actionId = -1;
        if (this.action == Action.PRINT_SUMMARY_PAGE) {
            actionKey = "label.dialog.uploadHistory.button.showSummary";
            actionId = 1024;
        } else if (this.action == Action.VALIDATE_SWISSID) {
            assert (this.uploadStatus.getValidationStatus() == UploadValidationStatus.NOT_VALIDATED);
            actionKey = "label.dialog.uploadHistory.button.validate";
            actionId = 1025;
        }
        assert (actionKey != null);
        Button actionBtn = null;
        if (actionKey != null) {
            actionBtn = super.createButton(parent, actionId, Messages.translate(actionKey, new Object[0]), true);
            this.setButtonLayoutData(actionBtn);
        }
        Button closeBtn = this.createButton(parent, 0, Messages.translate("label.button.close", new Object[0]), actionBtn == null);
        if (actionBtn != null) {
            GridDataFactory.createFrom((GridData)((GridData)closeBtn.getLayoutData())).hint(-1, actionBtn.computeSize((int)-1, (int)-1).y).applyTo((Control)closeBtn);
        }
    }

    protected Control createMessageArea(Composite composite) {
        String dateTxt = null;
        String[] preludeKeys = null;
        if (this.uploadStatus != null) {
            dateTxt = Messages.translate("label.dialog.uploadHistory.date", DATE_FORMATTER_LONG.format(this.uploadStatus.getTimestamp()));
        }
        if (this.action == Action.PRINT_SUMMARY_PAGE) {
            preludeKeys = new String[]{"label.dialog.uploadHistory.prelude.codedi.1", "label.dialog.uploadHistory.prelude.codedi.2"};
        } else if (this.action == Action.VALIDATE_SWISSID) {
            preludeKeys = new String[]{"label.dialog.uploadHistory.prelude.swissid.1", "label.dialog.uploadHistory.prelude.swissid.2"};
        }
        if (dateTxt != null || preludeKeys != null) {
            Composite preludePanel = new Composite(composite, 0);
            GridLayoutFactory.swtDefaults().extendedMargins(0, 0, 0, 10).applyTo(preludePanel);
            GridDataFactory gdf = GridDataFactory.swtDefaults().hint(600, -1).align(4, 0x1000000).indent(0, 10);
            if (dateTxt != null) {
                Label dateLbl = new Label(preludePanel, 64);
                dateLbl.setText(dateTxt);
                gdf.applyTo((Control)dateLbl);
            }
            if (preludeKeys != null) {
                assert (preludeKeys.length > 0);
                for (String preludeKey : preludeKeys) {
                    Label preludeLbl = new Label(preludePanel, 64);
                    preludeLbl.setText(Messages.translate(preludeKey, new Object[0]));
                    gdf.applyTo((Control)preludeLbl);
                }
            }
            GridDataFactory.swtDefaults().span(((GridLayout)composite.getLayout()).numColumns, 1).applyTo((Control)preludePanel);
        }
        super.createMessageArea(composite);
        this.messageLabel.setFont(JuDialogUtil.getFont("JuDefBold"));
        return composite;
    }

    protected void handleShellCloseEvent() {
        if (this.mustClose()) {
            super.handleShellCloseEvent();
        }
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1024: {
                assert (this.action == Action.PRINT_SUMMARY_PAGE);
                this.callbackHandler.openSummary(this.getShell(), this.historyEntry, this.uploadStatus);
                this.close();
                break;
            }
            case 1025: {
                assert (this.action == Action.VALIDATE_SWISSID);
                this.callbackHandler.validateUpload(this.getShell(), this.historyEntry.getNumeroContribuable(), this.historyEntry.getGuid(), this.historyEntry.getUploadType());
                this.close();
                break;
            }
            default: {
                if (!this.mustClose()) break;
                super.buttonPressed(buttonId);
            }
        }
    }

    private boolean mustClose() {
        if (this.action == Action.PRINT_SUMMARY_PAGE) {
            int choice = JuDialogUtil.showDialog(this.getShell(), "title.dialog.uploadHistory.warnSummaryNotPrinted", "label.dialog.uploadHistory.warnSummaryNotPrinted", 4, new String[]{"label.button.close", "label.button.cancel"}, 1);
            return choice == 0;
        }
        if (this.action == Action.VALIDATE_SWISSID) {
            int choice = JuDialogUtil.showDialog(this.getShell(), "title.dialog.uploadHistory.warnNotValidated", "label.dialog.uploadHistory.warnNotValidated", 3, new String[]{"label.nein", "label.ja"}, 1);
            if (choice == 1) {
                this.buttonPressed(1025);
                return false;
            }
            return true;
        }
        return true;
    }

    private static enum Action {
        NO_ACTION,
        PRINT_SUMMARY_PAGE,
        VALIDATE_SWISSID;

    }

    public static interface UploadHistoryCallbackHandler {
        public boolean openSummary(Shell var1, UploadHistoryEntry var2, UploadStatusDTO var3);

        public boolean validateUpload(Shell var1, NoContribuable var2, UUID var3, UploadConfiguration.UploadType var4);
    }
}

