/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.presentation.cd.dialog;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.dialog.TaxmeTitleAreaDialog;
import ch.dvbern.tax.common.presentation.cd.items.IButtonItem;
import ch.dvbern.tax.common.presentation.cd.util.ButtonCommand;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.ValorDatabaseDTO;
import ch.dvbern.tax.ju.presentation.cd.FileSystemDataResource;
import ch.dvbern.tax.ju.presentation.common.JuDataResourceBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValorDatabaseDialog
extends TaxmeTitleAreaDialog {
    private static final Logger LOG = LoggerFactory.getLogger(ValorDatabaseDialog.class);
    private static final String SEARCH_RESULT = "label.valordatabase.searchresult";
    private static final String NO_SEARCH_RESULT = "label.valordatabase.nosearchresult";
    private final int type;
    private final String valorNumberDMK;
    private final String commandDmk;
    private final LocalizationHelper locHelper;
    private Button searchAction;
    private Text searchText;
    private Label searchResultTitel;
    private Table searchResultTable;
    private TableViewer searchResultViewer;
    private final FileSystemDataResource dataResource = FileSystemDataResource.getInstance();

    private ValorDatabaseDialog(Shell parentShell, int type, String valorNumberDMK, String commandDmk) {
        super(parentShell);
        this.type = type;
        this.valorNumberDMK = valorNumberDMK;
        this.commandDmk = commandDmk;
        this.locHelper = TaxmeController.getInstance().getLocalizationHelper();
    }

    protected @Nullable Control createDialogArea(Composite parent) {
        try {
            this.getShell().setText(this.locHelper.translate("title.shell.valor.search", null));
            this.setTitle(this.locHelper.translate("title.valor.search.dialog", null));
            this.setMessage(this.locHelper.translate("label.valor.search.dialog", null));
            Composite composite = (Composite)super.createDialogArea(parent);
            this.createContent(composite);
            return composite;
        }
        catch (LocalizationHelper.LocalizationHelperException e) {
            LOG.error("could not translate text: ", (Throwable)e);
            return null;
        }
    }

    private void createContent(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginTop = 20;
        layout.marginLeft = 20;
        layout.marginBottom = 20;
        layout.marginRight = 20;
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData());
        this.searchText = new Text(panel, 2048);
        GridData gd = new GridData();
        gd.widthHint = 300;
        this.searchText.setLayoutData((Object)gd);
        this.searchText.addModifyListener(me -> this.getShell().setDefaultButton(this.searchAction));
        this.searchAction = new Button(panel, 0);
        this.searchAction.setText(Messages.translate("label.button.valordatabase.search", this.searchAction));
        this.searchAction.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ValorDatabaseDialog.this.searchResultTitel.setText(Messages.translate(ValorDatabaseDialog.SEARCH_RESULT, new Object[0]));
                ArrayList<ValorDatabaseDTO> result = new ArrayList<ValorDatabaseDTO>();
                for (Object object : ValorDatabaseDialog.this.dataResource.get(JuDataResourceBase.ResourceEnum.VALOR.getCode(), null, null).values()) {
                    ValorDatabaseDTO vDTO = (ValorDatabaseDTO)object;
                    if (vDTO.getType() != ValorDatabaseDialog.this.type) continue;
                    String s = ValorDatabaseDialog.this.searchText.getText().toLowerCase();
                    if (s.length() > 1 && vDTO.getBezeichnung().toLowerCase().contains(s)) {
                        result.add(vDTO);
                    }
                    if (s.length() > 1 || !vDTO.getBezeichnung().toLowerCase().startsWith(s)) continue;
                    result.add(vDTO);
                }
                if (result.size() > 0) {
                    ValorDatabaseDialog.this.getButton(0).setEnabled(false);
                    ValorDatabaseDialog.this.searchResultViewer.setInput(result);
                    ValorDatabaseDialog.this.searchResultTable.deselectAll();
                    ValorDatabaseDialog.this.searchResultTable.setFocus();
                    ValorDatabaseDialog.this.searchResultTable.setSelection(0);
                    ValorDatabaseDialog.this.getButton(0).setEnabled(true);
                    ValorDatabaseDialog.this.getShell().setDefaultButton(ValorDatabaseDialog.this.getButton(0));
                } else {
                    ValorDatabaseDialog.this.searchText.setFocus();
                    ValorDatabaseDialog.this.searchResultTitel.setText(Messages.translate(ValorDatabaseDialog.NO_SEARCH_RESULT, new Object[0]));
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.widthHint = 400;
        new Label(panel, 0).setLayoutData((Object)gd);
        this.searchResultTitel = new Label(panel, 0);
        this.searchResultTitel.setText(Messages.translate(SEARCH_RESULT, this.searchResultTitel));
        this.searchResultTitel.setLayoutData((Object)gd);
        this.searchResultTable = new Table(panel, 68100);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.widthHint = 400;
        gd.heightHint = 200;
        this.searchResultTable.setLayoutData((Object)gd);
        this.searchResultTable.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
        this.searchResultTable.setLinesVisible(true);
        this.searchResultTable.setEnabled(true);
        TableColumn colNumber = new TableColumn(this.searchResultTable, 16384);
        colNumber.setWidth(100);
        TableColumn colText = new TableColumn(this.searchResultTable, 16384);
        colText.setWidth(300);
        this.searchResultViewer = new TableViewer(this.searchResultTable);
        this.searchResultViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(this){

            public Object[] getElements(Object rows) {
                if (rows instanceof List) {
                    return ((List)rows).toArray();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
            }
        });
        this.searchResultViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(this){

            public Image getColumnImage(Object row, int col) {
                return null;
            }

            public String getColumnText(Object row, int col) {
                if (row instanceof ValorDatabaseDTO) {
                    ValorDatabaseDTO vDTO = (ValorDatabaseDTO)row;
                    switch (col) {
                        case 0: {
                            return vDTO.getNummer().toString();
                        }
                        case 1: {
                            return vDTO.getBezeichnung();
                        }
                    }
                }
                return "";
            }

            public void addListener(ILabelProviderListener arg0) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object arg0, String arg1) {
                return false;
            }

            public void removeListener(ILabelProviderListener arg0) {
            }
        });
        this.searchResultViewer.setUseHashlookup(true);
        this.searchResultTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ValorDatabaseDialog.this.getButton(0).setEnabled(true);
                ValorDatabaseDialog.this.getShell().setDefaultButton(ValorDatabaseDialog.this.getButton(0));
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.searchResultTable.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent arg0) {
                if (ValorDatabaseDialog.this.searchResultTable.getSelection().length > 0) {
                    ValorDatabaseDialog.this.okPressed();
                }
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseUp(MouseEvent arg0) {
            }
        });
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    protected void okPressed() {
        if (this.searchResultTable.getSelection().length > 0) {
            TableItem[] tis = this.searchResultTable.getSelection();
            Long newNumber = new Long(tis[0].getText());
            HashMap<String, ModelItemDTO> changes = new HashMap<String, ModelItemDTO>();
            changes.put(this.valorNumberDMK, new ModelItemDTO(newNumber));
            changes.put(this.commandDmk, new ModelItemDTO("doSearch"));
            String dmk = TaxmeController.getInstance().getDataModelKey();
            TaxmeController.getInstance().getTmoCdSession().update(changes, true, true, dmk);
            TaxmeController.getInstance().update();
        }
        super.okPressed();
    }

    public static class ValorDatabaseButtonCommand
    implements ButtonCommand {
        private final int type;

        public ValorDatabaseButtonCommand(int type) {
            this.type = type;
        }

        @Override
        public void init(IButtonItem buttonDTO) {
        }

        @Override
        public void execute(IButtonItem buttonDTO) {
            ValorDatabaseDialog vdd = new ValorDatabaseDialog(TaxmeController.getInstance().getShell(), this.type, buttonDTO.getValueDmk(), buttonDTO.getCommandDmk());
            vdd.open();
        }
    }
}

