/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.presentation.cd.util;

import ch.dvbern.tax.ju.utils.ProgressMonitor;
import ch.dvbern.tax.ju.utils.Task;
import ch.dvbern.tax.ju.utils.TaskFailedException;
import java.lang.reflect.InvocationTargetException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class JFaceTaskAdapter
implements IRunnableWithProgress {
    private final Task task;

    public JFaceTaskAdapter(@NonNull Task task) {
        if (task == null) {
            throw new NullPointerException("Task cannot be null.");
        }
        this.task = task;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            this.task.run((ProgressMonitor)new MonitorAdapter(monitor));
        }
        catch (TaskFailedException e) {
            throw new InvocationTargetException(e.getCause(), "Archive generation failed");
        }
    }

    private static class MonitorAdapter
    implements ProgressMonitor {
        private final SubMonitor monitor;

        MonitorAdapter(SubMonitor monitor) {
            this.monitor = monitor;
        }

        MonitorAdapter(IProgressMonitor monitor) {
            this(SubMonitor.convert((IProgressMonitor)monitor));
        }

        public void beginTask(String name, int totalWork) {
            this.monitor.beginTask(name, totalWork);
        }

        public @NonNull ProgressMonitor newChild(int totalWork) {
            return new MonitorAdapter(this.monitor.newChild(totalWork));
        }

        public void worked(int i) {
            this.monitor.worked(i);
        }

        public void setWorkRemaining(int workRemaining) {
            this.monitor.setWorkRemaining(workRemaining);
        }

        public void done() {
            this.monitor.done();
        }

        public boolean isCancelled() {
            return this.monitor.isCanceled();
        }
    }
}

