/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.presentation.cd.util;

import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.tax.common.integration.conf.AbstractCdApplicationConfig;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.integration.conf.ApplicationConfigProvider;
import ch.dvbern.tax.common.presentation.cd.util.SystemIdentifier;
import ch.dvbern.tax.ju.InternalFailureException;
import ch.dvbern.tax.ju.SystemInfo;
import ch.dvbern.tax.ju.engine.calcitems.CFMessage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.checkerframework.checker.nullness.qual.NonNull;

public class JuCdApplicationConfig
extends AbstractCdApplicationConfig {
    public static final String CONFIG_PREFIX = "ch.dvbern.tax.ju";
    public static final File CD_APP_CONFIG = new File("app-config.properties");

    @Override
    public Integer getStartIndexForUserInsertedTableEntries() {
        return 90000;
    }

    @Override
    public String getEngineId(String user) {
        return null;
    }

    protected JuCdApplicationConfig() {
        try {
            if (this.appConfigPath().isFile()) {
                this.copyProperties(this.appConfigPath());
            }
            this.copySystemProperties();
            try (InputStream is = Objects.requireNonNull(JuCdApplicationConfig.class.getResourceAsStream("/app-specific-cd.properties"));){
                this.copyProperties(is);
            }
            catch (IOException | ConfigurationException e) {
                throw new InternalFailureException("Failed to load bundled configuration file.", e);
            }
        }
        catch (ConfigurationException e) {
            throw new InternalFailureException("Failed to load bundled configuration file.", (Throwable)e);
        }
    }

    protected @NonNull File appConfigPath() {
        return CD_APP_CONFIG;
    }

    @Override
    protected boolean containsKeyInternal(String key) {
        String prefixedKey = this.prefixKey(CONFIG_PREFIX, key);
        if (super.containsKeyInternal(prefixedKey)) {
            return true;
        }
        return super.containsKeyInternal(key);
    }

    @Override
    protected Object getPropertyInternal(String key) {
        String prefixedKey = this.prefixKey(CONFIG_PREFIX, key);
        if (super.containsKeyInternal(prefixedKey)) {
            return super.getPropertyInternal(prefixedKey);
        }
        return super.getPropertyInternal(key);
    }

    @Override
    public Map<String, ElementParser> getAdditionalXmlParsers() {
        HashMap<String, ElementParser> parsers = new HashMap<String, ElementParser>();
        parsers.put("ju-message", (ElementParser)new CFMessage.XMLFactory());
        return parsers;
    }

    public static SystemInfo getSystemInfo() {
        return new SystemInfo(SystemIdentifier.getOSIdentifier(), SystemIdentifier.getJVMIdentifier());
    }

    public static class Provider
    extends ApplicationConfigProvider {
        @Override
        protected ApplicationConfig load() {
            return new JuCdApplicationConfig();
        }
    }
}

