/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.presentation.cd.util;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.ju.upload.cd.UploadException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public final class JuDialogUtil {
    private static final Image TITLE_IMAGE = GuiUtil.getImageRegistry().get("icon.window.app");
    public static final String BOLD_FONT = "JuDefBold";
    private static final String ITALIC_FONT = "JuDefItalic";
    public static final String BOLD_HEADER_FONT = "JuHeaderBold";
    private static volatile boolean fontRegistryInitDone = false;

    private JuDialogUtil() {
    }

    public static void showDialog(Shell parentShell, UploadException e) {
        JuDialogUtil.showDialogInternal(parentShell, e.getLocalizedTitle(), e.getUserMessage(), 1, new String[]{"OK"}, 0);
    }

    public static int showDialog(Shell parentShell, String titleKey, String msgKey, int dialogMessageType, String[] labels, int defaultIndex) {
        if (labels == null) {
            throw new NullPointerException("Invalid null argument: labels");
        }
        if (labels.length < 1) {
            throw new IllegalArgumentException("At lease one label should be specified.");
        }
        if (defaultIndex >= labels.length) {
            throw new ArrayIndexOutOfBoundsException("Label array size: " + labels.length + " - Default index: " + defaultIndex);
        }
        String title = Messages.translate(titleKey, new Object[0]);
        String msg = Messages.translate(msgKey, new Object[0]);
        String[] resolvedLabels = JuDialogUtil.resolveMsgs(labels);
        return JuDialogUtil.showDialogInternal(parentShell, title, msg, dialogMessageType, resolvedLabels, defaultIndex);
    }

    private static int showDialogInternal(Shell parentShell, String title, String msg, int dialogMessageType, String[] labels, int defaultIndex) {
        MessageDialog dlg = new MessageDialog(parentShell, title, TITLE_IMAGE, msg, dialogMessageType, labels, defaultIndex);
        return dlg.open();
    }

    private static String[] resolveMsgs(String[] keys) {
        assert (keys != null);
        String[] msgs = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            msgs[i] = Messages.translate(keys[i], new Object[0]);
        }
        return msgs;
    }

    public static Font getFont(String name) {
        if (name == null) {
            throw new NullPointerException("Font name cannot be null");
        }
        FontRegistry fontRegistry = GuiUtil.getFontRegistry();
        if (!fontRegistryInitDone) {
            FontDescriptor fd = GuiUtil.getFontRegistry().defaultFontDescriptor();
            fd = fd.setStyle(1);
            fontRegistry.put(BOLD_FONT, fd.getFontData());
            fd = fd.increaseHeight(1);
            fontRegistry.put(BOLD_HEADER_FONT, fd.getFontData());
            fontRegistryInitDone = true;
            fd = GuiUtil.getFontRegistry().defaultFontDescriptor();
            fd = fd.setStyle(2);
            fontRegistry.put(ITALIC_FONT, fd.getFontData());
        }
        return fontRegistry.get(name);
    }
}

