/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.presentation.cd.util;

import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.cd.util.TaxFileConfig;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaxmeJuFilename
extends TaxFileConfig {
    private static final Long TAX_YEAR_EXPECTED = ApplicationConfig.getInstance().getJahr();
    private static final Logger LOG = LoggerFactory.getLogger(TaxmeJuFilename.class);

    public boolean checkVersion(Map dataModel) {
        Object value;
        Long taxYear = null;
        ModelItemDTO taxYearItem = (ModelItemDTO)dataModel.get("Stammdaten.Declaration.PeriodeTaxation");
        if (taxYearItem != null && (value = taxYearItem.getValue()) != null) {
            if (value instanceof Long) {
                taxYear = (Long)value;
            } else {
                try {
                    taxYear = Long.valueOf(value.toString());
                }
                catch (Exception e) {
                    LOG.warn("tax year conversion failed", (Throwable)e);
                    taxYear = null;
                }
            }
        }
        return taxYear != null && TAX_YEAR_EXPECTED.equals(taxYear);
    }

    public String getFileName(Map datamodel) {
        ModelItemDTO nomContribuableDTO = (ModelItemDTO)datamodel.get("Stammdaten.Monsieur.Nom");
        ModelItemDTO prenomContribuableDTO = (ModelItemDTO)datamodel.get("Stammdaten.Monsieur.Prenom");
        ModelItemDTO steuerjahrDTO = (ModelItemDTO)datamodel.get("Stammdaten.Declaration.PeriodeTaxation");
        String nomContribuable = nomContribuableDTO != null && nomContribuableDTO.getValue() != null ? (String)nomContribuableDTO.getValue() : "";
        String prenomContribuable = prenomContribuableDTO != null && prenomContribuableDTO.getValue() != null ? (String)prenomContribuableDTO.getValue() : "";
        String steuerjahr = steuerjahrDTO != null && steuerjahrDTO.getValue() != null ? String.valueOf(steuerjahrDTO.getValue()) : "";
        Object filename = nomContribuable + "_" + prenomContribuable;
        if (((String)filename).length() > 20) {
            filename = ((String)filename).substring(0, 20);
        }
        filename = (steuerjahr + "_" + (String)filename).replace(' ', '_');
        return filename;
    }
}

