/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.upload.cd;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.ju.upload.UploadServiceClient;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractUploadTask<T>
implements IRunnableWithProgress {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUploadTask.class);
    private static final int POLLING_RATE = 1000;
    private final String msgKey;
    private final int workAmount;
    private final UploadServiceClient client;
    private volatile T result = null;

    public AbstractUploadTask(String msgKey, UploadServiceClient client) {
        this(msgKey, -1, client);
    }

    public AbstractUploadTask(String msgKey, int workAmount, UploadServiceClient client) {
        if (msgKey == null) {
            throw new NullPointerException("msgKey cannot be null");
        }
        if (client == null) {
            throw new NullPointerException("client cannot be null");
        }
        this.msgKey = msgKey;
        this.workAmount = workAmount;
        this.client = client;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask(Messages.translate(this.msgKey, new Object[0]), this.workAmount);
        this.result = this.processCall(monitor, this.getCallable(monitor));
    }

    protected abstract Callable<T> getCallable(IProgressMonitor var1);

    private T processCall(IProgressMonitor monitor, Callable<T> callable) throws InvocationTargetException, InterruptedException {
        Future<T> call;
        if (monitor == null) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        try {
            call = Executors.newSingleThreadExecutor().submit(callable);
        }
        catch (RejectedExecutionException ree) {
            LOG.error("Failed to use executor", (Throwable)ree);
            try {
                return callable.call();
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        T result = null;
        try {
            do {
                try {
                    result = call.get(1000L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    if (!monitor.isCanceled()) continue;
                    this.client.shutdown();
                    result = call.get();
                }
            } while (!call.isDone());
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof InterruptedException) {
                throw (InterruptedException)cause;
            }
            throw new InvocationTargetException(cause);
        }
        catch (CancellationException e) {
            assert (false) : "Unreachable code path: no cancel is ever performed";
            throw new InterruptedException("Operation cancelled");
        }
        return result;
    }

    public T getResult() {
        return this.result;
    }
}

