/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.upload.cd;

import ch.dvbern.tax.common.presentation.bd.cd.DvbTaxCdSession;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.common.util.TaxFileUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.failure.ApplicationException;
import ch.dvbern.tax.ju.DateUtil;
import ch.dvbern.tax.ju.JuUtil;
import ch.dvbern.tax.ju.upload.cd.FatalUploadException;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.slf4j.LoggerFactory;

public class ErrorReportGenerationTask
implements IRunnableWithProgress {
    private final FatalUploadException exception;
    private final Instant timestamp;
    private final UUID correlationId;
    private final List<ILoggingEvent> logEvents;
    private final OutputStream output;

    public ErrorReportGenerationTask(FatalUploadException exception, Instant timestamp, UUID correlationId, List<ILoggingEvent> logEvents, OutputStream output) {
        Objects.requireNonNull(exception, "Source exception cannot be null");
        Objects.requireNonNull(timestamp, "Timestamp cannot be null.");
        Objects.requireNonNull(correlationId, "Correlation id cannot be null");
        Objects.requireNonNull(logEvents, "Logging events cannot be null");
        Objects.requireNonNull(output, "Output stream cannot be null");
        this.exception = exception;
        this.timestamp = timestamp;
        this.correlationId = correlationId;
        this.logEvents = logEvents;
        this.output = output;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        DvbTaxCdSession session = TaxmeController.getInstance().getTmoCdSession();
        ZipOutputStream zipStream = new ZipOutputStream(this.output);
        try {
            if (!this.logEvents.isEmpty()) {
                this.dumpLog(this.nextEntry("upload.log", zipStream));
            }
            this.storeReportId(this.timestamp, this.correlationId, this.nextEntry("id.txt", zipStream));
            this.storeTaxFile(session, this.nextEntry("data.tax", zipStream));
            this.dumpSysInfo(this.nextEntry("sys_info.txt", zipStream));
            this.dumpStackstrace(this.nextEntry("stacktrace.txt", zipStream));
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)zipStream);
        }
    }

    private OutputStream nextEntry(String name, ZipOutputStream zipStream) throws IOException {
        assert (name != null && zipStream != null);
        zipStream.putNextEntry(new ZipEntry(name));
        return new CloseShieldOutputStream((OutputStream)zipStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeReportId(Instant timestamp, UUID correlationId, OutputStream output) throws IOException {
        assert (correlationId != null && output != null);
        OutputStreamWriter osw = new OutputStreamWriter(output, JuUtil.UTF_8);
        DateTimeFormatter fmt = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG).withZone(DateUtil.APPLICATION_TIMEZONE).withLocale(JuUtil.APPLICATION_LOCALE);
        try {
            osw.write(correlationId.toString() + "\n");
            osw.write(fmt.format(timestamp));
        }
        finally {
            IOUtils.closeQuietly((Writer)osw);
        }
    }

    private void storeTaxFile(DvbTaxCdSession session, OutputStream output) throws IOException {
        assert (session != null && output != null);
        HashMap<String, ModelItemDTO> dataModel = new HashMap<String, ModelItemDTO>(session.getDataModel());
        try {
            TaxFileUtil.write(output, dataModel, "");
        }
        catch (ApplicationException e) {
            throw new IOException("Failed to dump tax file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpLog(OutputStream output) throws IOException {
        assert (output != null);
        OutputStreamWriter osw = new OutputStreamWriter(output, JuUtil.UTF_8);
        try {
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            PatternLayout logLayout = new PatternLayout();
            logLayout.setContext((Context)lc);
            logLayout.setPattern("%d{HH:mm:ss.SSS} [%thread] %-5level %logger{36} - %msg%n");
            logLayout.start();
            for (ILoggingEvent evt : this.logEvents) {
                osw.write(logLayout.doLayout(evt));
            }
        }
        finally {
            IOUtils.closeQuietly((Writer)osw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpSysInfo(OutputStream output) throws IOException {
        assert (output != null);
        OutputStreamWriter osw = new OutputStreamWriter(output, JuUtil.UTF_8);
        try {
            String sectSep = StringUtils.repeat((String)"\u203e", (int)80);
            osw.write("System runtime informations:\n");
            osw.write(StringUtils.repeat((String)"*", (int)80) + "\n");
            osw.write("\nGeneral\n");
            osw.write(sectSep + "\n");
            Runtime r = Runtime.getRuntime();
            int mb = 0x100000;
            long totalMemory = r.totalMemory() / (long)mb;
            long freeMemory = r.freeMemory() / (long)mb;
            long maxMemory = r.maxMemory() / (long)mb;
            BigDecimal freeMemoryRatio = new BigDecimal(freeMemory).divide(new BigDecimal(totalMemory), 4, 5);
            osw.write("Total memory: " + totalMemory + " MB\n");
            osw.write("Free memory: " + freeMemory + " MB (" + new DecimalFormat("###.00%").format(freeMemoryRatio) + ")\n");
            osw.write("Max memory: " + maxMemory + " MB\n");
            osw.write("Available processors: " + r.availableProcessors() + "\n");
            osw.write("Default Locale: " + String.valueOf(Locale.getDefault()) + "\n");
            osw.write("Default Timezone: " + String.valueOf(TimeZone.getDefault()) + "\n");
            osw.write("Default Charset: " + String.valueOf(Charset.defaultCharset()) + "\n");
            osw.write("\nRuntime MXBean\n");
            osw.write(sectSep + "\n");
            RuntimeMXBean rmxb = ManagementFactory.getRuntimeMXBean();
            osw.write("Name: " + rmxb.getName() + "\n");
            osw.write("Spec. name: " + rmxb.getSpecName() + "\n");
            osw.write("VM name: " + rmxb.getVmName() + "\n");
            osw.write("VM version: " + rmxb.getVmVersion() + "\n");
            osw.write("VM vendor: " + rmxb.getVmVendor() + "\n");
            osw.write("Boot classpath: " + (rmxb.isBootClassPathSupported() ? rmxb.getBootClassPath() : "not supported") + "\n");
            osw.write("Classpath: " + rmxb.getClassPath() + "\n");
            osw.write("Input arguments: " + String.valueOf(rmxb.getInputArguments()) + "\n");
            osw.write("Library path: " + rmxb.getLibraryPath() + "\n");
            osw.write("Start time: " + String.valueOf(new Date(rmxb.getStartTime())) + "\n");
            osw.write("Uptime: " + rmxb.getUptime() + "ms.\n");
            osw.write("\nMemory MXBean\n");
            osw.write(sectSep + "\n");
            MemoryMXBean mmxb = ManagementFactory.getMemoryMXBean();
            osw.write("Heap Memory usage:\n" + String.valueOf(mmxb.getHeapMemoryUsage()) + "\n");
            osw.write("Non-Heap Memory usage:\n" + String.valueOf(mmxb.getNonHeapMemoryUsage()) + "\n");
            osw.write("\nSystem properties\n");
            osw.write(sectSep + "\n");
            Properties props = System.getProperties();
            Set<Map.Entry<Object, Object>> entries = props.entrySet();
            for (Map.Entry<Object, Object> entry : entries) {
                osw.write(String.valueOf(entry.getKey()) + " = '" + String.valueOf(entry.getValue()) + "'\n");
            }
        }
        finally {
            IOUtils.closeQuietly((Writer)osw);
        }
    }

    private void dumpStackstrace(OutputStream output) {
        assert (output != null);
        PrintWriter stream = new PrintWriter(new OutputStreamWriter(output, JuUtil.UTF_8));
        try {
            this.exception.printStackTrace(stream);
            stream.flush();
        }
        finally {
            IOUtils.closeQuietly((Writer)stream);
        }
    }
}

