/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.upload.cd;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.ju.transfer.dto.NoContribuable;
import ch.dvbern.tax.ju.upload.UploadDataSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.ProxyInputStream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

class MonitoredDataSource
extends UploadDataSource {
    private final IProgressMonitor monitor;
    private final byte[] archive;

    MonitoredDataSource(@Nullable IProgressMonitor monitor, byte[] archive, @NonNull NoContribuable numeroContribuable, int year, @NonNull String digest) {
        super(numeroContribuable, year, digest);
        assert (archive != null);
        this.monitor = monitor;
        this.archive = archive;
    }

    public InputStream getInputStream() throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(this.archive);
        if (this.monitor != null) {
            final SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)this.monitor, (String)Messages.translate("label.dialog.upload.uploadTask", new Object[0]), (int)this.archive.length);
            in = new ProxyInputStream(this, new ByteArrayInputStream(this.archive)){

                protected synchronized void afterRead(int n) {
                    subMonitor.worked(n);
                }
            };
        }
        return in;
    }
}

