/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.upload.cd;

import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import java.io.File;

public abstract class UploadCdConfiguration {
    public static final String DEFAULT_UPLOAD_DIRPATH = "televersement";
    public static final String UPLOAD_DIRNAME_CONFIG_KEY = "upload.dir";
    public static final String DEFAULT_HISTORY_FILEPATH = "history.dat";
    public static final String HISTORY_FILEPATH_CONFIG_KEY = "upload.history";
    public static final String UNDEFINED_ERROR_CODE = "Undefined";
    public static final String INFO_SUPP_URL = "http://www.juratax.ch";
    public static final String FAQ_URL = "http://www.juratax.ch/fr/FAQ.html";
    private static final File JURATAX_HOME_DIR = new File(TaxmeConfig.getUserHome(), "JuraTax" + ApplicationConfig.getInstance().getJahr());

    private UploadCdConfiguration() {
    }

    public static File getUploadDirectory() {
        String uploadDir = TaxmeConfig.getString(UPLOAD_DIRNAME_CONFIG_KEY, DEFAULT_UPLOAD_DIRPATH);
        return new File(JURATAX_HOME_DIR, uploadDir);
    }

    public static synchronized File getUploadHistoryFile() {
        String historyFilename = TaxmeConfig.getString(HISTORY_FILEPATH_CONFIG_KEY, DEFAULT_HISTORY_FILEPATH);
        return new File(UploadCdConfiguration.getUploadDirectory(), historyFilename);
    }
}

