/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.upload.cd;

import ch.dvbern.tax.ju.transfer.dto.NoContribuable;
import ch.dvbern.tax.ju.upload.cd.UploadHistoryEntry;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UploadHistory {
    private static final Logger LOG = LoggerFactory.getLogger(UploadHistory.class);
    private final File historyFile;
    private final Map<UUID, UploadHistoryEntry> history;

    private UploadHistory(File historyFile) {
        assert (historyFile != null);
        this.historyFile = historyFile;
        this.history = new HashMap<UUID, UploadHistoryEntry>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized UploadHistory loadHistory(File historyFile) throws IOException {
        if (historyFile == null) {
            throw new NullPointerException("history file cannot be null");
        }
        UploadHistory uploadHistory = new UploadHistory(historyFile);
        if (!historyFile.exists()) return uploadHistory;
        if (historyFile.length() <= 0L) return uploadHistory;
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        Closeable raf = null;
        try {
            fis = new FileInputStream(historyFile);
            ois = new ObjectInputStream(new BufferedInputStream(fis));
            Object object = ois.readObject();
            if (object != null) {
                if (!(object instanceof UploadHistoryEntry[])) {
                    throw new IOException("Unrecognized history format: " + object.getClass().getCanonicalName());
                }
                UploadHistoryEntry[] history = (UploadHistoryEntry[])object;
                if (history.length > 0) {
                    for (UploadHistoryEntry entry : history) {
                        if (entry == null) {
                            LOG.warn("Null entry in persisted history.");
                            continue;
                        }
                        uploadHistory.addEntry(entry);
                    }
                    LOG.debug(uploadHistory.getSize() + " history entries successfuly loaded.");
                } else {
                    LOG.debug("Ignoring empty history file.");
                }
            }
            IOUtils.closeQuietly(raf);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Unrecognized history format.", e);
            catch (FileNotFoundException fileNotFoundException) {
                return uploadHistory;
            }
        }
        IOUtils.closeQuietly((InputStream)fis);
        IOUtils.closeQuietly((InputStream)ois);
        return uploadHistory;
        finally {
            IOUtils.closeQuietly(raf);
            IOUtils.closeQuietly((InputStream)fis);
            IOUtils.closeQuietly(ois);
        }
    }

    public synchronized void addEntry(UploadHistoryEntry entry) {
        if (entry == null) {
            throw new NullPointerException("history entry cannot be null");
        }
        UploadHistoryEntry oldEntry = this.history.put(entry.getGuid(), entry);
        if (oldEntry != null) {
            LOG.info("Updated history entry (old: {} new: {} equals: {})", new Object[]{oldEntry, entry, entry.equals(oldEntry)});
        }
    }

    public synchronized Collection<UploadHistoryEntry> getHistory(NoContribuable numeroContribuable) {
        List<UploadHistoryEntry> contribuableHistory = this.history.values().stream().filter(entry -> entry.getNumeroContribuable().equals((Object)numeroContribuable)).collect(Collectors.toList());
        return contribuableHistory;
    }

    public synchronized int getSize() {
        return this.history.size();
    }

    public synchronized UploadHistoryEntry getHistoryEntry(UUID guid) {
        return this.history.get(guid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void persist() throws IOException {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        Closeable raf = null;
        try {
            this.historyFile.getParentFile().mkdirs();
            fos = new FileOutputStream(this.historyFile);
            oos = new ObjectOutputStream(new BufferedOutputStream(fos));
            UploadHistoryEntry[] array = this.history.values().toArray(new UploadHistoryEntry[this.history.size()]);
            oos.writeObject(array);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(raf);
            IOUtils.closeQuietly(oos);
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly(raf);
        IOUtils.closeQuietly((OutputStream)oos);
        IOUtils.closeQuietly((OutputStream)fos);
    }
}

