/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.upload.cd;

import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.ju.transfer.dto.NoContribuable;
import ch.dvbern.tax.ju.upload.UploadConfiguration;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.UUID;

public final class UploadHistoryEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final NoContribuable numeroContribuable;
    private final UUID guid;
    private final Instant pdfTimestamp;
    private final UploadConfiguration.UploadType uploadType;
    private final ExpertDisplayInfoDTO[] summaryExpertDisplayDTOs;

    public UploadHistoryEntry(UUID guid, NoContribuable numeroContribuable, Instant pdfTimestamp, UploadConfiguration.UploadType uploadType) {
        this(guid, numeroContribuable, pdfTimestamp, uploadType, null);
    }

    public UploadHistoryEntry(UUID guid, NoContribuable numeroContribuable, Instant pdfTimestamp, UploadConfiguration.UploadType uploadType, ExpertDisplayInfoDTO[] summaryExpertDisplayDTOs) {
        if (guid == null) {
            throw new NullPointerException("guid cannot be null");
        }
        if (numeroContribuable == null) {
            throw new NullPointerException("numero contribuable cannot be null");
        }
        if (pdfTimestamp == null) {
            throw new NullPointerException("pdf timestamp cannot be null");
        }
        if (uploadType == null) {
            throw new NullPointerException("upload type cannot be null");
        }
        this.guid = guid;
        this.numeroContribuable = numeroContribuable;
        this.pdfTimestamp = pdfTimestamp;
        this.uploadType = uploadType;
        this.summaryExpertDisplayDTOs = summaryExpertDisplayDTOs;
    }

    public UUID getGuid() {
        return this.guid;
    }

    public NoContribuable getNumeroContribuable() {
        return this.numeroContribuable;
    }

    public Instant getPdfTimestamp() {
        return this.pdfTimestamp;
    }

    public UploadConfiguration.UploadType getUploadType() {
        return this.uploadType;
    }

    public ExpertDisplayInfoDTO[] getSummaryExpertDisplayDTOs() {
        if (this.summaryExpertDisplayDTOs != null) {
            ExpertDisplayInfoDTO[] newArray = new ExpertDisplayInfoDTO[this.summaryExpertDisplayDTOs.length];
            System.arraycopy(this.summaryExpertDisplayDTOs, 0, newArray, 0, newArray.length);
            return newArray;
        }
        return null;
    }

    public String toString() {
        return UploadHistoryEntry.class.getName() + ": { guid:" + String.valueOf(this.guid) + ", numeroContribuable: " + String.valueOf(this.numeroContribuable) + ", summaryExpertDisplayDTO: " + String.valueOf(Arrays.asList(this.summaryExpertDisplayDTOs)) + " }";
    }
}

