/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.upload.cd;

import ch.dvbern.tax.common.presentation.cd.dialog.TaxmeProgressMonitorDialog;
import ch.dvbern.tax.ju.upload.UnknownTaxPayerException;
import ch.dvbern.tax.ju.upload.UploadDataSource;
import ch.dvbern.tax.ju.upload.UploadServiceClient;
import ch.dvbern.tax.ju.upload.UploadStatusDTO;
import ch.dvbern.tax.ju.upload.cd.AbstractUploadTask;
import ch.dvbern.tax.ju.upload.cd.FatalUploadException;
import ch.dvbern.tax.ju.upload.cd.MonitoredDataSource;
import ch.dvbern.tax.ju.upload.cd.UploadException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class UploadServiceClientGUIAdapter {
    private final Shell parentShell;
    private final UploadServiceClient client;

    public UploadServiceClientGUIAdapter(Shell parentShell, UploadServiceClient client) {
        if (client == null) {
            throw new NullPointerException("Upload service client cannot be null");
        }
        this.parentShell = parentShell;
        this.client = client;
    }

    private <T> T runUploadTask(AbstractUploadTask<T> task) throws UploadException, InterruptedException {
        assert (Display.getCurrent() != null);
        TaxmeProgressMonitorDialog dlg = new TaxmeProgressMonitorDialog(this.parentShell);
        try {
            dlg.run(true, true, task);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (ExceptionUtils.getRootCause((Throwable)cause) instanceof IOException) {
                throw new UploadException("IOException while performing task " + task.getClass().getName(), cause, "label.dialog.upload.ioexception", "title.dialog.upload.ioexception");
            }
            if (cause instanceof UnknownTaxPayerException) {
                throw new UploadException("Unknown tax payer number for task " + task.getClass().getName(), cause, "label.dialog.upload.unknownTaxPayer", "title.dialog.upload.unknownTaxPayer");
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new FatalUploadException("Unexpected failure for task " + task.getClass().getName(), cause);
        }
        return task.getResult();
    }

    public UUID upload(byte[] archive, String checksum) throws UploadException, InterruptedException {
        return this.uploadInternal(archive, checksum, null, false);
    }

    public UUID uploadWithCodeDI(byte[] archive, String checksum, String codeDI) throws UploadException, InterruptedException {
        return this.uploadInternal(archive, checksum, codeDI, true);
    }

    private UUID uploadInternal(final byte[] archive, final String checksum, final String codeDI, final boolean withCodeDI) throws UploadException, InterruptedException {
        assert (withCodeDI || codeDI == null);
        AbstractUploadTask<UUID> task = new AbstractUploadTask<UUID>("label.dialog.upload.uploadTask", -1, this.client){

            @Override
            protected Callable<UUID> getCallable(IProgressMonitor monitor) {
                return () -> {
                    MonitoredDataSource source = new MonitoredDataSource(monitor, archive, UploadServiceClientGUIAdapter.this.client.getNumeroContribuable(), UploadServiceClientGUIAdapter.this.client.getYear(), checksum);
                    if (withCodeDI) {
                        return UploadServiceClientGUIAdapter.this.client.uploadWithCodeDI((UploadDataSource)source, codeDI);
                    }
                    return UploadServiceClientGUIAdapter.this.client.upload((UploadDataSource)source);
                };
            }
        };
        return this.runUploadTask(task);
    }

    public List<UploadStatusDTO> getUploadStatus(final Collection<UUID> guids) throws UploadException, InterruptedException {
        AbstractUploadTask<List<UploadStatusDTO>> task = new AbstractUploadTask<List<UploadStatusDTO>>("label.dialog.upload.getStatusTask", this.client){

            @Override
            protected Callable<List<UploadStatusDTO>> getCallable(IProgressMonitor monitor) {
                return () -> UploadServiceClientGUIAdapter.this.client.getUploadStatus(guids);
            }
        };
        return this.runUploadTask(task);
    }

    public boolean isCodeDIValid(final String codeDI) throws UploadException, InterruptedException {
        AbstractUploadTask<Boolean> task = new AbstractUploadTask<Boolean>("label.dialog.upload.isCodeDIValid", this.client){

            @Override
            protected Callable<Boolean> getCallable(IProgressMonitor monitor) {
                return () -> UploadServiceClientGUIAdapter.this.client.isCodeDIValid(codeDI);
            }
        };
        return this.runUploadTask(task);
    }

    public boolean isValidationPerformed() throws UploadException, InterruptedException {
        AbstractUploadTask<Boolean> task = new AbstractUploadTask<Boolean>("label.dialog.upload.isValidationPerformedTask", this.client){

            @Override
            protected Callable<Boolean> getCallable(IProgressMonitor monitor) {
                return () -> ((UploadServiceClient)UploadServiceClientGUIAdapter.this.client).isValidationPerformed();
            }
        };
        return this.runUploadTask(task);
    }

    public void sendUploadLog(final byte[] logArchive, final String source, final UUID correlationId) throws UploadException, InterruptedException {
        AbstractUploadTask<Void> task = new AbstractUploadTask<Void>("label.dialog.upload.uploadLogReport", this.client){

            @Override
            protected Callable<Void> getCallable(IProgressMonitor monitor) {
                return () -> {
                    UploadServiceClientGUIAdapter.this.client.sendUploadLog(logArchive, source, correlationId);
                    return null;
                };
            }
        };
        this.runUploadTask(task);
    }
}

