/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.dvbtax.esteuerauszugextractor;

import ch.dvbern.dvbtax.esteuerauszugextractor.ExtractorUtil;
import ch.dvbern.dvbtax.esteuerauszugextractor.dto.Steuerauszug;
import ch.dvbern.dvbtax.esteuerauszugextractor.exception.ErrorCode;
import ch.dvbern.dvbtax.esteuerauszugextractor.exception.ExtractionException;
import ch.dvbern.dvbtax.esteuerauszugextractor.util.SteuerauszugMapper;
import ch.dvbern.lib.esteuerauszug.ERFException;
import ch.dvbern.lib.esteuerauszug.ERFUtils;
import ch.ewv.taxstatement.TaxStatement;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Objects;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Extractor {
    private static final JAXBContext JAXB_CONTEXT;
    private static final Logger LOG;
    private static final byte[] PDF_MAGIC_NUMBER;
    private static final String NS_XML_DSIG = "http://www.w3.org/2000/09/xmldsig#";
    private static final String LN_SIGNATURE = "Signature";

    public byte[] pdfToXml(byte[] pdf) throws ExtractionException {
        byte[] byArray;
        this.checkPdfFileType(pdf);
        ByteArrayInputStream bis = new ByteArrayInputStream(pdf);
        try {
            byte[] xml;
            byArray = xml = ERFUtils.extractEmbeddedXml((InputStream)bis);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ERFException | IOException e) {
                throw new ExtractionException(ErrorCode.INTERNAL_ERROR, e);
            }
        }
        bis.close();
        return byArray;
    }

    private void checkPdfFileType(byte[] content) throws ExtractionException {
        byte[] bytes = Arrays.copyOf(content, 1024);
        int index = ExtractorUtil.indexOf(bytes, PDF_MAGIC_NUMBER);
        if (index < 0) {
            throw new ExtractionException(ErrorCode.WRONG_FILE_TYPE);
        }
    }

    public @NonNull ch.ech.xmlns.ech_0196._2.TaxStatement xmlToTaxStatement(byte[] xml) throws ExtractionException {
        this.verifySignature(xml);
        ch.ech.xmlns.ech_0196._2.TaxStatement ts = this.parseTaxStatement(xml);
        return ts;
    }

    private void verifySignature(byte[] xml) {
        boolean signed = this.hasDigitalSignature(xml);
        if (!signed) {
            return;
        }
        boolean signatureValid = this.isSignatureValid(xml);
        if (!signatureValid) {
            throw new ExtractionException(ErrorCode.INVALID_DIGITAL_SIGNATURE);
        }
    }

    private boolean isSignatureValid(byte[] xml) {
        try {
            return TaxStatement.verifyXML((byte[])xml);
        }
        catch (XMLSignatureException e) {
            throw new ExtractionException(ErrorCode.INVALID_DIGITAL_SIGNATURE, (Throwable)e);
        }
        catch (MarshalException | ParserConfigurationException | SAXException e) {
            throw new ExtractionException(ErrorCode.INVALID_XML, (Throwable)e);
        }
        catch (Exception e) {
            throw new ExtractionException(ErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    private ch.ech.xmlns.ech_0196._2.TaxStatement parseTaxStatement(byte[] xml) {
        ch.ech.xmlns.ech_0196._2.TaxStatement taxStatement;
        ByteArrayInputStream is = new ByteArrayInputStream(xml);
        try {
            Unmarshaller um = JAXB_CONTEXT.createUnmarshaller();
            ch.ech.xmlns.ech_0196._2.TaxStatement ts = (ch.ech.xmlns.ech_0196._2.TaxStatement)um.unmarshal((InputStream)is);
            if (!TaxStatement.validateXML((byte[])xml)) {
                throw new ExtractionException(ErrorCode.INVALID_XML, null);
            }
            taxStatement = ts;
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JAXBException | XPathExpressionException e) {
                throw new ExtractionException(ErrorCode.INVALID_XML, e);
            }
            catch (IOException | ParseException | ParserConfigurationException | SAXException e) {
                throw new ExtractionException(ErrorCode.INTERNAL_ERROR, (Throwable)e);
            }
        }
        is.close();
        return taxStatement;
    }

    private boolean hasDigitalSignature(byte[] xml) {
        boolean bl;
        ByteArrayInputStream is = new ByteArrayInputStream(xml);
        try {
            boolean hasSignature;
            Document document = this.getSecureDocumentBuilderFactory().newDocumentBuilder().parse(is);
            NodeList signatureNodes = document.getElementsByTagNameNS(NS_XML_DSIG, LN_SIGNATURE);
            bl = hasSignature = signatureNodes != null && signatureNodes.item(0) != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ParserConfigurationException | SAXException e) {
                throw new ExtractionException(ErrorCode.INVALID_XML, (Throwable)e);
            }
            catch (Exception e) {
                throw new ExtractionException(ErrorCode.INTERNAL_ERROR, (Throwable)e);
            }
        }
        is.close();
        return bl;
    }

    private DocumentBuilderFactory getSecureDocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setXIncludeAware(false);
        factory.setExpandEntityReferences(false);
        return factory;
    }

    public @NonNull Steuerauszug getSteuerauszug(byte[] xml) throws ExtractionException {
        ch.ech.xmlns.ech_0196._2.TaxStatement taxStatement = this.xmlToTaxStatement(xml);
        return SteuerauszugMapper.createSteuerauszug(taxStatement);
    }

    private BufferedImage[] createBarcodeFromXml(byte[] xml) {
        BufferedImage[] barcodes = null;
        try {
            barcodes = TaxStatement.barCodeXML((byte[])xml);
        }
        catch (IOException | ParseException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            LOG.error("Failed to create barcodes from xml. Invalid xml", (Throwable)e);
        }
        return barcodes;
    }

    public byte[] xmlToPdf(byte[] xml) {
        BufferedImage[] images = this.createBarcodeFromXml(xml);
        return this.barcodesToPdf(images);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] barcodesToPdf(BufferedImage[] img) {
        int NBR_OF_BARCODEITEMS_PER_PAGE = 6;
        try (PDDocument document = new PDDocument();){
            byte[] byArray;
            try (ByteArrayOutputStream xml = new ByteArrayOutputStream();){
                for (int i = 0; i < Objects.requireNonNull(img).length; i += 6) {
                    PDPage page = new PDPage();
                    document.addPage(page);
                    TaxStatement.addBarCode((PDDocument)document, (PDPage)page, (BufferedImage[])Arrays.copyOfRange(img, i, i + 6 < img.length ? i + 6 : img.length), (int)1);
                }
                document.save((OutputStream)xml);
                byArray = xml.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            LOG.error("Failed to write barcodes into pdf: ", (Throwable)e);
            return new byte[0];
        }
    }

    private byte[] taxStatementToXML(ch.ech.xmlns.ech_0196._2.TaxStatement taxStatement) {
        byte[] byArray;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            Marshaller marshaller = JAXB_CONTEXT.createMarshaller();
            marshaller.marshal((Object)taxStatement, (OutputStream)os);
            byte[] xml = os.toByteArray();
            if (!TaxStatement.validateXML((byte[])xml)) {
                throw new ExtractionException(ErrorCode.INVALID_XML, null);
            }
            byArray = xml;
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JAXBException | XPathExpressionException e) {
                throw new ExtractionException(ErrorCode.INVALID_XML, e);
            }
            catch (IOException | ParseException | ParserConfigurationException | SAXException e) {
                throw new ExtractionException(ErrorCode.INTERNAL_ERROR, (Throwable)e);
            }
        }
        os.close();
        return byArray;
    }

    public byte[] taxStatementToPdf(ch.ech.xmlns.ech_0196._2.TaxStatement statement) {
        return this.xmlToPdf(this.taxStatementToXML(statement));
    }

    static {
        LOG = LoggerFactory.getLogger(Extractor.class);
        PDF_MAGIC_NUMBER = "%PDF".getBytes();
        try {
            JAXB_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{ch.ech.xmlns.ech_0196._2.TaxStatement.class});
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Could not init Extractor", e);
        }
    }
}

