/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.dvbtax.esteuerauszugextractor.dto;

import java.math.BigDecimal;
import java.util.Date;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LiabilityAccount {
    private @Nullable String iban;
    private @Nullable String bankAccountNumber;
    private @Nullable String bankAccountName;
    private @Nullable String bankAccountCountry;
    private @Nullable String bankAccountCurrency;
    private @Nullable Date openingDate;
    private @Nullable Date closingDate;
    private @Nullable BigDecimal totalTaxValue;
    private @Nullable BigDecimal totalGrossRevenueB;
    private @Nullable Date referenceDate;
    private @Nullable String name;
    private @Nullable String balanceCurrency;
    private @Nullable BigDecimal balance;
    private @Nullable BigDecimal exchangeRate;
    private @Nullable BigDecimal value;

    public @Nullable String getIban() {
        return this.iban;
    }

    public @Nullable String getBankAccountNumber() {
        return this.bankAccountNumber;
    }

    public @Nullable String getBankAccountName() {
        return this.bankAccountName;
    }

    public @Nullable String getBankAccountCountry() {
        return this.bankAccountCountry;
    }

    public @Nullable String getBankAccountCurrency() {
        return this.bankAccountCurrency;
    }

    public @Nullable Date getOpeningDate() {
        return this.openingDate;
    }

    public @Nullable Date getClosingDate() {
        return this.closingDate;
    }

    public @Nullable BigDecimal getTotalTaxValue() {
        return this.totalTaxValue;
    }

    public @Nullable BigDecimal getTotalGrossRevenueB() {
        return this.totalGrossRevenueB;
    }

    public @Nullable Date getReferenceDate() {
        return this.referenceDate;
    }

    public @Nullable String getName() {
        return this.name;
    }

    public @Nullable String getBalanceCurrency() {
        return this.balanceCurrency;
    }

    public @Nullable BigDecimal getBalance() {
        return this.balance;
    }

    public @Nullable BigDecimal getExchangeRate() {
        return this.exchangeRate;
    }

    public @Nullable BigDecimal getValue() {
        return this.value;
    }

    public static final class Builder {
        private @Nullable String iban;
        private @Nullable String bankAccountNumber;
        private @Nullable String bankAccountName;
        private @Nullable String bankAccountCountry;
        private @Nullable String bankAccountCurrency;
        private @Nullable Date openingDate;
        private @Nullable Date closingDate;
        private @Nullable BigDecimal totalTaxValue;
        private @Nullable BigDecimal totalGrossRevenueB;
        private @Nullable Date referenceDate;
        private @Nullable String name;
        private @Nullable String balanceCurrency;
        private @Nullable BigDecimal balance;
        private @Nullable BigDecimal exchangeRate;
        private @Nullable BigDecimal value;

        private Builder() {
        }

        public static Builder getInstance() {
            return new Builder();
        }

        public @NonNull Builder withIban(String val) {
            this.iban = val;
            return this;
        }

        public @NonNull Builder withBankAccountNumber(String val) {
            this.bankAccountNumber = val;
            return this;
        }

        public @NonNull Builder withBankAccountName(String val) {
            this.bankAccountName = val;
            return this;
        }

        public @NonNull Builder withBankAccountCountry(String val) {
            this.bankAccountCountry = val;
            return this;
        }

        public @NonNull Builder withBankAccountCurrency(String val) {
            this.bankAccountCurrency = val;
            return this;
        }

        public @NonNull Builder withOpeningDate(@Nullable Date val) {
            this.openingDate = val;
            return this;
        }

        public @NonNull Builder withClosingDate(@Nullable Date val) {
            this.closingDate = val;
            return this;
        }

        public @NonNull Builder withTotalTaxValue(BigDecimal val) {
            this.totalTaxValue = val;
            return this;
        }

        public @NonNull Builder withTotalGrossRevenueB(BigDecimal val) {
            this.totalGrossRevenueB = val;
            return this;
        }

        public @NonNull Builder withReferenceDate(@Nullable Date val) {
            this.referenceDate = val;
            return this;
        }

        public @NonNull Builder withName(@Nullable String val) {
            this.name = val;
            return this;
        }

        public @NonNull Builder withBalanceCurrency(@Nullable String val) {
            this.balanceCurrency = val;
            return this;
        }

        public @NonNull Builder withBalance(@Nullable BigDecimal val) {
            this.balance = val;
            return this;
        }

        public @NonNull Builder withExchangeRate(@Nullable BigDecimal val) {
            this.exchangeRate = val;
            return this;
        }

        public @NonNull Builder withValue(@Nullable BigDecimal val) {
            this.value = val;
            return this;
        }

        public @NonNull LiabilityAccount build() {
            LiabilityAccount liabilityAccount = new LiabilityAccount();
            liabilityAccount.bankAccountName = this.bankAccountName;
            liabilityAccount.closingDate = this.closingDate;
            liabilityAccount.name = this.name;
            liabilityAccount.balance = this.balance;
            liabilityAccount.iban = this.iban;
            liabilityAccount.referenceDate = this.referenceDate;
            liabilityAccount.bankAccountCurrency = this.bankAccountCurrency;
            liabilityAccount.totalGrossRevenueB = this.totalGrossRevenueB;
            liabilityAccount.bankAccountCountry = this.bankAccountCountry;
            liabilityAccount.exchangeRate = this.exchangeRate;
            liabilityAccount.value = this.value;
            liabilityAccount.bankAccountNumber = this.bankAccountNumber;
            liabilityAccount.openingDate = this.openingDate;
            liabilityAccount.balanceCurrency = this.balanceCurrency;
            liabilityAccount.totalTaxValue = this.totalTaxValue;
            return liabilityAccount;
        }
    }
}

