/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.dvbtax.esteuerauszugextractor.util;

import ch.dvbern.dvbtax.esteuerauszugextractor.dto.BankAccount;
import ch.dvbern.dvbtax.esteuerauszugextractor.dto.Client;
import ch.dvbern.dvbtax.esteuerauszugextractor.dto.Expense;
import ch.dvbern.dvbtax.esteuerauszugextractor.dto.Konten;
import ch.dvbern.dvbtax.esteuerauszugextractor.dto.LiabilityAccount;
import ch.dvbern.dvbtax.esteuerauszugextractor.dto.Payment;
import ch.dvbern.dvbtax.esteuerauszugextractor.dto.PurchaseDisposition;
import ch.dvbern.dvbtax.esteuerauszugextractor.dto.Schulden;
import ch.dvbern.dvbtax.esteuerauszugextractor.dto.Security;
import ch.dvbern.dvbtax.esteuerauszugextractor.dto.Spesen;
import ch.dvbern.dvbtax.esteuerauszugextractor.dto.Steuerauszug;
import ch.dvbern.dvbtax.esteuerauszugextractor.dto.Stock;
import ch.dvbern.dvbtax.esteuerauszugextractor.dto.TaxValue;
import ch.dvbern.dvbtax.esteuerauszugextractor.dto.Wertschriften;
import ch.ech.xmlns.ech_0196._2.InstitutionType;
import ch.ech.xmlns.ech_0196._2.SecurityDepotType;
import ch.ech.xmlns.ech_0196._2.SecurityPurchaseDispositionType;
import ch.ech.xmlns.ech_0196._2.SecuritySecurityType;
import ch.ech.xmlns.ech_0196._2.TaxStatement;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class SteuerauszugMapper {
    private SteuerauszugMapper() {
    }

    public static @NonNull Steuerauszug createSteuerauszug(TaxStatement taxStatement) {
        ArrayList<Client> clients = new ArrayList<Client>();
        taxStatement.getClient().forEach(clientType -> clients.add(Client.Builder.getInstance().withClientNumber(clientType.getClientNumber()).withFirstName(clientType.getFirstName()).withLastName(clientType.getLastName()).withSalutation(clientType.getSalutation()).withTin(clientType.getTin()).build()));
        Konten konten = null;
        if (taxStatement.getListOfBankAccounts() != null) {
            ArrayList<BankAccount> bankAccounts = new ArrayList<BankAccount>();
            taxStatement.getListOfBankAccounts().getBankAccount().forEach(bankAccountType -> bankAccounts.add(BankAccount.Builder.getInstance().withIban(bankAccountType.getIban()).withBankAccountNumber(bankAccountType.getBankAccountNumber()).withBankAccountName(bankAccountType.getBankAccountName()).withBankAccountCountry(bankAccountType.getBankAccountCountry()).withBankAccountCurrency(bankAccountType.getBankAccountCurrency()).withOpeningDate(SteuerauszugMapper.localDateToDate(bankAccountType.getOpeningDate())).withClosingDate(SteuerauszugMapper.localDateToDate(bankAccountType.getClosingDate())).withTotalTaxValue(bankAccountType.getTotalTaxValue()).withTotalGrossRevenueA(bankAccountType.getTotalGrossRevenueA()).withTotalGrossRevenueB(bankAccountType.getTotalGrossRevenueB()).withTotalWithHoldingTaxClaim(bankAccountType.getTotalWithHoldingTaxClaim()).withReferenceDate(SteuerauszugMapper.localDateToDate(bankAccountType.getTaxValue() != null ? bankAccountType.getTaxValue().getReferenceDate() : null)).withName(bankAccountType.getTaxValue() != null ? bankAccountType.getTaxValue().getName() : null).withBalanceCurrency(bankAccountType.getTaxValue() != null ? bankAccountType.getTaxValue().getBalanceCurrency() : null).withBalance(bankAccountType.getTaxValue() != null ? bankAccountType.getTaxValue().getBalance() : null).withExchangeRate(bankAccountType.getTaxValue() != null ? bankAccountType.getTaxValue().getExchangeRate() : null).withValue(bankAccountType.getTaxValue() != null ? bankAccountType.getTaxValue().getValue() : null).build()));
            konten = Konten.Builder.getInstance().withTotalTaxValue(taxStatement.getListOfBankAccounts().getTotalTaxValue()).withTotalGrossRevenueA(taxStatement.getListOfBankAccounts().getTotalGrossRevenueA()).withTotalGrossRevenueB(taxStatement.getListOfBankAccounts().getTotalGrossRevenueB()).withTotalWithHoldingTaxClaim(taxStatement.getListOfBankAccounts().getTotalWithHoldingTaxClaim()).withBankAccounts(bankAccounts).build();
        }
        Schulden schulden = null;
        if (taxStatement.getListOfLiabilities() != null) {
            ArrayList<LiabilityAccount> liabilityAccounts = new ArrayList<LiabilityAccount>();
            taxStatement.getListOfLiabilities().getLiabilityAccount().forEach(liabilityAccountType -> liabilityAccounts.add(LiabilityAccount.Builder.getInstance().withIban(liabilityAccountType.getIban()).withBankAccountNumber(liabilityAccountType.getBankAccountNumber()).withBankAccountName(liabilityAccountType.getBankAccountName()).withBankAccountCountry(liabilityAccountType.getBankAccountCountry()).withBankAccountCurrency(liabilityAccountType.getBankAccountCurrency()).withBalanceCurrency(liabilityAccountType.getBankAccountCurrency()).withOpeningDate(SteuerauszugMapper.localDateToDate(liabilityAccountType.getOpeningDate())).withClosingDate(SteuerauszugMapper.localDateToDate(liabilityAccountType.getClosingDate())).withTotalTaxValue(liabilityAccountType.getTotalTaxValue()).withTotalGrossRevenueB(liabilityAccountType.getTotalGrossRevenueB()).withReferenceDate(SteuerauszugMapper.localDateToDate(liabilityAccountType.getTaxValue() != null ? liabilityAccountType.getTaxValue().getReferenceDate() : null)).withName(liabilityAccountType.getTaxValue() != null ? liabilityAccountType.getTaxValue().getName() : null).withBalanceCurrency(liabilityAccountType.getTaxValue() != null ? liabilityAccountType.getTaxValue().getBalanceCurrency() : null).withBalance(liabilityAccountType.getTaxValue() != null ? liabilityAccountType.getTaxValue().getBalance() : null).withExchangeRate(liabilityAccountType.getTaxValue() != null ? liabilityAccountType.getTaxValue().getExchangeRate() : null).withValue(liabilityAccountType.getTaxValue() != null ? liabilityAccountType.getTaxValue().getValue() : null).build()));
            schulden = Schulden.Builder.getInstance().withTotalTaxValue(taxStatement.getListOfLiabilities().getTotalTaxValue()).withTotalGrossRevenueB(taxStatement.getListOfLiabilities().getTotalGrossRevenueB()).withLiabilityAccounts(liabilityAccounts).build();
        }
        Wertschriften wertschriften = null;
        if (taxStatement.getListOfSecurities() != null) {
            ArrayList<Security> securities = new ArrayList<Security>();
            taxStatement.getListOfSecurities().getDepot().forEach(securityDepotType -> securityDepotType.getSecurity().forEach(securitySecurityType -> securities.add(SteuerauszugMapper.buildSecurity(securityDepotType, securitySecurityType))));
            wertschriften = Wertschriften.Builder.getInstance().withTotalGrossRevenueA(taxStatement.getListOfSecurities().getTotalGrossRevenueA()).withTotalGrossRevenueB(taxStatement.getListOfSecurities().getTotalGrossRevenueB()).withTotalGrossRevenueIUP(taxStatement.getListOfSecurities().getTotalGrossRevenueIUP()).withTotalLumpSumTaxCredit(taxStatement.getListOfSecurities().getTotalLumpSumTaxCredit()).withTotalNonRecoverableTax(taxStatement.getListOfSecurities().getTotalNonRecoverableTax()).withSecurities(securities).withTotalTaxValue(taxStatement.getListOfSecurities().getTotalTaxValue()).withTotalAdditionalWithHoldingTaxUSA(taxStatement.getListOfSecurities().getTotalAdditionalWithHoldingTaxUSA()).withTotalGrossRevenueConversion(taxStatement.getListOfSecurities().getTotalGrossRevenueConversion()).withTotalGrossRevenueACanton(taxStatement.getListOfSecurities().getTotalGrossRevenueACanton()).withTotalGrossRevenueBCanton(taxStatement.getListOfSecurities().getTotalGrossRevenueBCanton()).withTotalWithHoldingTaxClaim(taxStatement.getListOfSecurities().getTotalWithHoldingTaxClaim()).build();
        }
        Spesen spesen = null;
        if (taxStatement.getListOfExpenses() != null) {
            ArrayList<Expense> expenses = new ArrayList<Expense>();
            taxStatement.getListOfExpenses().getExpense().forEach(expenseType -> expenses.add(Expense.Builder.getInstance().withReferenceDate(SteuerauszugMapper.localDateToDate(expenseType.getReferenceDate())).withName(expenseType.getName()).withIban(expenseType.getIban()).withBankAccountNumber(expenseType.getBankAccountNumber()).withDepotNumber(expenseType.getDepotNumber()).withAmountCurrency(expenseType.getAmountCurrency()).withAmount(expenseType.getAmount()).withExchangeRate(expenseType.getExchangeRate()).withExpenses(expenseType.getExpenses()).withExpensesDeductible(expenseType.getExpensesDeductible()).withExpensesDeductibleCanton(expenseType.getExpensesDeductibleCanton()).build()));
            spesen = Spesen.Builder.getInstance().withTotalExpenses(taxStatement.getListOfExpenses().getTotalExpenses()).withTotalExpensesDeductible(taxStatement.getListOfExpenses().getTotalExpensesDeductible()).withTotalExpensesDeductibleCanton(taxStatement.getListOfExpenses().getTotalExpensesDeductibleCanton()).withExpenses(expenses).build();
        }
        Steuerauszug auszug = Steuerauszug.Builder.getInstance().withId(taxStatement.getId()).withCreationDate(SteuerauszugMapper.localDateTimeToDate(taxStatement.getCreationDate())).withTaxPeriod(taxStatement.getTaxPeriod()).withPeriodFrom(SteuerauszugMapper.localDateToDate(taxStatement.getPeriodFrom())).withPeriodTo(SteuerauszugMapper.localDateToDate(taxStatement.getPeriodTo())).withCountry(taxStatement.getCountry()).withCanton(taxStatement.getCanton()).withTotalTaxValue(taxStatement.getTotalTaxValue()).withTotalGrossRevenueA(taxStatement.getTotalGrossRevenueA()).withTotalGrossRevenueACanton(taxStatement.getTotalGrossRevenueACanton()).withTotalGrossRevenueB(taxStatement.getTotalGrossRevenueB()).withTotalGrossRevenueBCanton(taxStatement.getTotalGrossRevenueBCanton()).withTotalWithHoldingTaxClaim(taxStatement.getTotalWithHoldingTaxClaim()).withLei(taxStatement.getInstitution().getLei()).withOrganisationName(taxStatement.getInstitution().getName()).withUid(SteuerauszugMapper.extractInstitutionUid(taxStatement.getInstitution())).withClients(clients).withKonten(konten).withSchulden(schulden).withWertschriften(wertschriften).withSpesen(spesen).build();
        return auszug;
    }

    private static @Nullable Integer extractInstitutionUid(@Nullable InstitutionType institution) {
        if (institution == null || institution.getUid() == null) {
            return null;
        }
        return institution.getUid().getUidOrganisationId();
    }

    private static @NonNull Security buildSecurity(SecurityDepotType securityDepotType, SecuritySecurityType securitySecurityType) {
        return Security.Builder.getInstance().withDepotNumber(securityDepotType.getDepotNumber()).withPositionId(securitySecurityType.getPositionId()).withValorNumber(securitySecurityType.getValorNumber()).withIsin(securitySecurityType.getIsin()).withCountry(securitySecurityType.getCountry()).withCity(securitySecurityType.getCity()).withCurrency(securitySecurityType.getCurrency()).withQuotationType(securitySecurityType.getQuotationType()).withNominalValue(securitySecurityType.getNominalValue()).withSecurityCategory(securitySecurityType.getSecurityCategory()).withSecurityType(securitySecurityType.getSecurityType()).withSecurityName(securitySecurityType.getSecurityName()).withIssueDate(SteuerauszugMapper.localDateToDate(securitySecurityType.getIssueDate())).withRedemptionDate(SteuerauszugMapper.localDateToDate(securitySecurityType.getRedemptionDate())).withRedemptionDateEarly(SteuerauszugMapper.localDateToDate(securitySecurityType.getRedemptionDateEarly())).withIssuePrice(securitySecurityType.getIssuePrice()).withRedemptionPrice(securitySecurityType.getRedemptionPrice()).withRedemptionPriceEarly(securitySecurityType.getRedemptionPriceEarly()).withInterestRate(securitySecurityType.getInterestRate()).withVariableInterest(securitySecurityType.isVariableInterest()).withIup(securitySecurityType.isIup()).withBfp(securitySecurityType.isBfp()).withTaxValue(SteuerauszugMapper.buildTaxValue(securitySecurityType)).withPayments(SteuerauszugMapper.buildPayments(securitySecurityType)).withStocks(SteuerauszugMapper.buildStocks(securitySecurityType)).build();
    }

    private static @Nullable List<Stock> buildStocks(SecuritySecurityType securitySecurityType) {
        if (securitySecurityType.getStock() == null) {
            return null;
        }
        ArrayList<Stock> stocks = new ArrayList<Stock>();
        securitySecurityType.getStock().forEach(stockType -> stocks.add(Stock.Builder.getInstance().withBalance(stockType.getBalance()).withName(stockType.getName()).withValue(stockType.getValue()).withExchangeRate(stockType.getExchangeRate()).withQuotationType(stockType.getQuotationType()).withReferenceDate(SteuerauszugMapper.localDateToDate(stockType.getReferenceDate())).withUnitPrice(stockType.getUnitPrice()).withBalanceCurrency(stockType.getBalanceCurrency()).withBlocked(stockType.isBlocked()).withBlockingTo(SteuerauszugMapper.localDateToDate(stockType.getBlockingTo())).withQuantity(stockType.getQuantity()).withReductionCost(stockType.getReductionCost()).withMutation(stockType.isMutation()).build()));
        return stocks;
    }

    private static @Nullable List<Payment> buildPayments(SecuritySecurityType securitySecurityType) {
        if (securitySecurityType.getPayment() == null) {
            return null;
        }
        ArrayList<Payment> payments = new ArrayList<Payment>();
        securitySecurityType.getPayment().forEach(paymentType -> payments.add(Payment.PaymentBuilder.aPayment().withPaymentDate(SteuerauszugMapper.localDateToDate(paymentType.getPaymentDate())).withExDate(SteuerauszugMapper.localDateToDate(paymentType.getExDate())).withName(paymentType.getName()).withQuotationType(paymentType.getQuotationType()).withQuantity(paymentType.getQuantity()).withAmountCurrency(paymentType.getAmountCurrency()).withAmountPerUnit(paymentType.getAmountPerUnit()).withAmount(paymentType.getAmount()).withExchangeRate(paymentType.getExchangeRate()).withGrossRevenueA(paymentType.getGrossRevenueA()).withGrossRevenueACanton(paymentType.getGrossRevenueACanton()).withGrossRevenueB(paymentType.getGrossRevenueB()).withGrossRevenueBCanton(paymentType.getGrossRevenueBCanton()).withWithHoldingTaxClaim(paymentType.getWithHoldingTaxClaim()).withLumpSumTaxCredit(paymentType.isLumpSumTaxCredit()).withLumpSumTaxCreditPercent(paymentType.getLumpSumTaxCreditPercent()).withLumpSumTaxCreditAmount(paymentType.getLumpSumTaxCreditAmount()).withNonRecoverableTaxPercent(paymentType.getNonRecoverableTaxPercent()).withNonRecoverableTaxAmount(paymentType.getNonRecoverableTaxAmount()).withAdditionalWithHoldingTaxUSA(paymentType.getAdditionalWithHoldingTaxUSA()).withIup(paymentType.isIup()).withConversion(paymentType.isConversion()).withGratis(paymentType.isGratis()).withSecuritiesLending(paymentType.isSecuritiesLending()).withLendingFee(paymentType.isLendingFee()).withRetrocession(paymentType.isRetrocession()).withUndefined(paymentType.isUndefined()).withKursliste(paymentType.isKursliste()).withSign(paymentType.getSign()).withDisposition(SteuerauszugMapper.buildPurchaseDisposition(paymentType.getDisposition())).withPurchases(SteuerauszugMapper.buildPurchases(paymentType.getPurchase())).build()));
        return payments;
    }

    private static @Nullable List<PurchaseDisposition> buildPurchases(@Nullable List<SecurityPurchaseDispositionType> purchTypeList) {
        if (purchTypeList == null) {
            return null;
        }
        ArrayList<PurchaseDisposition> purchases = new ArrayList<PurchaseDisposition>();
        purchTypeList.forEach(purchType -> purchases.add(SteuerauszugMapper.buildPurchaseDisposition(purchType)));
        return purchases;
    }

    private static @Nullable PurchaseDisposition buildPurchaseDisposition(@Nullable SecurityPurchaseDispositionType purchDispo) {
        if (purchDispo == null) {
            return null;
        }
        return PurchaseDisposition.PurchaseDispositionBuilder.aPurchaseDisposition().withReferenceDate(SteuerauszugMapper.localDateToDate(purchDispo.getReferenceDate())).withQuotationType(purchDispo.getQuotationType()).withQuantity(purchDispo.getQuantity()).withBondFloor(purchDispo.getBondFloor()).withBalanceCurrency(purchDispo.getBalanceCurrency()).withUnitPrice(purchDispo.getUnitPrice()).withBalance(purchDispo.getBalance()).withReductionCost(purchDispo.getReductionCost()).withExchangeRate(purchDispo.getExchangeRate()).withValue(purchDispo.getValue()).build();
    }

    private static @Nullable TaxValue buildTaxValue(SecuritySecurityType securitySecurityType) {
        return null != securitySecurityType.getTaxValue() ? TaxValue.Builder.getInstance().withReferenceDate(SteuerauszugMapper.localDateToDate(securitySecurityType.getTaxValue().getReferenceDate())).withName(securitySecurityType.getTaxValue().getName()).withQuotationType(securitySecurityType.getTaxValue().getQuotationType()).withQuantity(securitySecurityType.getTaxValue().getQuantity()).withBalanceCurrency(securitySecurityType.getTaxValue().getBalanceCurrency()).withUnitPrice(securitySecurityType.getTaxValue().getUnitPrice()).withBalance(securitySecurityType.getTaxValue().getBalance()).withExchangeRate(securitySecurityType.getTaxValue().getExchangeRate()).withValue(securitySecurityType.getTaxValue().getValue()).withBlocked(securitySecurityType.getTaxValue().isBlocked()).withBlockingTo(SteuerauszugMapper.localDateToDate(securitySecurityType.getTaxValue().getBlockingTo())).withUndefined(securitySecurityType.getTaxValue().isUndefined()).withKursliste(securitySecurityType.getTaxValue().isKursliste()).build() : null;
    }

    private static @Nullable Date localDateTimeToDate(LocalDateTime calendar) {
        if (null != calendar) {
            return Date.from(calendar.toInstant(ZoneOffset.UTC));
        }
        return null;
    }

    private static @Nullable Date localDateToDate(@Nullable LocalDate localDate) {
        if (null != localDate) {
            return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
        }
        return null;
    }
}

