/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.dvbtax.esteuerauszugextractor.util;

import jakarta.xml.bind.DatatypeConverter;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.GregorianCalendar;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class UnmarshallHelper {
    private static final ZoneId TMO_TIMEZONE = ZoneId.of("Europe/Zurich");

    private UnmarshallHelper() {
    }

    public static @Nullable LocalDate parseDate(@Nullable String date) {
        if (date == null) {
            return null;
        }
        return UnmarshallHelper.calendarToLocalDate(date);
    }

    public static @Nullable String printDate(@Nullable LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return localDate.toString();
    }

    public static @Nullable LocalDateTime parseDateTime(@Nullable String date) {
        if (date == null) {
            return null;
        }
        try {
            LocalDateTime parsed = LocalDateTime.parse(date);
            return parsed;
        }
        catch (DateTimeParseException e) {
            return UnmarshallHelper.calendarToLocalDateTime(date);
        }
    }

    public static @Nullable String printDateTime(@Nullable LocalDateTime localDate) {
        if (localDate == null) {
            return null;
        }
        return localDate.toString();
    }

    public static @Nullable Integer parseGYear(@Nullable String gYear) {
        if (gYear == null) {
            return null;
        }
        return DatatypeConverter.parseDate((String)gYear).get(1);
    }

    public static @Nullable String printGYear(@Nullable Integer gYear) {
        if (gYear == null) {
            return null;
        }
        return String.valueOf(gYear);
    }

    private static LocalDate calendarToLocalDate(@NonNull String date) {
        return UnmarshallHelper.calendarToLocalDateTime(date).toLocalDate();
    }

    static LocalDateTime calendarToLocalDateTime(@NonNull String date) {
        GregorianCalendar calendar = (GregorianCalendar)DatatypeConverter.parseDate((String)date);
        ZonedDateTime zoned = calendar.toZonedDateTime();
        LocalDateTime result = zoned.toLocalDateTime();
        return result;
    }

    public static Boolean parseFixedBoolean(@Nullable String bool) {
        if (bool == null) {
            return false;
        }
        return Boolean.valueOf(bool);
    }

    public static String printFixedBoolean(@Nullable Boolean bool) {
        if (bool == null) {
            return String.valueOf(Boolean.FALSE);
        }
        return String.valueOf(bool);
    }
}

