/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.upload.ws;

import ch.dvbern.tax.ju.transfer.dto.NoContribuable;
import ch.dvbern.tax.ju.upload.UploadServiceException;
import ch.dvbern.tax.ju.upload.UploadStatusDTO;
import ch.dvbern.tax.ju.upload.UploadValidationStatus;
import ch.dvbern.tax.ju.upload.ws.BadOrExpiredTokenException;
import ch.dvbern.tax.ju.upload.ws.UploadWebServiceClient;
import ch.dvbern.tax.ju.upload.ws.UploadWebServiceCommand;
import ch.dvbern.tax.ju.upload.ws.UploadWebServiceConfiguration;
import ch.jura.acju.acju_juratax_uploadservice.FaultBaseException;
import com.microsoft.schemas._2003._10.serialization.arrays.ArrayOfstring;
import https.www_jura_ch.acju.ctr.juratax.schjurataxupload._2017.GetUploadStatusResponse;
import https.www_jura_ch.acju.ctr.juratax.schjurataxupload._2017_09.UploadService;
import https.www_jura_ch.acju.ctr.juratax.schjurataxupload._2017_09.UploadServiceGetUploadStatusGetUploadStatusFaultFaultMessage;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.ws.Response;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.xml.datatype.XMLGregorianCalendar;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.datacontract.schemas._2004._07.acju_juratax.ArrayOfUploadStatus;
import org.datacontract.schemas._2004._07.acju_juratax.GetUploadStatusCode;
import org.datacontract.schemas._2004._07.acju_juratax.GetUploadStatusFault;
import org.datacontract.schemas._2004._07.acju_juratax.UploadStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GetUploadStatusCommand
extends UploadWebServiceCommand<List<UploadStatusDTO>> {
    private static final Logger LOG = LoggerFactory.getLogger(GetUploadStatusCommand.class);
    private final Collection<? extends UUID> guids;

    GetUploadStatusCommand(UploadWebServiceClient client, Collection<? extends UUID> guids) {
        super(client);
        assert (guids != null);
        this.guids = guids;
    }

    @Override
    protected List<UploadStatusDTO> runCommand(@NonNull UploadService service, String token, NoContribuable numeroContribuable, int year) throws UploadServiceException, IOException, InterruptedException {
        ArrayOfUploadStatus srvStatusesHolder;
        ArrayOfstring guidsArg = new ArrayOfstring();
        List<String> guidsArgBackend = guidsArg.getStrings();
        for (UUID uUID : this.guids) {
            if (uUID == null) {
                LOG.warn("Ignoring empty guid in request.");
                continue;
            }
            guidsArgBackend.add(uUID.toString());
        }
        if (guidsArgBackend.isEmpty()) {
            LOG.debug("Empty guids list. Returns empty status.");
            return Collections.emptyList();
        }
        try {
            Response<GetUploadStatusResponse> response = service.getUploadStatusAsync(guidsArg, token);
            GetUploadStatusResponse response2 = this.processAsyncCall(response);
            srvStatusesHolder = (ArrayOfUploadStatus)response2.getGetUploadStatusResult().getValue();
        }
        catch (FaultBaseException faultBaseException) {
            GetUploadStatusFault fault;
            StringBuilder sb = new StringBuilder("Get status failed");
            String errorCode = null;
            if (faultBaseException instanceof UploadServiceGetUploadStatusGetUploadStatusFaultFaultMessage && (fault = ((UploadServiceGetUploadStatusGetUploadStatusFaultFaultMessage)faultBaseException).getFaultInfo()) != null) {
                GetUploadStatusCode code = fault.getErrorCode();
                errorCode = code.value();
                JAXBElement<String> errorDescription = fault.getErrorDescription();
                if (errorDescription != null) {
                    sb.append(": ").append(errorCode).append(" - ").append((String)errorDescription.getValue());
                }
                if (code == GetUploadStatusCode.BAD_OR_EXPIRED_TOKEN) {
                    throw new BadOrExpiredTokenException(sb.toString(), faultBaseException);
                }
            }
            throw new UploadServiceException(sb.toString(), (Throwable)faultBaseException, errorCode);
        }
        List<UploadStatus> list = srvStatusesHolder.getUploadStatuses();
        ArrayList<UploadStatusDTO> statuses = new ArrayList<UploadStatusDTO>(list.size());
        block24: for (UploadStatus srvStatus : list) {
            Instant timestamp;
            UUID guid;
            NoContribuable receivedNumeroContribuable;
            if (srvStatus == null) {
                LOG.warn("Ignoring received null status");
                continue;
            }
            String receivedNumeroContribuableStr = (String)srvStatus.getContribuableNumber().getValue();
            if (receivedNumeroContribuableStr == null) {
                LOG.warn("Ignoring received status with null tax payer number.");
                continue;
            }
            try {
                receivedNumeroContribuable = NoContribuable.parse((String)receivedNumeroContribuableStr);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Ignoring received status with misformatted tax payer number: {}", (Object)receivedNumeroContribuableStr);
                continue;
            }
            if (!numeroContribuable.equals((Object)receivedNumeroContribuable)) {
                LOG.warn("Ignoring received status with wrong tax payer number, expected: '{}' got: '{}'", (Object)numeroContribuable, (Object)receivedNumeroContribuable);
                continue;
            }
            int receivedYear = srvStatus.getYear();
            if (year != receivedYear) {
                LOG.warn("Ignoring received status with wrong fiscal year, expected: '{}' got: '{}'", (Object)year, (Object)receivedYear);
                continue;
            }
            String uuidStr = (String)srvStatus.getUploadGuid().getValue();
            try {
                guid = UUID.fromString(uuidStr);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Failed to parse received GUID as an UUID: " + uuidStr, (Throwable)e);
                continue;
            }
            XMLGregorianCalendar calendar = srvStatus.getUploadDate();
            try {
                timestamp = UploadWebServiceConfiguration.parseInstant(calendar);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Failed to parse received date,: {} -- ignoring entry (guid: {})", (Object)calendar, (Object)guid);
                continue;
            }
            List<String> statusCodes = srvStatus.getUploadStatusCode();
            UploadValidationStatus validationStatus = null;
            String codeDI = null;
            Iterator<String> iterator = statusCodes.iterator();
            block25: while (iterator.hasNext()) {
                UploadValidationStatus newValidationStatus;
                String statusCode;
                switch (statusCode = iterator.next()) {
                    case "ConfirmedAnonymous": {
                        newValidationStatus = UploadValidationStatus.VALIDATED_WITH_CODE_DI;
                        codeDI = (String)srvStatus.getCodeDI().getValue();
                        break;
                    }
                    case "ConfirmedWithSuisseID": {
                        newValidationStatus = UploadValidationStatus.VALIDATED_WITH_SWISSID;
                        break;
                    }
                    case "NotConfirmed": {
                        newValidationStatus = UploadValidationStatus.NOT_VALIDATED;
                        break;
                    }
                    case "Unknown": {
                        LOG.info("Ignoring received entry with status UNKNOWN (guid: " + String.valueOf(guid) + ")");
                        continue block24;
                    }
                    case "ReceivedDocuments": 
                    case "Signed": {
                        continue block25;
                    }
                    default: {
                        LOG.warn("Ignoring received entry with unexpected status: {}", (Object)statusCode);
                        assert (false) : "Unexpected status received from server, check generated API.";
                        continue block24;
                    }
                }
                if (validationStatus != null) {
                    LOG.warn("Ignoring received entry with multiple validation status ({} & {})", (Object)validationStatus, (Object)newValidationStatus);
                    continue block24;
                }
                validationStatus = newValidationStatus;
            }
            if (validationStatus == null) {
                LOG.warn("Ignored entry with no validation status attached");
                continue;
            }
            statuses.add(new UploadStatusDTO(timestamp, guid, validationStatus, codeDI));
            LOG.info("[{}] [{}] Statuses received from server: {}", new Object[]{year, numeroContribuable, statuses});
        }
        return statuses;
    }
}

