/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.upload.ws;

import ch.dvbern.tax.ju.transfer.dto.NoContribuable;
import ch.dvbern.tax.ju.upload.AlreadySubmittedException;
import ch.dvbern.tax.ju.upload.UploadDataSource;
import ch.dvbern.tax.ju.upload.UploadServiceException;
import ch.dvbern.tax.ju.upload.ws.BadOrExpiredTokenException;
import ch.dvbern.tax.ju.upload.ws.UploadWebServiceClient;
import ch.dvbern.tax.ju.upload.ws.UploadWebServiceCommand;
import https.www_jura_ch.acju.ctr.juratax.schjurataxupload._2017.UploadPackage;
import https.www_jura_ch.acju.ctr.juratax.schjurataxupload._2017_09.UploadService;
import https.www_jura_ch.acju.ctr.juratax.schjurataxupload._2017_09.UploadServiceUploadTaxWithMTOMUploadTaxFaultFaultMessage;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.ws.Holder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ProxyInputStream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.datacontract.schemas._2004._07.acju_juratax.UploadTaxFault;
import org.datacontract.schemas._2004._07.acju_juratax.UploadTaxStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UploadCommand
extends UploadWebServiceCommand<UUID> {
    private static final Logger LOG = LoggerFactory.getLogger(UploadCommand.class);
    private final UploadDataSource archive;
    private final String codeDI;
    private volatile boolean interrupted;

    UploadCommand(UploadWebServiceClient client, UploadDataSource archive, String codeDI) {
        super(client);
        assert (archive != null);
        this.archive = archive;
        this.codeDI = codeDI;
    }

    @Override
    protected UUID runCommand(@NonNull UploadService service, String token, NoContribuable numeroContribuable, int year) throws UploadServiceException, IOException, InterruptedException {
        UUID guid;
        String uuidStr;
        try {
            this.checkForInterrupt();
            UploadPackage pkg = new UploadPackage();
            DataHandler dataHandler = new DataHandler((DataSource)this.archive){

                public InputStream getInputStream() throws IOException {
                    return new ProxyInputStream(super.getInputStream()){

                        protected void beforeRead(int n) throws IOException {
                            if (!UploadCommand.this.getClient().active) {
                                UploadCommand.this.interrupted = true;
                                throw new InterruptedIOException("Operation cancelled");
                            }
                        }
                    };
                }
            };
            pkg.setData(IOUtils.toByteArray((InputStream)dataHandler.getInputStream()));
            Holder uuidStrHolder = new Holder();
            service.uploadTaxWithMTOM(pkg, this.archive.getDigest(), this.codeDI, token, (Holder<String>)uuidStrHolder);
            uuidStr = (String)uuidStrHolder.value;
        }
        catch (UploadServiceUploadTaxWithMTOMUploadTaxFaultFaultMessage e) {
            StringBuilder sb = new StringBuilder("Upload failed");
            this.appendParams(numeroContribuable, year, sb);
            String errorCode = null;
            UploadTaxFault fault = e.getFaultInfo();
            if (fault == null) {
                sb.append(": no fault element found");
            } else {
                UploadTaxStatusCode code = fault.getErrorCode();
                errorCode = code.value();
                JAXBElement<String> description = fault.getErrorDescription();
                if (description != null) {
                    sb.append(": ").append(errorCode).append(" - ").append((String)description.getValue());
                }
                if (code == UploadTaxStatusCode.BAD_OR_EXPIRED_TOKEN) {
                    throw new BadOrExpiredTokenException(sb.toString(), e);
                }
                if (code == UploadTaxStatusCode.ALREADY_SUBMITTED) {
                    throw new AlreadySubmittedException(sb.toString(), (Throwable)e, UploadTaxStatusCode.ALREADY_SUBMITTED.value());
                }
            }
            throw new UploadServiceException(sb.toString(), (Throwable)e, errorCode);
        }
        catch (RuntimeException e) {
            Throwable root = ExceptionUtils.getRootCause((Throwable)e);
            if (root instanceof InterruptedIOException && this.interrupted) {
                LOG.debug("Transfer interrupted", (Throwable)e);
                StringBuilder sb = new StringBuilder("Interrupted during transfer");
                this.appendParams(numeroContribuable, year, sb);
                throw new InterruptedException(sb.toString());
            }
            StringBuilder sb = new StringBuilder("Web service upload call failed.");
            this.appendParams(numeroContribuable, year, sb);
            throw new UploadServiceException(sb.toString(), (Throwable)e);
        }
        try {
            guid = UUID.fromString(uuidStr);
        }
        catch (IllegalArgumentException e) {
            throw new UploadServiceException("Failed to parse received GUID as an UUID: " + uuidStr, (Throwable)e);
        }
        LOG.info("[{}] [{}] Upload successful, transaction ID: {}", new Object[]{year, numeroContribuable, guid});
        return guid;
    }

    private StringBuilder appendParams(NoContribuable numeroContribuable, int year, StringBuilder sb) {
        sb.append(" (").append("TaxPayerNumber: ").append(numeroContribuable).append(", ").append("year: ").append(year).append(")");
        return sb;
    }
}

