/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.upload.ws;

import ch.dvbern.tax.ju.transfer.dto.NoContribuable;
import ch.dvbern.tax.ju.upload.UnknownTaxPayerException;
import ch.dvbern.tax.ju.upload.UploadDataSource;
import ch.dvbern.tax.ju.upload.UploadServiceClient;
import ch.dvbern.tax.ju.upload.UploadServiceException;
import ch.dvbern.tax.ju.upload.UploadStatusDTO;
import ch.dvbern.tax.ju.upload.ws.BadOrExpiredTokenException;
import ch.dvbern.tax.ju.upload.ws.GetUploadStatusCommand;
import ch.dvbern.tax.ju.upload.ws.UploadCommand;
import ch.dvbern.tax.ju.upload.ws.UploadWebServiceCommand;
import ch.dvbern.tax.ju.upload.ws.UploadWebServiceConfiguration;
import ch.jura.acju.acju_juratax_uploadservice.FaultBaseException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import https.www_jura_ch.acju.ctr.juratax.schjurataxupload._2017.GetTokenResponse;
import https.www_jura_ch.acju.ctr.juratax.schjurataxupload._2017.ValidateWithCodeDIResponse;
import https.www_jura_ch.acju.ctr.juratax.schjurataxupload._2017.WriteToBinaryLogResponse;
import https.www_jura_ch.acju.ctr.juratax.schjurataxupload._2017_09.UploadService;
import https.www_jura_ch.acju.ctr.juratax.schjurataxupload._2017_09.UploadServiceGetTokenGetTokenFaultFaultMessage;
import https.www_jura_ch.acju.ctr.juratax.schjurataxupload._2017_09.UploadServiceHasAlreadySubmittedHasAlreadySubmittedFaultFaultMessage;
import https.www_jura_ch.acju.ctr.juratax.schjurataxupload._2017_09.UploadServiceValidateWithCodeDIValidateWithCodeDIFaultFaultMessage;
import https.www_jura_ch.acju.ctr.juratax.schjurataxupload._2017_09.UploadServiceWriteToBinaryLogWriteToBinaryLogFaultFaultMessage;
import https.www_jura_ch.acju.ctr.juratax.schjurataxupload._2017_09.UploadService_Service;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.ws.Response;
import jakarta.xml.ws.WebServiceFeature;
import jakarta.xml.ws.soap.AddressingFeature;
import jakarta.xml.ws.soap.MTOMFeature;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.datacontract.schemas._2004._07.acju_juratax.GetTokenFault;
import org.datacontract.schemas._2004._07.acju_juratax.WriteToBinaryLogFault;
import org.datacontract.schemas._2004._07.acju_juratax.WriteToBinaryLogStatusCode;
import org.datacontract.schemas._2004._07.acju_juratax_uploadservice.HasAlreadySubmittedFault;
import org.datacontract.schemas._2004._07.acju_juratax_uploadservice.HasAlreadySubmittedStatusCode;
import org.datacontract.schemas._2004._07.acju_juratax_uploadservice.ValidateWithCodeDIFault;
import org.datacontract.schemas._2004._07.acju_juratax_uploadservice.ValidateWithCodeDIStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadWebServiceClient
implements UploadServiceClient {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(UploadWebServiceClient.class);
    private final @NonNull URL wsdlLocation;
    private final @NonNull NoContribuable numeroContribuable;
    private final int year;
    private final MutableStateHolder mutex = new MutableStateHolder();
    volatile boolean active = true;

    UploadWebServiceClient(@NonNull NoContribuable numeroContribuable, int year, @NonNull URL wsdlLocation) {
        this.wsdlLocation = Objects.requireNonNull(wsdlLocation, "WSDL location cannot be null.");
        this.numeroContribuable = Objects.requireNonNull(numeroContribuable, "Tax payer number cannot be null.");
        if (numeroContribuable.isDummy()) {
            throw new IllegalArgumentException("Cannot upload with the dummy tax payer number.");
        }
        this.year = year;
    }

    public @NonNull UUID upload(@NonNull UploadDataSource archive) throws UploadServiceException, IOException, InterruptedException {
        if (archive == null) {
            throw new NullPointerException("archive cannot be null");
        }
        LOG.debug("[{}] [{}] Upload request received (SwissID) - archive: {}", new Object[]{this.year, this.numeroContribuable, archive.getClass()});
        return this.uploadInternal(archive, null);
    }

    public @NonNull UUID uploadWithCodeDI(@NonNull UploadDataSource archive, @NonNull String codeDI) throws UploadServiceException, IOException, InterruptedException {
        Objects.requireNonNull(archive, "Archive cannot be null.");
        Objects.requireNonNull(codeDI, "Code-DI cannot be null.");
        LOG.debug("[{}] [{}] Upload request received (CodeDI) - archive: {} codeDI: {}", new Object[]{this.year, this.numeroContribuable, archive.getClass(), codeDI});
        return this.uploadInternal(archive, codeDI);
    }

    private UUID uploadInternal(@NonNull UploadDataSource archive, @Nullable String codeDI) throws UploadServiceException, IOException, InterruptedException {
        assert (archive != null);
        this.checkActive();
        UploadCommand cmd = new UploadCommand(this, archive, codeDI);
        return this.executeCommand(cmd);
    }

    public @NonNull List<UploadStatusDTO> getUploadStatus(@NonNull Collection<UUID> guids) throws UploadServiceException, IOException, InterruptedException {
        Objects.requireNonNull(guids, "GUIDs collection cannot be null.");
        LOG.debug("[{}] [{}] Get upload status request received - guids: {}", new Object[]{this.year, this.numeroContribuable, guids});
        this.checkActive();
        GetUploadStatusCommand cmd = new GetUploadStatusCommand(this, guids);
        return this.executeCommand(cmd);
    }

    public boolean isCodeDIValid(final @NonNull String codeDI) throws UploadServiceException, IOException, InterruptedException {
        LOG.debug("[{}] [{}] Is CodeDI valid request received - codeDI: {}", new Object[]{this.year, this.numeroContribuable, codeDI});
        this.checkActive();
        UploadWebServiceCommand<Boolean> cmd = new UploadWebServiceCommand<Boolean>(this, this){

            @Override
            public @NonNull Boolean runCommand(@NonNull UploadService service, @NonNull String token, @NonNull NoContribuable numeroContribuable, int year) throws UploadServiceException, IOException, InterruptedException, BadOrExpiredTokenException {
                Boolean codeDIValid;
                try {
                    Response<ValidateWithCodeDIResponse> call = service.validateWithCodeDIAsync(token, numeroContribuable.toExternalForm(), year, codeDI);
                    ValidateWithCodeDIResponse response = this.processAsyncCall(call);
                    codeDIValid = response.isValidateWithCodeDIResult();
                }
                catch (FaultBaseException e) {
                    StringBuilder sb = new StringBuilder("Has already submitted failed");
                    String errorCode = null;
                    if (e instanceof UploadServiceValidateWithCodeDIValidateWithCodeDIFaultFaultMessage) {
                        UploadServiceValidateWithCodeDIValidateWithCodeDIFaultFaultMessage msg = (UploadServiceValidateWithCodeDIValidateWithCodeDIFaultFaultMessage)e;
                        ValidateWithCodeDIFault fault = msg.getFaultInfo();
                        ValidateWithCodeDIStatusCode code = fault.getErrorCode();
                        errorCode = code.value();
                        JAXBElement<String> errorDescription = fault.getErrorDescription();
                        if (errorDescription != null) {
                            sb.append(": ").append(code.value()).append(" - ").append((String)errorDescription.getValue());
                        }
                        if (code == ValidateWithCodeDIStatusCode.BAD_OR_EXPIRED_TOKEN) {
                            throw new BadOrExpiredTokenException(sb.toString(), e);
                        }
                    }
                    throw new UploadServiceException(sb.toString(), (Throwable)e, errorCode);
                }
                if (codeDIValid == null) {
                    throw new UploadServiceException("Is CodeDI valid returned a null value");
                }
                LOG.info("[{}] [{}] Is CodeDI valid: {}", new Object[]{year, numeroContribuable, codeDIValid});
                return codeDIValid;
            }
        };
        return this.executeCommand(cmd);
    }

    public boolean isValidationPerformed() throws UploadServiceException, IOException, InterruptedException {
        LOG.debug("[{}] [{}] Is validation performed request received", (Object)this.year, (Object)this.numeroContribuable);
        this.checkActive();
        UploadWebServiceCommand<Boolean> cmd = new UploadWebServiceCommand<Boolean>(this, this){

            @Override
            protected @NonNull Boolean runCommand(@NonNull UploadService service, @NonNull String token, @NonNull NoContribuable numeroContribuable, int year) throws UploadServiceException, BadOrExpiredTokenException, UnknownTaxPayerException {
                Boolean validationPerformed;
                try {
                    validationPerformed = service.hasAlreadySubmitted(token, numeroContribuable.toExternalForm(), year);
                }
                catch (FaultBaseException e) {
                    StringBuilder sb = new StringBuilder("Has already submitted failed");
                    String errorCode = null;
                    HasAlreadySubmittedFault fault = ((UploadServiceHasAlreadySubmittedHasAlreadySubmittedFaultFaultMessage)e).getFaultInfo();
                    HasAlreadySubmittedStatusCode code = fault.getErrorCode();
                    errorCode = code.value();
                    JAXBElement<String> errorDescription = fault.getErrorDescription();
                    if (errorDescription != null) {
                        sb.append(": ").append(code.value()).append(" - ").append((String)errorDescription.getValue());
                    }
                    if (code == HasAlreadySubmittedStatusCode.BAD_OR_EXPIRED_TOKEN) {
                        throw new BadOrExpiredTokenException(sb.toString(), e);
                    }
                    if (code == HasAlreadySubmittedStatusCode.PARAMETER_ERROR) {
                        throw new UnknownTaxPayerException(sb.toString(), (Throwable)e, errorCode);
                    }
                    throw new UploadServiceException(sb.toString(), (Throwable)e, errorCode);
                }
                if (validationPerformed == null) {
                    throw new UploadServiceException("Has already submitted returned a null value");
                }
                LOG.info("[{}] [{}] Is validation already performed: {}", new Object[]{year, numeroContribuable, validationPerformed});
                return validationPerformed;
            }
        };
        return this.executeCommand(cmd);
    }

    public void sendUploadLog(final @NonNull byte[] logArchive, final @NonNull String source, final @NonNull UUID correlationId) throws UploadServiceException, IOException, InterruptedException {
        Objects.requireNonNull(logArchive, "Log-archive stream cannot be null.");
        Objects.requireNonNull(source, "Error source cannot be null.");
        Objects.requireNonNull(correlationId, "Correlation ID cannot be null.");
        this.checkActive();
        LOG.debug("[{}] [{}] Send upload log request received - logArchive size: {} bytes, correlationId: {}", new Object[]{this.year, this.numeroContribuable, logArchive.length, correlationId});
        this.executeCommand(new UploadWebServiceCommand<Void>(this, this){

            @Override
            Void runCommand(@NonNull UploadService service, @NonNull String token, @NonNull NoContribuable numeroContribuable, int year) throws UploadServiceException, IOException, InterruptedException, BadOrExpiredTokenException {
                try {
                    Response<WriteToBinaryLogResponse> call = service.writeToBinaryLogAsync(token, source, correlationId.toString(), logArchive);
                    WriteToBinaryLogResponse response = this.processAsyncCall(call);
                    boolean success = response.isWriteToBinaryLogResult();
                    if (!success) {
                        throw new UploadServiceException("Server notified failure ('false' return value))");
                    }
                }
                catch (FaultBaseException e) {
                    StringBuilder sb = new StringBuilder("Sending upload log failed");
                    String errorCode = null;
                    if (e instanceof UploadServiceWriteToBinaryLogWriteToBinaryLogFaultFaultMessage) {
                        UploadServiceWriteToBinaryLogWriteToBinaryLogFaultFaultMessage msg = (UploadServiceWriteToBinaryLogWriteToBinaryLogFaultFaultMessage)e;
                        WriteToBinaryLogFault fault = msg.getFaultInfo();
                        WriteToBinaryLogStatusCode code = fault.getErrorCode();
                        errorCode = code.value();
                        JAXBElement<String> errorDescription = fault.getErrorDescription();
                        if (errorDescription != null) {
                            sb.append(": ").append(errorCode).append(" - ").append((String)errorDescription.getValue());
                        }
                        if (code == WriteToBinaryLogStatusCode.BAD_OR_EXPIRED_TOKEN) {
                            throw new BadOrExpiredTokenException(sb.toString(), e);
                        }
                    }
                    throw new UploadServiceException(sb.toString(), (Throwable)e, errorCode);
                }
                return null;
            }
        });
    }

    private String performLogin(UploadService service, NoContribuable numeroContribuable) throws UploadServiceException, IOException, InterruptedException {
        var cmd = new UploadWebServiceCommand<String>(this, this){

            @Override
            String runCommand(@NonNull UploadService service, String token, NoContribuable numeroContribuable, int year) throws UploadServiceException, IOException, InterruptedException {
                try {
                    Response<GetTokenResponse> call = service.getTokenAsync("dvbern", "t~<$,[7:C8>%-;!@7=60931|1830},", numeroContribuable.toExternalForm());
                    GetTokenResponse response = this.processAsyncCall(call);
                    token = (String)response.getGetTokenResult().getValue();
                }
                catch (FaultBaseException e) {
                    UploadServiceGetTokenGetTokenFaultFaultMessage msg;
                    GetTokenFault fault;
                    StringBuilder sb = new StringBuilder("Login failed");
                    String errorCode = null;
                    if (e instanceof UploadServiceGetTokenGetTokenFaultFaultMessage && (fault = (msg = (UploadServiceGetTokenGetTokenFaultFaultMessage)e).getFaultInfo()) != null) {
                        errorCode = fault.getErrorCode().value();
                        JAXBElement<String> errorDescription = fault.getErrorDescription();
                        if (errorDescription != null) {
                            sb.append(": ").append(fault.getErrorCode().value()).append(" - ").append((String)errorDescription.getValue());
                        }
                    }
                    throw new UploadServiceException(sb.toString(), (Throwable)e, errorCode);
                }
                LOG.info("[{}] [{}] Login successful with token: {}", new Object[]{year, numeroContribuable, token});
                return token;
            }
        };
        return cmd.runCommand(service, null, numeroContribuable, this.year);
    }

    public static @NonNull UploadService getBinding(@NonNull URL wsdlLocation) {
        Objects.requireNonNull(wsdlLocation, "WSDL location cannot be null.");
        UploadService_Service uploadServiceImpl = new UploadService_Service(wsdlLocation);
        UploadService wsInterface = uploadServiceImpl.getWSHttpBindingUploadService(new WebServiceFeature[]{new AddressingFeature(true, false), new MTOMFeature(true, 0)});
        return wsInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T executeCommand(UploadWebServiceCommand<T> cmd) throws InterruptedException, IOException, UploadServiceException {
        T result = null;
        MutableStateHolder mutableStateHolder = this.mutex;
        synchronized (mutableStateHolder) {
            UploadService service;
            if (this.mutex.service != null) {
                service = this.mutex.service;
            } else {
                this.mutex.service = service = UploadWebServiceClient.getBinding(this.wsdlLocation);
            }
            String token = this.mutex.token;
            boolean loginRenewed = false;
            boolean done = false;
            do {
                if (token == null) {
                    token = this.mutex.token = this.performLogin(service, this.numeroContribuable);
                    loginRenewed = true;
                }
                try {
                    result = cmd.runCommand(service, token, this.numeroContribuable, this.year);
                    done = true;
                }
                catch (BadOrExpiredTokenException e) {
                    if (loginRenewed) {
                        LOG.error("Token expired after login renewal, abort.", (Throwable)((Object)e));
                        throw e;
                    }
                    LOG.debug("Token expired, redo login.");
                    token = null;
                }
            } while (!done);
        }
        return result;
    }

    public @NonNull URL getValidationURL(@NonNull NoContribuable numberoContribuable, @NonNull UUID guid, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull UploadConfiguration.UploadType uploadType) {
        return UploadWebServiceConfiguration.getValidationURL(numberoContribuable, guid);
    }

    public String toString() {
        return String.format("Upload web-service client [%d] [%s] bound to wsdl [%s]", this.year, this.numeroContribuable, this.wsdlLocation);
    }

    public @NonNull String getDescription() {
        return "Upload web-service client [" + this.year + "] [" + String.valueOf(this.numeroContribuable) + "] [active: " + this.active + "] bound to wsdl [" + String.valueOf(this.wsdlLocation) + "]";
    }

    public void shutdown() {
        this.active = false;
        LOG.info("[{}] [{}] Client shutdown requested", (Object)this.year, (Object)this.numeroContribuable);
    }

    private void checkActive() {
        if (!this.active) {
            throw new IllegalStateException("This client has already been shut down");
        }
    }

    public @NonNull NoContribuable getNumeroContribuable() {
        return this.numeroContribuable;
    }

    public int getYear() {
        return this.year;
    }

    private static class MutableStateHolder {
        String token;
        UploadService service;

        private MutableStateHolder() {
        }
    }
}

