/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.upload.ws;

import ch.dvbern.tax.ju.Environment;
import ch.dvbern.tax.ju.transfer.dto.NoContribuable;
import ch.dvbern.tax.ju.upload.UploadServiceClientFactory;
import ch.dvbern.tax.ju.upload.ws.UploadWebServiceClient;
import ch.dvbern.tax.ju.upload.ws.UploadWebServiceConfiguration;
import https.www_jura_ch.acju.ctr.juratax.schjurataxupload._2017_09.UploadService;
import java.net.URL;
import org.checkerframework.checker.nullness.qual.NonNull;

public class UploadWebServiceClientFactory
extends UploadServiceClientFactory {
    protected UploadWebServiceClient login(Environment environment, NoContribuable numeroContribuable, int year) {
        if (environment == null) {
            throw new NullPointerException("Environment cannot be null.");
        }
        if (numeroContribuable == null) {
            throw new NullPointerException("Tax payer number cannot be null.");
        }
        URL wsdlLocation = UploadWebServiceClientFactory.getWSDLLocation(environment);
        return wsdlLocation != null ? new UploadWebServiceClient(numeroContribuable, year, wsdlLocation) : null;
    }

    public static @NonNull UploadService getCurrentEnvironmentBinding() {
        Environment environment = Environment.getCurrentEnvironment();
        URL wsdlLocation = UploadWebServiceClientFactory.getWSDLLocation(environment);
        if (wsdlLocation == null) {
            throw new IllegalArgumentException("No upload web-service available for environment: " + String.valueOf(environment));
        }
        return UploadWebServiceClient.getBinding(wsdlLocation);
    }

    private static URL getWSDLLocation(Environment environment) {
        assert (environment != null);
        switch (environment) {
            case PRODUCTION: {
                return UploadWebServiceConfiguration.WSDL_LOCATION_PRODUCTION;
            }
            case VALIDATION: {
                return UploadWebServiceConfiguration.WSDL_LOCATION_VALIDATION;
            }
            case LOCAL: {
                return UploadWebServiceConfiguration.WSDL_LOCATION_LOCAL;
            }
        }
        return null;
    }
}

