/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.upload.ws;

import ch.dvbern.tax.ju.transfer.dto.NoContribuable;
import ch.dvbern.tax.ju.upload.UploadServiceException;
import ch.dvbern.tax.ju.upload.ws.UploadWebServiceClient;
import ch.jura.acju.acju_juratax_uploadservice.FaultBaseException;
import https.www_jura_ch.acju.ctr.juratax.schjurataxupload._2017_09.UploadService;
import jakarta.xml.ws.Response;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class UploadWebServiceCommand<T> {
    private static final Logger LOG = LoggerFactory.getLogger(UploadWebServiceCommand.class);
    private static final long STATUS_POLL_TIMEOUT = 1000L;
    private final UploadWebServiceClient client;

    UploadWebServiceCommand(UploadWebServiceClient client) {
        assert (client != null);
        this.client = client;
    }

    abstract T runCommand(@NonNull UploadService var1, @Nullable String var2, NoContribuable var3, int var4) throws UploadServiceException, IOException, InterruptedException;

    <F> F processAsyncCall(Response<F> call) throws InterruptedException, FaultBaseException, IOException {
        assert (call != null);
        this.checkForInterrupt();
        try {
            do {
                try {
                    call.get(1000L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException ignored) {
                    if (this.getClient().active) continue;
                    call.cancel(true);
                    throw new InterruptedException("Operation has been interrupted");
                }
            } while (!call.isDone());
            return (F)call.get();
        }
        catch (CancellationException ignored) {
            LOG.warn("Operation externally cancelled");
            throw new InterruptedException("Operation externally cancelled");
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof FaultBaseException) {
                throw (FaultBaseException)cause;
            }
            if (cause instanceof InterruptedException) {
                throw (InterruptedException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new IOException(e);
        }
    }

    void checkForInterrupt() throws InterruptedException {
        if (!this.getClient().active) {
            throw new InterruptedException("Operation has been interrupted");
        }
    }

    protected UploadWebServiceClient getClient() {
        return this.client;
    }
}

