/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.upload.ws;

import ch.dvbern.tax.ju.Environment;
import ch.dvbern.tax.ju.JuUtil;
import ch.dvbern.tax.ju.transfer.dto.NoContribuable;
import ch.dvbern.tax.ju.upload.UploadConfiguration;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.Objects;
import java.util.TimeZone;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.codec.binary.Base64;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class UploadWebServiceConfiguration {
    public static final String UPLOAD_SERVICE_USERNAME = "dvbern";
    public static final String UPLOAD_SERVICE_PASSWORD = "t~<$,[7:C8>%-;!@7=60931|1830},";
    public static final String CIPHER_KEY_ALG = "AES";
    public static final String CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
    public static final String CIPHER_KEY_SECRET = "Ku'2>R%f/^|9i10G";
    public static final String CIPHER_KEY_IV = "B0U:b1+2)7jT[9$>";
    public static final int CIPHER_KEY_SIZE = 16;
    public static final Charset CIPHER_PARAM_CHARSET = StandardCharsets.UTF_8;
    public static final URL WSDL_LOCATION_PRODUCTION;
    public static final URL WSDL_LOCATION_VALIDATION;
    public static final URL WSDL_LOCATION_LOCAL;
    public static final URL DMS_WSDL_LOCATION_PRODUCTION;
    public static final URL DMS_WSDL_LOCATION_VALIDATION;
    public static final URL DMS_WSDL_LOCATION_LOCAL;
    public static final String GUID_VALIDATION_PARAM = "Guid";
    public static final String TAX_PAYER_VALIDATION_PARAM = "NCC";
    private static final ThreadLocal<MessageFormat> CONFIRMUPLOAD_URL_FORMAT;
    private static final ThreadLocal<MessageFormat> CONFIRMUPLOAD_URL_TEST_FORMAT;
    private static final ThreadLocal<MessageFormat> CONFIRMUPLOAD_URL_LOCAL_FORMAT;

    private UploadWebServiceConfiguration() {
    }

    public static URL getValidationURL(NoContribuable numeroContribuable, UUID guid) {
        String marshalledParameter;
        if (numeroContribuable == null) {
            throw new NullPointerException("numero contribuable cannot be null");
        }
        if (guid == null) {
            throw new NullPointerException("guid cannot be null");
        }
        MessageFormat urlFmt = null;
        switch (Environment.getCurrentEnvironment()) {
            case PRODUCTION: {
                urlFmt = CONFIRMUPLOAD_URL_FORMAT.get();
                break;
            }
            case VALIDATION: {
                urlFmt = CONFIRMUPLOAD_URL_TEST_FORMAT.get();
                break;
            }
            case MOCKED: 
            case LOCAL: {
                urlFmt = CONFIRMUPLOAD_URL_LOCAL_FORMAT.get();
            }
        }
        Objects.requireNonNull(urlFmt, "ConfirmUpload service config missing: " + String.valueOf(Environment.getCurrentEnvironment()));
        StringBuilder parameterString = new StringBuilder();
        parameterString.append(GUID_VALIDATION_PARAM).append("=").append(guid);
        parameterString.append("&").append(TAX_PAYER_VALIDATION_PARAM).append("=").append(numeroContribuable);
        try {
            marshalledParameter = URLEncoder.encode(UploadWebServiceConfiguration.marshallParameter(parameterString.toString()), "UTF-8");
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Failed to marshall URL: encryption failure", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Parameter encoding not supported by current VM", e);
        }
        String urlString = urlFmt.format(new Object[]{marshalledParameter});
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Cannot build URL '" + urlString + "' with the specified arguments", e);
        }
    }

    public static String marshallParameter(String parameter) throws GeneralSecurityException {
        if (parameter == null) {
            throw new NullPointerException("parameter cannot be null");
        }
        byte[] rawParameter = parameter.getBytes(CIPHER_PARAM_CHARSET);
        byte[] cipheredParameter = UploadWebServiceConfiguration.getEncryptionCipher().doFinal(rawParameter);
        return Base64.encodeBase64String((byte[])cipheredParameter);
    }

    public static String unMarshallParameters(String parameter) throws GeneralSecurityException {
        if (parameter == null) {
            throw new NullPointerException("parameter cannot be null");
        }
        byte[] cipheredParameter = Base64.decodeBase64((String)parameter);
        byte[] rawParameter = UploadWebServiceConfiguration.getDecryptionCipher().doFinal(cipheredParameter);
        return new String(rawParameter, CIPHER_PARAM_CHARSET);
    }

    public static Cipher getEncryptionCipher() throws GeneralSecurityException {
        return UploadWebServiceConfiguration.getCipher(1);
    }

    public static Cipher getDecryptionCipher() throws GeneralSecurityException {
        return UploadWebServiceConfiguration.getCipher(2);
    }

    private static Cipher getCipher(int mode) throws GeneralSecurityException {
        byte[] secretKeyRaw = CIPHER_KEY_SECRET.getBytes(CIPHER_PARAM_CHARSET);
        byte[] iv = CIPHER_KEY_IV.getBytes(CIPHER_PARAM_CHARSET);
        assert (secretKeyRaw.length == 16);
        SecretKeySpec secretKey = new SecretKeySpec(secretKeyRaw, CIPHER_KEY_ALG);
        IvParameterSpec params = new IvParameterSpec(iv);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(mode, (Key)secretKey, params);
        return cipher;
    }

    public static @NonNull Instant parseInstant(XMLGregorianCalendar calendar) {
        if (calendar == null) {
            throw new NullPointerException("calendar cannot be null");
        }
        return calendar.toGregorianCalendar(TimeZone.getTimeZone(UploadConfiguration.TIMEZONE), JuUtil.APPLICATION_LOCALE, null).toInstant();
    }

    static {
        try {
            WSDL_LOCATION_PRODUCTION = new URL("https://jurataxupload.jura.ch/Uploadservice.svc?wsdl");
            WSDL_LOCATION_VALIDATION = new URL("https://jurataxupload-t.jura.ch/Uploadservice.svc?wsdl");
            WSDL_LOCATION_LOCAL = new URL("https://localhost:8443/juratax-upload-ws-mock/UploadService?wsdl");
        }
        catch (MalformedURLException e) {
            throw new AssertionError("Cannot parse wsdl location", e);
        }
        try {
            DMS_WSDL_LOCATION_PRODUCTION = new URL("https://jurataxservices.jura.ch/dispatcher/Dispatcher.svc?wsdl");
            DMS_WSDL_LOCATION_VALIDATION = new URL("https://jurataxservices-t.jura.ch/dispatcher/Dispatcher.svc?wsdl");
            DMS_WSDL_LOCATION_LOCAL = new URL("https://localhost:8443/juratax-upload-ws-mock/Dispatcher?wsdl");
        }
        catch (MalformedURLException e) {
            throw new AssertionError("Cannot parse wsdl location", e);
        }
        CONFIRMUPLOAD_URL_FORMAT = ThreadLocal.withInitial(() -> new MessageFormat("https://jurataxupload.jura.ch/ConfirmUpload.aspx?p={0}"));
        CONFIRMUPLOAD_URL_TEST_FORMAT = ThreadLocal.withInitial(() -> new MessageFormat("https://jurataxupload-t.jura.ch/ConfirmUpload.aspx?p={0}"));
        CONFIRMUPLOAD_URL_LOCAL_FORMAT = ThreadLocal.withInitial(() -> new MessageFormat("https://localhost:8443/juratax-upload-ws-mock/validate.jsp?p={0}"));
    }
}

