/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import java.nio.charset.StandardCharsets;
import uk.org.okapibarcode.backend.HumanReadableLocation;
import uk.org.okapibarcode.backend.OkapiInputException;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.graphics.Rectangle;

public class CodablockF
extends Symbol {
    private static final String[] C_128_TABLE = new String[]{"212222", "222122", "222221", "121223", "121322", "131222", "122213", "122312", "132212", "221213", "221312", "231212", "112232", "122132", "122231", "113222", "123122", "123221", "223211", "221132", "221231", "213212", "223112", "312131", "311222", "321122", "321221", "312212", "322112", "322211", "212123", "212321", "232121", "111323", "131123", "131321", "112313", "132113", "132311", "211313", "231113", "231311", "112133", "112331", "132131", "113123", "113321", "133121", "313121", "211331", "231131", "213113", "213311", "213131", "311123", "311321", "331121", "312113", "312311", "332111", "314111", "221411", "431111", "111224", "111422", "121124", "121421", "141122", "141221", "112214", "112412", "122114", "122411", "142112", "142211", "241211", "221114", "413111", "241112", "134111", "111242", "121142", "121241", "114212", "124112", "124211", "411212", "421112", "421211", "212141", "214121", "412121", "111143", "111341", "131141", "114113", "114311", "411113", "411311", "113141", "114131", "311141", "411131", "211412", "211214", "211232", "2331112"};
    private int[][] blockmatrix = new int[44][62];
    private int columns;
    private int rows;
    private CfMode finalMode;
    private CfMode[] subsets = new CfMode[44];

    public CodablockF() {
        this.humanReadableLocation = HumanReadableLocation.NONE;
        this.default_height = 15;
    }

    @Override
    public boolean supportsGs1() {
        return true;
    }

    @Override
    protected void encode() {
        int j;
        int i;
        int[] row_indicator = new int[44];
        int[] row_check = new int[44];
        this.finalMode = CfMode.MODEA;
        if (!this.content.matches("[\u0000-\u00ff]*")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        this.inputData = CodablockF.toBytes(this.content, StandardCharsets.ISO_8859_1, 0);
        int input_length = this.inputData.length - 1;
        if (input_length > 5450) {
            throw OkapiInputException.inputTooLong();
        }
        double estimate_codelength = 2.0;
        Mode last_mode = Mode.AORB;
        for (i = 0; i < input_length; ++i) {
            Mode this_mode = CodablockF.findSubset(this.inputData[i]);
            if (this_mode != last_mode) {
                estimate_codelength += 1.0;
            }
            estimate_codelength = this_mode != Mode.ABORC ? (estimate_codelength += 1.0) : (estimate_codelength += 0.5);
            if (this.inputData[i] > 127) {
                estimate_codelength += 1.0;
            }
            last_mode = this_mode;
        }
        this.rows = (int)(0.5 + Math.sqrt(estimate_codelength / 1.45));
        if (this.rows < 2) {
            this.rows = 2;
        }
        if (this.rows > 44) {
            this.rows = 44;
        }
        this.columns = (int)estimate_codelength / this.rows;
        if (this.columns < 4) {
            this.columns = 4;
        }
        if (this.columns > 62) {
            throw OkapiInputException.inputTooLong();
        }
        this.data_encode_blockf();
        int k1 = 0;
        int k2 = 0;
        for (i = 0; i < input_length; ++i) {
            if (this.inputData[i] == -1) {
                k1 += (i + 1) * 29;
                k2 += i * 29;
                continue;
            }
            k1 += (i + 1) * this.inputData[i];
            k2 += i * this.inputData[i];
        }
        k1 %= 86;
        k2 %= 86;
        k1 = CodablockF.toSymbolValue(k1, this.finalMode);
        k2 = CodablockF.toSymbolValue(k2, this.finalMode);
        this.blockmatrix[this.rows - 1][this.columns - 2] = k1;
        this.blockmatrix[this.rows - 1][this.columns - 1] = k2;
        int min_module_height = (int)(0.55 * (double)(this.columns + 3)) + 3;
        if (min_module_height < 8) {
            min_module_height = 8;
        }
        if (this.subsets[0] == CfMode.MODEC) {
            row_indicator[0] = this.rows - 2;
        } else {
            row_indicator[0] = this.rows + 62;
            if (row_indicator[0] > 95) {
                row_indicator[0] = row_indicator[0] - 95;
            }
        }
        for (i = 1; i < this.rows; ++i) {
            row_indicator[i] = this.subsets[i] == CfMode.MODEC ? i + 42 : (i < 6 ? i + 10 : i + 20);
        }
        for (i = 0; i < this.rows; ++i) {
            int k = 103;
            switch (this.subsets[i].ordinal()) {
                case 0: {
                    k += 98;
                    break;
                }
                case 1: {
                    k += 100;
                    break;
                }
                case 2: {
                    k += 99;
                }
            }
            k += 2 * row_indicator[i];
            for (j = 0; j < this.columns; ++j) {
                k += (j + 3) * this.blockmatrix[i][j];
            }
            row_check[i] = k % 103;
        }
        this.readable = "";
        this.row_count = this.rows;
        this.pattern = new String[this.row_count];
        this.row_height = new int[this.row_count];
        this.infoLine("Grid Size: " + this.columns + " X " + this.rows);
        this.infoLine("K1 Check Digit: " + k1);
        this.infoLine("K2 Check Digit: " + k2);
        this.info("Encoding: ");
        for (i = 0; i < this.rows; ++i) {
            String row_pattern = "";
            row_pattern = row_pattern + C_128_TABLE[103];
            switch (this.subsets[i].ordinal()) {
                case 0: {
                    row_pattern = row_pattern + C_128_TABLE[98];
                    this.info("MODEA ");
                    break;
                }
                case 1: {
                    row_pattern = row_pattern + C_128_TABLE[100];
                    this.info("MODEB ");
                    break;
                }
                case 2: {
                    row_pattern = row_pattern + C_128_TABLE[99];
                    this.info("MODEC ");
                }
            }
            row_pattern = row_pattern + C_128_TABLE[row_indicator[i]];
            this.infoSpace(row_indicator[i]);
            for (j = 0; j < this.columns; ++j) {
                row_pattern = row_pattern + C_128_TABLE[this.blockmatrix[i][j]];
                this.infoSpace(this.blockmatrix[i][j]);
            }
            row_pattern = row_pattern + C_128_TABLE[row_check[i]];
            this.info("(" + row_check[i] + ") ");
            this.pattern[i] = row_pattern = row_pattern + C_128_TABLE[106];
            this.row_height[i] = this.default_height;
        }
        this.infoLine();
    }

    private static Mode findSubset(int letter) {
        Mode mode = letter == -1 ? Mode.AORB : (letter <= 31 ? Mode.SHIFTA : (letter >= 48 && letter <= 57 ? Mode.ABORC : (letter <= 95 ? Mode.AORB : (letter <= 127 ? Mode.SHIFTB : (letter <= 159 ? Mode.SHIFTA : (letter <= 223 ? Mode.AORB : Mode.SHIFTB))))));
        return mode;
    }

    private static int toSymbolValue(int k, CfMode mode) {
        if (mode == CfMode.MODEC) {
            return k;
        }
        if (k < 32) {
            return k + 64;
        }
        if (k < 48) {
            return k - 32;
        }
        return k - 22;
    }

    private void data_encode_blockf() {
        int input_length = this.inputData.length - 1;
        boolean exit_status = false;
        int current_row = 0;
        CfMode current_mode = CfMode.MODEA;
        int column_position = 0;
        int input_position = 0;
        int c = 0;
        do {
            boolean done = false;
            if (column_position == 0) {
                c = this.columns;
                this.subsets[current_row] = current_mode = this.character_subset_select(input_position);
                if (current_row == 0 && this.inputDataType == Symbol.DataType.GS1) {
                    this.blockmatrix[current_row][column_position] = 102;
                    ++column_position;
                    --c;
                }
            }
            if (this.inputData[input_position] == -1) {
                this.blockmatrix[current_row][column_position] = 102;
                ++column_position;
                --c;
                ++input_position;
                done = true;
            }
            if (!done && c <= 2) {
                switch (current_mode.ordinal()) {
                    case 0: {
                        if (CodablockF.findSubset(this.inputData[input_position]) == Mode.ABORC) {
                            this.blockmatrix[current_row][column_position] = CodablockF.a3_convert(this.inputData[input_position]);
                            ++column_position;
                            --c;
                            ++input_position;
                            done = true;
                        }
                        if (CodablockF.findSubset(this.inputData[input_position]) == Mode.SHIFTB && c == 1) {
                            this.blockmatrix[current_row][column_position] = 100;
                            ++column_position;
                            --c;
                            done = true;
                        }
                        if (this.inputData[input_position] >= 244 && !done) {
                            this.blockmatrix[current_row][column_position] = 100;
                            ++column_position;
                            if (--c == 1) {
                                this.blockmatrix[current_row][column_position] = 101;
                                ++column_position;
                                --c;
                            }
                            done = true;
                        }
                        if (this.inputData[input_position] < 128 || done || c != 1) break;
                        this.blockmatrix[current_row][column_position] = 100;
                        ++column_position;
                        --c;
                        done = true;
                        break;
                    }
                    case 1: {
                        if (CodablockF.findSubset(this.inputData[input_position]) == Mode.ABORC) {
                            this.blockmatrix[current_row][column_position] = CodablockF.a3_convert(this.inputData[input_position]);
                            ++column_position;
                            --c;
                            ++input_position;
                            done = true;
                        }
                        if (CodablockF.findSubset(this.inputData[input_position]) == Mode.SHIFTA && c == 1) {
                            this.blockmatrix[current_row][column_position] = 101;
                            ++column_position;
                            --c;
                            done = true;
                        }
                        if (this.inputData[input_position] >= 128 && this.inputData[input_position] <= 159 && !done) {
                            this.blockmatrix[current_row][column_position] = 101;
                            ++column_position;
                            if (--c == 1) {
                                this.blockmatrix[current_row][column_position] = 100;
                                ++column_position;
                                --c;
                            }
                            done = true;
                        }
                        if (this.inputData[input_position] < 160 || done || c != 1) break;
                        this.blockmatrix[current_row][column_position] = 101;
                        ++column_position;
                        --c;
                        done = true;
                        break;
                    }
                    case 2: {
                        if (CodablockF.findSubset(this.inputData[input_position]) != Mode.ABORC && c == 1) {
                            this.blockmatrix[current_row][column_position] = 101;
                            ++column_position;
                            --c;
                            done = true;
                        }
                        if (CodablockF.findSubset(this.inputData[input_position]) == Mode.ABORC && CodablockF.findSubset(this.inputData[input_position + 1]) != Mode.ABORC && c == 1) {
                            this.blockmatrix[current_row][column_position] = 101;
                            ++column_position;
                            --c;
                            done = true;
                        }
                        if (this.inputData[input_position] < 128) break;
                        this.blockmatrix[current_row][column_position] = 101;
                        ++column_position;
                        if (--c == 1) {
                            this.blockmatrix[current_row][column_position] = 100;
                            ++column_position;
                            --c;
                        }
                        done = true;
                    }
                }
            }
            if (!(done || CodablockF.findSubset(this.inputData[input_position]) != Mode.AORB && CodablockF.findSubset(this.inputData[input_position]) != Mode.SHIFTA || current_mode != CfMode.MODEA)) {
                if (this.inputData[input_position] >= 128) {
                    this.blockmatrix[current_row][column_position] = 101;
                    ++column_position;
                    --c;
                }
                this.blockmatrix[current_row][column_position] = CodablockF.a3_convert(this.inputData[input_position]);
                ++column_position;
                --c;
                ++input_position;
                done = true;
            }
            if (!(done || CodablockF.findSubset(this.inputData[input_position]) != Mode.AORB && CodablockF.findSubset(this.inputData[input_position]) != Mode.SHIFTB || current_mode != CfMode.MODEB)) {
                if (this.inputData[input_position] >= 128) {
                    this.blockmatrix[current_row][column_position] = 100;
                    ++column_position;
                    --c;
                }
                this.blockmatrix[current_row][column_position] = CodablockF.a3_convert(this.inputData[input_position]);
                ++column_position;
                --c;
                ++input_position;
                done = true;
            }
            if (!done && CodablockF.findSubset(this.inputData[input_position]) == Mode.ABORC && CodablockF.findSubset(this.inputData[input_position + 1]) == Mode.ABORC && current_mode == CfMode.MODEC) {
                this.blockmatrix[current_row][column_position] = (this.inputData[input_position] - 48) * 10 + (this.inputData[input_position + 1] - 48);
                ++column_position;
                --c;
                input_position += 2;
                done = true;
            }
            if (!(done || current_mode != CfMode.MODEA && current_mode != CfMode.MODEB || CodablockF.findSubset(this.inputData[input_position]) != Mode.ABORC && this.inputData[input_position] != -1)) {
                int i = 0;
                int j = 0;
                do {
                    ++i;
                    if (this.inputData[input_position + j] != -1) continue;
                    ++i;
                } while (CodablockF.findSubset(this.inputData[input_position + ++j]) == Mode.ABORC || this.inputData[input_position + j] == -1 && i % 2 == 0);
                if (--i >= 4) {
                    if (i % 2 == 1) {
                        this.blockmatrix[current_row][column_position] = 99;
                        --c;
                        this.blockmatrix[current_row][++column_position] = (this.inputData[input_position] - 48) * 10 + (this.inputData[input_position + 1] - 48);
                        ++column_position;
                        --c;
                        input_position += 2;
                        current_mode = CfMode.MODEC;
                    } else {
                        this.blockmatrix[current_row][column_position] = CodablockF.a3_convert(this.inputData[input_position]);
                        ++column_position;
                        --c;
                        ++input_position;
                    }
                    done = true;
                } else {
                    this.blockmatrix[current_row][column_position] = CodablockF.a3_convert(this.inputData[input_position]);
                    ++column_position;
                    --c;
                    ++input_position;
                    done = true;
                }
            }
            if (!done && current_mode == CfMode.MODEB && CodablockF.findSubset(this.inputData[input_position]) == Mode.SHIFTA) {
                if (this.inputData[input_position + 1] >= 96 && this.inputData[input_position + 1] <= 127) {
                    this.blockmatrix[current_row][column_position] = 98;
                    ++column_position;
                    --c;
                    if (this.inputData[input_position] >= 128) {
                        this.blockmatrix[current_row][column_position] = 101;
                        ++column_position;
                        --c;
                    }
                    this.blockmatrix[current_row][column_position] = CodablockF.a3_convert(this.inputData[input_position]);
                    ++column_position;
                    --c;
                    ++input_position;
                } else {
                    this.blockmatrix[current_row][column_position] = 101;
                    ++column_position;
                    --c;
                    if (this.inputData[input_position] >= 128) {
                        this.blockmatrix[current_row][column_position] = 101;
                        ++column_position;
                        --c;
                    }
                    this.blockmatrix[current_row][column_position] = CodablockF.a3_convert(this.inputData[input_position]);
                    ++column_position;
                    --c;
                    ++input_position;
                    current_mode = CfMode.MODEA;
                }
                done = true;
            }
            if (!done && current_mode == CfMode.MODEA && CodablockF.findSubset(this.inputData[input_position]) == Mode.SHIFTB) {
                if (input_position + 2 < this.inputData.length && CodablockF.findSubset(this.inputData[input_position + 1]) == Mode.SHIFTA && CodablockF.findSubset(this.inputData[input_position + 2]) == Mode.SHIFTB) {
                    this.blockmatrix[current_row][column_position] = 98;
                    ++column_position;
                    --c;
                    if (this.inputData[input_position] >= 128) {
                        this.blockmatrix[current_row][column_position] = 100;
                        ++column_position;
                        --c;
                    }
                    this.blockmatrix[current_row][column_position] = CodablockF.a3_convert(this.inputData[input_position]);
                    ++column_position;
                    --c;
                    ++input_position;
                } else {
                    this.blockmatrix[current_row][column_position] = 100;
                    ++column_position;
                    --c;
                    if (this.inputData[input_position] >= 128) {
                        this.blockmatrix[current_row][column_position] = 100;
                        ++column_position;
                        --c;
                    }
                    this.blockmatrix[current_row][column_position] = CodablockF.a3_convert(this.inputData[input_position]);
                    ++column_position;
                    --c;
                    ++input_position;
                    current_mode = CfMode.MODEB;
                }
                done = true;
            }
            if (!(done || current_mode != CfMode.MODEC || CodablockF.findSubset(this.inputData[input_position]) == Mode.ABORC && CodablockF.findSubset(this.inputData[input_position + 1]) == Mode.ABORC)) {
                if (CodablockF.findSubset(this.inputData[input_position]) == Mode.SHIFTA) {
                    this.blockmatrix[current_row][column_position] = 101;
                    ++column_position;
                    --c;
                    if (this.inputData[input_position] >= 128) {
                        this.blockmatrix[current_row][column_position] = 101;
                        ++column_position;
                        --c;
                    }
                    this.blockmatrix[current_row][column_position] = CodablockF.a3_convert(this.inputData[input_position]);
                    ++column_position;
                    --c;
                    ++input_position;
                    current_mode = CfMode.MODEA;
                } else {
                    this.blockmatrix[current_row][column_position] = 100;
                    ++column_position;
                    --c;
                    if (this.inputData[input_position] >= 128) {
                        this.blockmatrix[current_row][column_position] = 100;
                        ++column_position;
                        --c;
                    }
                    this.blockmatrix[current_row][column_position] = CodablockF.a3_convert(this.inputData[input_position]);
                    ++column_position;
                    --c;
                    ++input_position;
                    current_mode = CfMode.MODEB;
                }
                done = true;
            }
            if (input_position == input_length) {
                if (c == 1) {
                    if (current_mode == CfMode.MODEA) {
                        this.blockmatrix[current_row][column_position] = 100;
                        current_mode = CfMode.MODEB;
                    } else {
                        this.blockmatrix[current_row][column_position] = 101;
                        current_mode = CfMode.MODEA;
                    }
                    ++column_position;
                    --c;
                }
                if (c == 0) {
                    column_position = 0;
                    c = this.columns;
                    this.subsets[++current_row] = CfMode.MODEA;
                    current_mode = CfMode.MODEA;
                }
                if (c > 2) {
                    do {
                        if (current_mode == CfMode.MODEA) {
                            this.blockmatrix[current_row][column_position] = 100;
                            current_mode = CfMode.MODEB;
                        } else {
                            this.blockmatrix[current_row][column_position] = 101;
                            current_mode = CfMode.MODEA;
                        }
                        ++column_position;
                    } while (--c > 2);
                }
                exit_status = true;
                this.finalMode = current_mode;
                continue;
            }
            if (c > 0) continue;
            column_position = 0;
            if (++current_row <= 43) continue;
            throw new OkapiInputException("Too many rows.");
        } while (!exit_status);
        if (current_row == 0) {
            for (c = column_position; c <= this.columns; ++c) {
                if (current_mode == CfMode.MODEA) {
                    this.blockmatrix[current_row][c] = 100;
                    current_mode = CfMode.MODEB;
                    continue;
                }
                this.blockmatrix[current_row][c] = 101;
                current_mode = CfMode.MODEA;
            }
            this.subsets[++current_row] = CfMode.MODEA;
            current_mode = CfMode.MODEA;
            for (c = 0; c <= this.columns - 2; ++c) {
                if (current_mode == CfMode.MODEA) {
                    this.blockmatrix[current_row][c] = 100;
                    current_mode = CfMode.MODEB;
                    continue;
                }
                this.blockmatrix[current_row][c] = 101;
                current_mode = CfMode.MODEA;
            }
        }
        this.rows = current_row + 1;
    }

    private CfMode character_subset_select(int input_position) {
        if (this.inputData[input_position] >= 48 && this.inputData[input_position] <= 57) {
            return CfMode.MODEC;
        }
        if (this.inputData[input_position] >= 128 && this.inputData[input_position] <= 160) {
            return CfMode.MODEA;
        }
        if (this.inputData[input_position] >= 0 && this.inputData[input_position] <= 31) {
            return CfMode.MODEA;
        }
        return CfMode.MODEB;
    }

    private static int a3_convert(int source) {
        if (source < 32) {
            return source + 64;
        }
        if (source <= 127) {
            return source - 32;
        }
        if (source <= 159) {
            return source - 128 + 64;
        }
        return source - 128 - 32;
    }

    @Override
    protected void plotSymbol() {
        this.resetPlotElements();
        int y = 1;
        int h = 1;
        for (int yBlock = 0; yBlock < this.row_count; ++yBlock) {
            boolean black = true;
            int x = 0;
            for (int xBlock = 0; xBlock < this.pattern[yBlock].length(); ++xBlock) {
                char c = this.pattern[yBlock].charAt(xBlock);
                int w = (c - 48) * this.moduleWidth;
                if (black) {
                    h = this.row_height[yBlock];
                    if (w != 0 && h != 0) {
                        Rectangle rect = new Rectangle(x, y, w, h);
                        this.rectangles.add(rect);
                    }
                    if (x + w > this.symbol_width) {
                        this.symbol_width = x + w;
                    }
                }
                black = !black;
                x += w;
            }
            if ((y += h) > this.symbol_height) {
                this.symbol_height = y;
            }
            if (yBlock == this.row_count - 1) continue;
            Rectangle rect = new Rectangle(11 * this.moduleWidth, y - 1, this.symbol_width - 24 * this.moduleWidth, 2.0);
            this.rectangles.add(rect);
        }
        this.rectangles.add(new Rectangle(0.0, 0.0, this.symbol_width, 2.0));
        this.rectangles.add(new Rectangle(0.0, y - 1, this.symbol_width, 2.0));
        this.symbol_height = this.rows * this.default_height + 2;
    }

    private static enum CfMode {
        MODEA,
        MODEB,
        MODEC;

    }

    private static enum Mode {
        SHIFTA,
        LATCHA,
        SHIFTB,
        LATCHB,
        SHIFTC,
        LATCHC,
        AORB,
        ABORC,
        CANDB,
        CANDBB;

    }
}

