/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import uk.org.okapibarcode.backend.OkapiInputException;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.util.Arrays;

public class Code11
extends Symbol {
    private static final String[] CODE_11_TABLE = new String[]{"111121", "211121", "121121", "221111", "112121", "212111", "122111", "111221", "211211", "211111", "112111"};
    private static final char[] CHARACTER_SET = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-'};
    private double moduleWidthRatio = 2.0;
    private int checkDigitCount = 2;
    private Character startDelimiter;
    private Character stopDelimiter;

    public void setModuleWidthRatio(double moduleWidthRatio) {
        this.moduleWidthRatio = moduleWidthRatio;
    }

    public double getModuleWidthRatio() {
        return this.moduleWidthRatio;
    }

    public void setCheckDigitCount(int checkDigitCount) {
        if (checkDigitCount < 1 || checkDigitCount > 2) {
            throw new IllegalArgumentException("Check digit count must be 1 or 2.");
        }
        this.checkDigitCount = checkDigitCount;
    }

    public int getCheckDigitCount() {
        return this.checkDigitCount;
    }

    public void setStartDelimiter(Character startDelimiter) {
        this.startDelimiter = startDelimiter;
    }

    public Character getStartDelimiter() {
        return this.startDelimiter;
    }

    public void setStopDelimiter(Character stopDelimiter) {
        this.stopDelimiter = stopDelimiter;
    }

    public Character getStopDelimiter() {
        return this.stopDelimiter;
    }

    @Override
    protected void encode() {
        if (!this.content.matches("[0-9-]*")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        String horizontalSpacing = "112211";
        String humanReadable = this.content;
        int length = this.content.length();
        int[] weight = new int[length + 1];
        for (int i = 0; i < length; ++i) {
            char c = this.content.charAt(i);
            weight[i] = Arrays.positionOf(c, CHARACTER_SET);
            horizontalSpacing = horizontalSpacing + CODE_11_TABLE[weight[i]];
        }
        int checkDigitC = Code11.getCheckDigitC(weight, length);
        horizontalSpacing = horizontalSpacing + CODE_11_TABLE[checkDigitC];
        humanReadable = humanReadable + CHARACTER_SET[checkDigitC];
        this.infoLine("Check Digit C: " + checkDigitC);
        if (this.checkDigitCount == 2) {
            weight[length] = checkDigitC;
            int checkDigitK = Code11.getCheckDigitK(weight, length + 1);
            horizontalSpacing = horizontalSpacing + CODE_11_TABLE[checkDigitK];
            humanReadable = humanReadable + CHARACTER_SET[checkDigitK];
            this.infoLine("Check Digit K: " + checkDigitK);
        }
        horizontalSpacing = horizontalSpacing + "112211";
        this.readable = humanReadable;
        if (this.startDelimiter != null) {
            this.readable = this.startDelimiter + this.readable;
        }
        if (this.stopDelimiter != null) {
            this.readable = this.readable + this.stopDelimiter;
        }
        this.pattern = new String[]{horizontalSpacing};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }

    private static int getCheckDigitC(int[] weight, int length) {
        int countC = 0;
        int weightC = 1;
        for (int i = length - 1; i >= 0; --i) {
            countC += weightC * weight[i];
            if (++weightC <= 10) continue;
            weightC = 1;
        }
        return countC % 11;
    }

    private static int getCheckDigitK(int[] weight, int length) {
        int countK = 0;
        int weightK = 1;
        for (int i = length - 1; i >= 0; --i) {
            countK += weightK * weight[i];
            if (++weightK <= 9) continue;
            weightK = 1;
        }
        return countK % 11;
    }

    @Override
    protected double getModuleWidth(int originalWidth) {
        if (originalWidth == 1) {
            return 1.0;
        }
        return this.moduleWidthRatio;
    }

    @Override
    protected int[] getCodewords() {
        return this.getPatternAsCodewords(6);
    }
}

