/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import uk.org.okapibarcode.backend.Code3Of9;
import uk.org.okapibarcode.backend.OkapiInputException;
import uk.org.okapibarcode.backend.Symbol;

public class Code3Of9Extended
extends Symbol {
    private static final String[] E_CODE_39 = new String[]{"%U", "$A", "$B", "$C", "$D", "$E", "$F", "$G", "$H", "$I", "$J", "$K", "$L", "$M", "$N", "$O", "$P", "$Q", "$R", "$S", "$T", "$U", "$V", "$W", "$X", "$Y", "$Z", "%A", "%B", "%C", "%D", "%E", " ", "/A", "/B", "/C", "/D", "/E", "/F", "/G", "/H", "/I", "/J", "/K", "/L", "-", ".", "/O", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "/Z", "%F", "%G", "%H", "%I", "%J", "%V", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "%K", "%L", "%M", "%N", "%O", "%W", "+A", "+B", "+C", "+D", "+E", "+F", "+G", "+H", "+I", "+J", "+K", "+L", "+M", "+N", "+O", "+P", "+Q", "+R", "+S", "+T", "+U", "+V", "+W", "+X", "+Y", "+Z", "%P", "%Q", "%R", "%S", "%T"};
    private CheckDigit checkDigit = CheckDigit.NONE;
    private double moduleWidthRatio = 2.0;

    public void setModuleWidthRatio(double moduleWidthRatio) {
        this.moduleWidthRatio = moduleWidthRatio;
    }

    public double getModuleWidthRatio() {
        return this.moduleWidthRatio;
    }

    public void setCheckDigit(CheckDigit checkDigit) {
        this.checkDigit = checkDigit;
    }

    public CheckDigit getCheckDigit() {
        return this.checkDigit;
    }

    @Override
    protected void encode() {
        if (!this.content.matches("[\u0000-\u007f]*")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        StringBuilder s = new StringBuilder(this.content.length() * 2);
        for (int i = 0; i < this.content.length(); ++i) {
            char c = this.content.charAt(i);
            s.append(E_CODE_39[c]);
        }
        Code3Of9 code39 = new Code3Of9();
        if (this.checkDigit == CheckDigit.MOD43) {
            code39.setCheckDigit(Code3Of9.CheckDigit.MOD43);
        }
        code39.setEmptyContentAllowed(this.emptyContentAllowed);
        code39.setModuleWidthRatio(this.moduleWidthRatio);
        code39.setContent(s.toString());
        this.readable = this.content;
        this.pattern = new String[]{code39.pattern[0]};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }

    @Override
    protected double getModuleWidth(int originalWidth) {
        if (originalWidth == 1) {
            return 1.0;
        }
        return this.moduleWidthRatio;
    }

    public static enum CheckDigit {
        NONE,
        MOD43;

    }
}

