/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import uk.org.okapibarcode.backend.OkapiInputException;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.util.Arrays;

public class Code93
extends Symbol {
    private static final String[] CODE_93_CTRL = new String[]{"bU", "aA", "aB", "aC", "aD", "aE", "aF", "aG", "aH", "aI", "aJ", "aK", "aL", "aM", "aN", "aO", "aP", "aQ", "aR", "aS", "aT", "aU", "aV", "aW", "aX", "aY", "aZ", "bA", "bB", "bC", "bD", "bE", " ", "cA", "cB", "cC", "$", "%", "cF", "cG", "cH", "cI", "cJ", "+", "cL", "-", ".", "/", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "cZ", "bF", "bG", "bH", "bI", "bJ", "bV", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bK", "bL", "bM", "bN", "bO", "bW", "dA", "dB", "dC", "dD", "dE", "dF", "dG", "dH", "dI", "dJ", "dK", "dL", "dM", "dN", "dO", "dP", "dQ", "dR", "dS", "dT", "dU", "dV", "dW", "dX", "dY", "dZ", "bP", "bQ", "bR", "bS", "bT"};
    private static final char[] CODE_93_LOOKUP = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '-', '.', ' ', '$', '/', '+', '%', 'a', 'b', 'c', 'd'};
    private static final String[] CODE_93_TABLE = new String[]{"131112", "111213", "111312", "111411", "121113", "121212", "121311", "111114", "131211", "141111", "211113", "211212", "211311", "221112", "221211", "231111", "112113", "112212", "112311", "122112", "132111", "111123", "111222", "111321", "121122", "131121", "212112", "212211", "211122", "211221", "221121", "222111", "112122", "112221", "122121", "123111", "121131", "311112", "311211", "321111", "112131", "113121", "211131", "121221", "312111", "311121", "122211"};
    private boolean showCheckDigits = true;
    private Character startStopDelimiter;

    public void setShowCheckDigits(boolean showCheckDigits) {
        this.showCheckDigits = showCheckDigits;
    }

    public boolean getShowCheckDigits() {
        return this.showCheckDigits;
    }

    public void setStartStopDelimiter(Character startStopDelimiter) {
        this.startStopDelimiter = startStopDelimiter;
    }

    public Character getStartStopDelimiter() {
        return this.startStopDelimiter;
    }

    @Override
    protected void encode() {
        int k;
        int c;
        if (!this.content.matches("[\u0000-\u007f]*")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        char[] controlChars = Code93.toControlChars(this.content);
        int l = controlChars.length;
        int[] values = new int[controlChars.length + 2];
        for (int i = 0; i < l; ++i) {
            values[i] = Arrays.positionOf(controlChars[i], CODE_93_LOOKUP);
        }
        values[l] = c = Code93.calculateCheckDigitC(values, l);
        values[++l] = k = Code93.calculateCheckDigitK(values, l);
        ++l;
        this.readable = this.content;
        if (this.showCheckDigits) {
            this.readable = this.readable + CODE_93_LOOKUP[c] + CODE_93_LOOKUP[k];
        }
        if (this.startStopDelimiter != null) {
            this.readable = this.startStopDelimiter + this.readable + this.startStopDelimiter;
        }
        this.infoLine("Check Digit C: " + c);
        this.infoLine("Check Digit K: " + k);
        this.pattern = new String[]{Code93.toPattern(values)};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }

    private static char[] toControlChars(String s) {
        StringBuilder buffer = new StringBuilder();
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char asciiCode = chars[i];
            buffer.append(CODE_93_CTRL[asciiCode]);
        }
        return buffer.toString().toCharArray();
    }

    private static int calculateCheckDigitC(int[] values, int length) {
        int c = 0;
        int weight = 1;
        for (int i = length - 1; i >= 0; --i) {
            c += values[i] * weight;
            if (++weight != 21) continue;
            weight = 1;
        }
        return c %= 47;
    }

    private static int calculateCheckDigitK(int[] values, int length) {
        int k = 0;
        int weight = 1;
        for (int i = length - 1; i >= 0; --i) {
            k += values[i] * weight;
            if (++weight != 16) continue;
            weight = 1;
        }
        return k %= 47;
    }

    private static String toPattern(int[] values) {
        StringBuilder buffer = new StringBuilder("111141");
        for (int i = 0; i < values.length; ++i) {
            buffer.append(CODE_93_TABLE[values[i]]);
        }
        buffer.append("1111411");
        return buffer.toString();
    }

    @Override
    protected int[] getCodewords() {
        return this.getPatternAsCodewords(6);
    }
}

