/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import java.math.BigInteger;
import uk.org.okapibarcode.backend.OkapiInputException;
import uk.org.okapibarcode.backend.Symbol;

public class DataBarLimited
extends Symbol {
    private static final int[] T_EVEN_LTD = new int[]{28, 728, 6454, 203, 2408, 1, 16632};
    private static final int[] MODULES_ODD_LTD = new int[]{17, 13, 9, 15, 11, 19, 7};
    private static final int[] MODULES_EVEN_LTD = new int[]{9, 13, 17, 11, 15, 7, 19};
    private static final int[] WIDEST_ODD_LTD = new int[]{6, 5, 3, 5, 4, 8, 1};
    private static final int[] WIDEST_EVEN_LTD = new int[]{3, 4, 6, 4, 5, 1, 8};
    private static final int[] CHECKSUM_WEIGHT_LTD = new int[]{1, 3, 9, 27, 81, 65, 17, 51, 64, 14, 42, 37, 22, 66, 20, 60, 2, 6, 18, 54, 73, 41, 34, 13, 39, 28, 84, 74};
    private static final int[] FINDER_PATTERN_LTD = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 3, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 3, 2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 3, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 3, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 2, 1, 1, 3, 1, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 3, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 2, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 2, 2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 2, 2, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1, 2, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 2, 2, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 2, 1, 2, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 1, 1, 2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 3, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 3, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 2, 2, 1, 1, 1, 1, 1, 2, 1, 1, 2, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 2, 1, 1, 2, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 2, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1, 2, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 3, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 2, 2, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 2, 2, 1, 1, 1, 1, 2, 1, 2, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 3, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 2, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 2, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 2, 2, 1, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 2, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 2, 2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 3, 1, 1, 2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 3, 2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 2, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 2, 2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 3, 1, 1, 2, 1, 1, 1, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 2, 1, 1, 2, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 3, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 2, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1, 2, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 3, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 2, 2, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 2, 1, 1, 2, 1, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 2, 1, 1};
    private boolean linkageFlag;

    @Override
    public boolean supportsGs1() {
        return false;
    }

    protected void setLinkageFlag() {
        this.linkageFlag = true;
    }

    protected void unsetLinkageFlag() {
        this.linkageFlag = false;
    }

    @Override
    protected void encode() {
        int i;
        int[] left_widths = new int[14];
        int[] right_widths = new int[14];
        int[] check_elements = new int[14];
        int[] total_widths = new int[46];
        int check_digit = 0;
        int count = 0;
        int compositeOffset = 0;
        if (this.content.length() > 13) {
            throw OkapiInputException.inputTooLong();
        }
        if (!this.content.matches("[0-9]*")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        if (this.content.length() == 13 && this.content.charAt(0) != '0' && this.content.charAt(0) != '1') {
            throw new OkapiInputException("Input out of range");
        }
        BigInteger accum = new BigInteger(this.content);
        if (this.linkageFlag) {
            accum = accum.add(new BigInteger("2015133531096"));
        }
        BigInteger left_reg = accum.divide(new BigInteger("2013571"));
        BigInteger right_reg = accum.mod(new BigInteger("2013571"));
        int left_group = 0;
        if (left_reg.compareTo(new BigInteger("183063")) == 1) {
            left_group = 1;
        }
        if (left_reg.compareTo(new BigInteger("820063")) == 1) {
            left_group = 2;
        }
        if (left_reg.compareTo(new BigInteger("1000775")) == 1) {
            left_group = 3;
        }
        if (left_reg.compareTo(new BigInteger("1491020")) == 1) {
            left_group = 4;
        }
        if (left_reg.compareTo(new BigInteger("1979844")) == 1) {
            left_group = 5;
        }
        if (left_reg.compareTo(new BigInteger("1996938")) == 1) {
            left_group = 6;
        }
        int right_group = 0;
        if (right_reg.compareTo(new BigInteger("183063")) == 1) {
            right_group = 1;
        }
        if (right_reg.compareTo(new BigInteger("820063")) == 1) {
            right_group = 2;
        }
        if (right_reg.compareTo(new BigInteger("1000775")) == 1) {
            right_group = 3;
        }
        if (right_reg.compareTo(new BigInteger("1491020")) == 1) {
            right_group = 4;
        }
        if (right_reg.compareTo(new BigInteger("1979844")) == 1) {
            right_group = 5;
        }
        if (right_reg.compareTo(new BigInteger("1996938")) == 1) {
            right_group = 6;
        }
        this.infoLine("Data Characters: " + (left_group + 1) + " " + (right_group + 1));
        switch (left_group) {
            case 1: {
                left_reg = left_reg.subtract(new BigInteger("183064"));
                break;
            }
            case 2: {
                left_reg = left_reg.subtract(new BigInteger("820064"));
                break;
            }
            case 3: {
                left_reg = left_reg.subtract(new BigInteger("1000776"));
                break;
            }
            case 4: {
                left_reg = left_reg.subtract(new BigInteger("1491021"));
                break;
            }
            case 5: {
                left_reg = left_reg.subtract(new BigInteger("1979845"));
                break;
            }
            case 6: {
                left_reg = left_reg.subtract(new BigInteger("1996939"));
            }
        }
        switch (right_group) {
            case 1: {
                right_reg = right_reg.subtract(new BigInteger("183064"));
                break;
            }
            case 2: {
                right_reg = right_reg.subtract(new BigInteger("820064"));
                break;
            }
            case 3: {
                right_reg = right_reg.subtract(new BigInteger("1000776"));
                break;
            }
            case 4: {
                right_reg = right_reg.subtract(new BigInteger("1491021"));
                break;
            }
            case 5: {
                right_reg = right_reg.subtract(new BigInteger("1979845"));
                break;
            }
            case 6: {
                right_reg = right_reg.subtract(new BigInteger("1996939"));
            }
        }
        int left_character = left_reg.intValue();
        int right_character = right_reg.intValue();
        int left_odd = left_character / T_EVEN_LTD[left_group];
        int left_even = left_character % T_EVEN_LTD[left_group];
        int right_odd = right_character / T_EVEN_LTD[right_group];
        int right_even = right_character % T_EVEN_LTD[right_group];
        int[] widths = DataBarLimited.getWidths(left_odd, MODULES_ODD_LTD[left_group], 7, WIDEST_ODD_LTD[left_group], 1);
        left_widths[0] = widths[0];
        left_widths[2] = widths[1];
        left_widths[4] = widths[2];
        left_widths[6] = widths[3];
        left_widths[8] = widths[4];
        left_widths[10] = widths[5];
        left_widths[12] = widths[6];
        widths = DataBarLimited.getWidths(left_even, MODULES_EVEN_LTD[left_group], 7, WIDEST_EVEN_LTD[left_group], 0);
        left_widths[1] = widths[0];
        left_widths[3] = widths[1];
        left_widths[5] = widths[2];
        left_widths[7] = widths[3];
        left_widths[9] = widths[4];
        left_widths[11] = widths[5];
        left_widths[13] = widths[6];
        widths = DataBarLimited.getWidths(right_odd, MODULES_ODD_LTD[right_group], 7, WIDEST_ODD_LTD[right_group], 1);
        right_widths[0] = widths[0];
        right_widths[2] = widths[1];
        right_widths[4] = widths[2];
        right_widths[6] = widths[3];
        right_widths[8] = widths[4];
        right_widths[10] = widths[5];
        right_widths[12] = widths[6];
        widths = DataBarLimited.getWidths(right_even, MODULES_EVEN_LTD[right_group], 7, WIDEST_EVEN_LTD[right_group], 0);
        right_widths[1] = widths[0];
        right_widths[3] = widths[1];
        right_widths[5] = widths[2];
        right_widths[7] = widths[3];
        right_widths[9] = widths[4];
        right_widths[11] = widths[5];
        right_widths[13] = widths[6];
        int checksum = 0;
        for (i = 0; i < 14; ++i) {
            checksum += CHECKSUM_WEIGHT_LTD[i] * left_widths[i];
            checksum += CHECKSUM_WEIGHT_LTD[i + 14] * right_widths[i];
        }
        this.infoLine("Checksum: " + (checksum %= 89));
        for (i = 0; i < 14; ++i) {
            check_elements[i] = FINDER_PATTERN_LTD[i + checksum * 14];
        }
        total_widths[0] = 1;
        total_widths[1] = 1;
        total_widths[44] = 1;
        total_widths[45] = 1;
        for (i = 0; i < 14; ++i) {
            total_widths[i + 2] = left_widths[i];
            total_widths[i + 16] = check_elements[i];
            total_widths[i + 30] = right_widths[i];
        }
        StringBuilder bin = new StringBuilder();
        StringBuilder notbin = new StringBuilder();
        int writer = 0;
        boolean bar_latch = false;
        for (i = 0; i < 46; ++i) {
            for (int j = 0; j < total_widths[i]; ++j) {
                if (bar_latch) {
                    bin.append('1');
                    notbin.append('0');
                } else {
                    bin.append('0');
                    notbin.append('1');
                }
                ++writer;
            }
            bar_latch = !bar_latch;
        }
        this.readable = "(01)";
        String hrt = "";
        for (i = this.content.length(); i < 13; ++i) {
            hrt = hrt + "0";
        }
        hrt = hrt + this.content;
        for (i = 0; i < 13; ++i) {
            count += hrt.charAt(i) - 48;
            if ((i & 1) != 0) continue;
            count += 2 * (hrt.charAt(i) - 48);
        }
        check_digit = 10 - count % 10;
        if (check_digit == 10) {
            check_digit = 0;
        }
        hrt = hrt + (char)(check_digit + 48);
        this.readable = this.readable + hrt;
        if (this.linkageFlag) {
            compositeOffset = 1;
        }
        this.row_count = 1 + compositeOffset;
        this.row_height = new int[1 + compositeOffset];
        this.row_height[0 + compositeOffset] = -1;
        this.pattern = new String[1 + compositeOffset];
        this.pattern[0 + compositeOffset] = DataBarLimited.bin2pat(bin);
        if (this.linkageFlag) {
            notbin.delete(70, notbin.length());
            notbin.delete(0, 4);
            this.row_height[0] = 1;
            this.pattern[0] = "04" + DataBarLimited.bin2pat(notbin);
        }
    }

    private static int getCombinations(int n, int r) {
        int maxDenom;
        int minDenom;
        if (n - r > r) {
            minDenom = r;
            maxDenom = n - r;
        } else {
            minDenom = n - r;
            maxDenom = r;
        }
        int val = 1;
        int j = 1;
        for (int i = n; i > maxDenom; --i) {
            val *= i;
            if (j > minDenom) continue;
            val /= j;
            ++j;
        }
        while (j <= minDenom) {
            val /= j;
            ++j;
        }
        return val;
    }

    static int[] getWidths(int val, int n, int elements, int maxWidth, int noNarrow) {
        int narrowMask = 0;
        int[] widths = new int[elements];
        for (int bar = 0; bar < elements - 1; ++bar) {
            int subVal;
            int elmWidth = 1;
            narrowMask |= 1 << bar;
            while (true) {
                subVal = DataBarLimited.getCombinations(n - elmWidth - 1, elements - bar - 2);
                if (noNarrow == 0 && narrowMask == 0 && n - elmWidth - (elements - bar - 1) >= elements - bar - 1) {
                    subVal -= DataBarLimited.getCombinations(n - elmWidth - (elements - bar), elements - bar - 2);
                }
                if (elements - bar - 1 > 1) {
                    int lessVal = 0;
                    for (int mxwElement = n - elmWidth - (elements - bar - 2); mxwElement > maxWidth; --mxwElement) {
                        lessVal += DataBarLimited.getCombinations(n - elmWidth - mxwElement - 1, elements - bar - 3);
                    }
                    subVal -= lessVal * (elements - 1 - bar);
                } else if (n - elmWidth > maxWidth) {
                    --subVal;
                }
                if ((val -= subVal) < 0) break;
                ++elmWidth;
                narrowMask &= ~(1 << bar);
            }
            val += subVal;
            n -= elmWidth;
            widths[bar] = elmWidth;
        }
        widths[bar] = n;
        return widths;
    }
}

