/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import uk.org.okapibarcode.backend.OkapiInputException;
import uk.org.okapibarcode.backend.Symbol;

public class EanUpcAddOn
extends Symbol {
    private static final String[] EAN_SET_A = new String[]{"3211", "2221", "2122", "1411", "1132", "1231", "1114", "1312", "1213", "3112"};
    private static final String[] EAN_SET_B = new String[]{"1123", "1222", "2212", "1141", "2311", "1321", "4111", "2131", "3121", "2113"};
    private static final String[] EAN2_PARITY = new String[]{"AA", "AB", "BA", "BB"};
    private static final String[] EAN5_PARITY = new String[]{"BBAAA", "BABAA", "BAABA", "BAAAB", "ABBAA", "AABBA", "AAABB", "ABABA", "ABAAB", "AABAB"};

    @Override
    protected void encode() {
        int targetLength;
        if (!this.content.matches("[0-9]+")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        if (this.content.length() > 5) {
            throw OkapiInputException.inputTooLong();
        }
        int n = targetLength = this.content.length() > 2 ? 5 : 2;
        if (this.content.length() < targetLength) {
            for (int i = this.content.length(); i < targetLength; ++i) {
                this.content = '0' + this.content;
            }
        }
        String bars = targetLength == 2 ? EanUpcAddOn.ean2(this.content) : EanUpcAddOn.ean5(this.content);
        this.readable = this.content;
        this.pattern = new String[]{bars};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }

    private static String ean2(String content) {
        int sum = (content.charAt(0) - 48) * 10 + (content.charAt(1) - 48);
        String parity = EAN2_PARITY[sum % 4];
        StringBuilder sb = new StringBuilder();
        sb.append("112");
        for (int i = 0; i < 2; ++i) {
            int val = content.charAt(i) - 48;
            if (parity.charAt(i) == 'B') {
                sb.append(EAN_SET_B[val]);
            } else {
                sb.append(EAN_SET_A[val]);
            }
            if (i == 1) continue;
            sb.append("11");
        }
        return sb.toString();
    }

    private static String ean5(String content) {
        int sum = 0;
        for (int i = 0; i < 5; ++i) {
            if (i % 2 == 0) {
                sum += 3 * (content.charAt(i) - 48);
                continue;
            }
            sum += 9 * (content.charAt(i) - 48);
        }
        String parity = EAN5_PARITY[sum % 10];
        StringBuilder sb = new StringBuilder();
        sb.append("112");
        for (int i = 0; i < 5; ++i) {
            int val = content.charAt(i) - 48;
            if (parity.charAt(i) == 'B') {
                sb.append(EAN_SET_B[val]);
            } else {
                sb.append(EAN_SET_A[val]);
            }
            if (i == 4) continue;
            sb.append("11");
        }
        return sb.toString();
    }
}

