/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import uk.org.okapibarcode.backend.OkapiInputException;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.util.Arrays;

public class Logmars
extends Symbol {
    private static final String[] CODE39LM = new String[]{"1113313111", "3113111131", "1133111131", "3133111111", "1113311131", "3113311111", "1133311111", "1113113131", "3113113111", "1133113111", "3111131131", "1131131131", "3131131111", "1111331131", "3111331111", "1131331111", "1111133131", "3111133111", "1131133111", "1111333111", "3111111331", "1131111331", "3131111311", "1111311331", "3111311311", "1131311311", "1111113331", "3111113311", "1131113311", "1111313311", "3311111131", "1331111131", "3331111111", "1311311131", "3311311111", "1331311111", "1311113131", "3311113111", "1331113111", "1313131111", "1313111311", "1311131311", "1113131311"};
    private static final char[] LOOKUP = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '-', '.', ' ', '$', '/', '+', '%'};
    private double moduleWidthRatio = 3.0;

    public void setModuleWidthRatio(double moduleWidthRatio) {
        this.moduleWidthRatio = moduleWidthRatio;
    }

    public double getModuleWidthRatio() {
        return this.moduleWidthRatio;
    }

    @Override
    protected double getModuleWidth(int originalWidth) {
        if (originalWidth == 1) {
            return 1.0;
        }
        return this.moduleWidthRatio;
    }

    @Override
    protected void encode() {
        if (!this.content.matches("[0-9A-Z\\. \\-$/+%]*")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        int counter = 0;
        int len = this.content.length() * 10 + 29;
        StringBuilder p = new StringBuilder(len);
        p.append("1311313111");
        for (int i = 0; i < this.content.length(); ++i) {
            char c = this.content.charAt(i);
            int val = Arrays.positionOf(c, LOOKUP);
            counter += val;
            p.append(CODE39LM[val]);
        }
        char checkDigit = LOOKUP[counter %= 43];
        this.infoLine("Check Digit: " + checkDigit);
        p.append(CODE39LM[counter]);
        p.append("131131311");
        assert (len == p.length());
        this.readable = this.content + checkDigit;
        this.pattern = new String[]{p.toString()};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }
}

