/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import java.nio.charset.StandardCharsets;
import uk.org.okapibarcode.backend.OkapiInputException;
import uk.org.okapibarcode.backend.QrCode;

public class SwissQrCode
extends QrCode {
    public SwissQrCode() {
        this.minVersion = 6;
        this.preferredEccLevel = QrCode.EccLevel.M;
    }

    @Override
    public void setPreferredEccLevel(QrCode.EccLevel preferredEccLevel) {
        if (preferredEccLevel != QrCode.EccLevel.M) {
            throw new OkapiInputException("Swiss QR Code requires ECC level M");
        }
        super.setPreferredEccLevel(preferredEccLevel);
    }

    @Override
    public void setPreferredVersion(int version) {
        if (version < this.minVersion) {
            throw new OkapiInputException("Swiss QR Code cannot fit logo at sizes less than 6");
        }
        super.setPreferredVersion(version);
    }

    @Override
    public boolean supportsGs1() {
        return false;
    }

    @Override
    public void setContent(String data) {
        byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
        String data2 = new String(bytes, StandardCharsets.ISO_8859_1);
        if (data2.length() > 997) {
            throw OkapiInputException.inputTooLong();
        }
        super.setContent(data2);
    }

    @Override
    protected void customize(int[] grid, int size) {
        int w = (int)((double)size * 0.15217391304347827);
        if (w % 2 == 0) {
            ++w;
        }
        int border = 1;
        int field = w - 2 * border;
        int pad = (int)Math.max((double)(field * 6) / 32.0, 1.0);
        int thick = (int)Math.max((double)(field * 6) / 32.0, 1.0);
        int len = (field - pad - pad - thick) / 2;
        int start = (size + 1) * ((size - w) / 2);
        for (int y = 0; y < w; ++y) {
            for (int x = 0; x < w; ++x) {
                int i = start + y * size + x;
                grid[i] = x == 0 || x == w - 1 || y == 0 || y == w - 1 || x >= border + pad + len && x < w - border - pad - len && y >= border + pad && y < w - border - pad || y >= border + pad + len && y < w - border - pad - len && x >= border + pad && x < w - border - pad ? 0 : 1;
            }
        }
    }
}

