/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import uk.org.okapibarcode.backend.Code128;
import uk.org.okapibarcode.backend.OkapiInputException;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.graphics.Rectangle;
import uk.org.okapibarcode.graphics.TextBox;

public class UspsPackage
extends Symbol {
    @Override
    protected void encode() {
        int start;
        if (!this.content.matches("[0-9\\[\\]]+")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        if (this.content.length() % 2 != 0) {
            throw new OkapiInputException("Invalid IMpb data");
        }
        Code128 code128 = new Code128();
        code128.unsetCc();
        code128.setDataType(Symbol.DataType.GS1);
        code128.setContent(this.content);
        boolean fourTwenty = this.content.length() >= 5 && this.content.charAt(0) == '[' && this.content.charAt(1) == '4' && this.content.charAt(2) == '2' && this.content.charAt(3) == '0' && this.content.charAt(4) == ']';
        StringBuilder hrt = new StringBuilder();
        int n = start = fourTwenty ? this.content.indexOf(91, 5) : 0;
        if (start != -1) {
            int digits = 0;
            for (int i = start; i < this.content.length(); ++i) {
                char c = this.content.charAt(i);
                if (c < '0' || c > '9') continue;
                hrt.append(c);
                if (++digits % 4 != 0) continue;
                hrt.append(' ');
            }
        }
        this.encodeInfo = code128.encodeInfo;
        this.readable = hrt.toString();
        this.pattern = new String[]{code128.pattern[0]};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }

    @Override
    protected void plotSymbol() {
        this.resetPlotElements();
        int offset = 20;
        int yoffset = 15;
        int x = 0;
        int y = yoffset;
        int h = this.default_height;
        boolean black = true;
        for (int xBlock = 0; xBlock < this.pattern[0].length(); ++xBlock) {
            int w = this.pattern[0].charAt(xBlock) - 48;
            if (black) {
                this.rectangles.add(new Rectangle(x + offset, y, w, h));
                this.symbol_width = x + w + 2 * offset;
            }
            black = !black;
            x += w;
        }
        this.symbol_height = h + 2 * yoffset;
        Rectangle topBar = new Rectangle(0.0, 0.0, this.symbol_width, 2.0);
        Rectangle bottomBar = new Rectangle(0.0, this.symbol_height - 2, this.symbol_width, 2.0);
        this.rectangles.add(topBar);
        this.rectangles.add(bottomBar);
        this.texts.add(new TextBox(0.0, 12.0, this.symbol_width, "USPS TRACKING #", this.humanReadableAlignment));
        this.texts.add(new TextBox(0.0, (double)this.symbol_height - 6.0, this.symbol_width, this.readable, this.humanReadableAlignment));
    }

    @Override
    public int getHeight() {
        return this.symbol_height;
    }

    @Override
    protected int[] getCodewords() {
        return this.getPatternAsCodewords(6);
    }
}

