/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.output;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.List;
import uk.org.okapibarcode.backend.OkapiInternalException;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.graphics.Circle;
import uk.org.okapibarcode.graphics.Hexagon;
import uk.org.okapibarcode.graphics.Rectangle;
import uk.org.okapibarcode.graphics.TextAlignment;
import uk.org.okapibarcode.graphics.TextBox;
import uk.org.okapibarcode.output.SymbolRenderer;
import uk.org.okapibarcode.util.Integers;

public class Java2DRenderer
implements SymbolRenderer {
    private final Graphics2D g2d;
    private final double magnification;
    private final uk.org.okapibarcode.graphics.Color paper;
    private final uk.org.okapibarcode.graphics.Color ink;
    private final int rotation;

    public Java2DRenderer(Graphics2D g2d, double magnification, uk.org.okapibarcode.graphics.Color paper, uk.org.okapibarcode.graphics.Color ink) {
        this(g2d, magnification, paper, ink, 0);
    }

    public Java2DRenderer(Graphics2D g2d, double magnification, uk.org.okapibarcode.graphics.Color paper, uk.org.okapibarcode.graphics.Color ink, int rotation) {
        this.g2d = g2d;
        this.magnification = magnification;
        this.paper = paper;
        this.ink = ink;
        this.rotation = Integers.normalizeRotation(rotation);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void render(Symbol symbol) {
        void var11_17;
        Font f;
        int width = (int)((double)symbol.getWidth() * this.magnification);
        int height = (int)((double)symbol.getHeight() * this.magnification);
        int marginX = (int)((double)symbol.getQuietZoneHorizontal() * this.magnification);
        int marginY = (int)((double)symbol.getQuietZoneVertical() * this.magnification);
        AffineTransform oldTransform = null;
        if (this.rotation != 0) {
            oldTransform = this.g2d.getTransform();
            switch (this.rotation) {
                case 90: {
                    this.g2d.rotate(1.5707963267948966);
                    this.g2d.translate(0, -height);
                    break;
                }
                case 180: {
                    this.g2d.rotate(Math.PI);
                    this.g2d.translate(-width, -height);
                    break;
                }
                case 270: {
                    this.g2d.rotate(4.71238898038469);
                    this.g2d.translate(-width, 0);
                }
            }
        }
        if ((f = symbol.getFont()) != null) {
            f = f.deriveFont((float)((double)f.getSize2D() * this.magnification));
        } else {
            f = new Font(symbol.getFontName(), 0, (int)((double)symbol.getFontSize() * this.magnification));
            f = f.deriveFont(Collections.singletonMap(TextAttribute.TRACKING, 0));
        }
        Font oldFont = this.g2d.getFont();
        Color oldColor = this.g2d.getColor();
        if (this.paper != null) {
            this.g2d.setColor(new Color(this.paper.red, this.paper.green, this.paper.blue));
            this.g2d.fillRect(0, 0, width, height);
        }
        this.g2d.setColor(new Color(this.ink.red, this.ink.green, this.ink.blue));
        for (Rectangle rectangle : symbol.getRectangles()) {
            double x = rectangle.x * this.magnification + (double)marginX;
            double y = rectangle.y * this.magnification + (double)marginY;
            double w = rectangle.width * this.magnification;
            double h = rectangle.height * this.magnification;
            this.g2d.fillRect((int)x, (int)y, (int)w, (int)h);
        }
        for (TextBox textBox : symbol.getTexts()) {
            float x;
            TextAlignment alignment = textBox.alignment == TextAlignment.JUSTIFY && textBox.text.length() == 1 ? TextAlignment.CENTER : textBox.alignment;
            Font font = alignment != TextAlignment.JUSTIFY ? f : Java2DRenderer.addTracking(f, textBox.width * this.magnification, textBox.text, this.g2d);
            this.g2d.setFont(font);
            float y = (float)(textBox.y * this.magnification) + (float)marginY;
            switch (alignment) {
                case LEFT: 
                case JUSTIFY: {
                    x = (float)(this.magnification * textBox.x + (double)marginX);
                    break;
                }
                case RIGHT: {
                    x = (float)(this.magnification * textBox.x + this.magnification * textBox.width - Java2DRenderer.getBounds(textBox, this.g2d).getWidth() + (double)marginX);
                    break;
                }
                case CENTER: {
                    x = (float)(this.magnification * textBox.x + this.magnification * textBox.width / 2.0 - Java2DRenderer.getBounds(textBox, this.g2d).getWidth() / 2.0 + (double)marginX);
                    break;
                }
                default: {
                    throw new OkapiInternalException("Unknown alignment: " + (Object)((Object)alignment));
                }
            }
            this.g2d.drawString(textBox.text, x, y);
        }
        if (!symbol.getHexagons().isEmpty()) {
            Polygon polygon = new Polygon();
            for (Hexagon hexagon : symbol.getHexagons()) {
                for (int j = 0; j < 6; ++j) {
                    polygon.addPoint((int)(hexagon.getX(j) * this.magnification + (double)marginX), (int)(hexagon.getY(j) * this.magnification + (double)marginY));
                }
                this.g2d.fill(polygon);
                polygon.reset();
            }
        }
        List<Circle> target = symbol.getTarget();
        boolean bl = false;
        while (var11_17 + true < target.size()) {
            Ellipse2D.Double outer = Java2DRenderer.adjust(target.get((int)var11_17), this.magnification, marginX, marginY);
            Ellipse2D.Double inner = Java2DRenderer.adjust(target.get((int)(var11_17 + true)), this.magnification, marginX, marginY);
            Area area = new Area(outer);
            area.subtract(new Area(inner));
            this.g2d.fill(area);
            var11_17 += 2;
        }
        this.g2d.setFont(oldFont);
        this.g2d.setColor(oldColor);
        if (oldTransform != null) {
            this.g2d.setTransform(oldTransform);
        }
    }

    private static Rectangle2D getBounds(TextBox text, Graphics2D g2d) {
        FontMetrics fm = g2d.getFontMetrics();
        return fm.getStringBounds(text.text, g2d);
    }

    private static Ellipse2D.Double adjust(Circle circle, double magnification, int marginX, int marginY) {
        double x = (double)marginX + (circle.centreX - circle.radius) * magnification;
        double y = (double)marginY + (circle.centreY - circle.radius) * magnification;
        double w = 2.0 * circle.radius * magnification;
        double h = 2.0 * circle.radius * magnification;
        return new Ellipse2D.Double(x, y, w, h);
    }

    private static Font addTracking(Font baseFont, double maxTextWidth, String text, Graphics2D g2d) {
        FontRenderContext frc = g2d.getFontRenderContext();
        double originalWidth = baseFont.getStringBounds(text, frc).getWidth();
        double extraSpace = maxTextWidth - originalWidth;
        double extraSpacePerGap = extraSpace / (double)(text.length() - 1);
        double scaleX = baseFont.isTransformed() ? baseFont.getTransform().getScaleX() : 1.0;
        double tracking = extraSpacePerGap / ((double)baseFont.getSize2D() * scaleX);
        return baseFont.deriveFont(Collections.singletonMap(TextAttribute.TRACKING, tracking));
    }
}

