/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.util;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.List;
import uk.org.okapibarcode.util.Arrays;

public final class EciMode {
    public static final EciMode NONE = new EciMode(-1, null);
    public static List<EciMode> ECIS = Collections.unmodifiableList(java.util.Arrays.asList(EciMode.of(3, "ISO-8859-1"), EciMode.of(4, "ISO-8859-2"), EciMode.of(5, "ISO-8859-3"), EciMode.of(6, "ISO-8859-4"), EciMode.of(7, "ISO-8859-5"), EciMode.of(8, "ISO-8859-6"), EciMode.of(9, "ISO-8859-7"), EciMode.of(10, "ISO-8859-8"), EciMode.of(11, "ISO-8859-9"), EciMode.of(12, "ISO-8859-10"), EciMode.of(13, "ISO-8859-11"), EciMode.of(15, "ISO-8859-13"), EciMode.of(16, "ISO-8859-14"), EciMode.of(17, "ISO-8859-15"), EciMode.of(18, "ISO-8859-16"), EciMode.of(21, "windows-1250"), EciMode.of(22, "windows-1251"), EciMode.of(23, "windows-1252"), EciMode.of(24, "windows-1256"), EciMode.of(20, "Shift_JIS"), EciMode.of(26, "UTF-8"), EciMode.of(0, "IBM437"), EciMode.of(1, "ISO-8859-1"), EciMode.of(2, "IBM437"), EciMode.of(25, "UTF-16BE"), EciMode.of(27, "US-ASCII"), EciMode.of(28, "Big5"), EciMode.of(29, "GB2312"), EciMode.of(30, "EUC-KR"), EciMode.of(31, "GBK"), EciMode.of(32, "GB18030"), EciMode.of(33, "UTF-16LE"), EciMode.of(34, "UTF-32BE"), EciMode.of(35, "UTF-32LE")));
    public final int mode;
    public final Charset charset;

    private EciMode(int mode, Charset charset) {
        this.mode = mode;
        this.charset = charset;
    }

    private static EciMode of(int mode, String charsetName) {
        try {
            return new EciMode(mode, Charset.forName(charsetName));
        }
        catch (UnsupportedCharsetException e) {
            return NONE;
        }
    }

    public static EciMode chooseFor(String data, int ... filter) {
        for (EciMode eci : ECIS) {
            if (eci.charset == null || !eci.charset.canEncode() || !eci.charset.newEncoder().canEncode(data) || filter.length != 0 && !Arrays.contains(filter, eci.mode)) continue;
            return eci;
        }
        return NONE;
    }

    public boolean equals(Object other) {
        return other instanceof EciMode && ((EciMode)other).mode == this.mode;
    }

    public int hashCode() {
        return Integer.hashCode(this.mode);
    }

    public String toString() {
        return "EciMode[mode=" + this.mode + ", charset=" + this.charset + "]";
    }
}

